/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Vector;

class PoolScavenger
implements Runnable {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/PoolScavenger.java, java, j600, j600-201-061220 1.10.1.3 06/08/15 15:26:09";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CLASSNAME = "PoolScavenger";
    private static int tid = 0;
    private long timeout = 300000L;
    private int highThreshold = 10;
    private Vector smcs = new Vector();
    private Vector times = new Vector();
    private boolean quit = false;
    private boolean nonempty = false;
    private Object updateLock = new Object();
    private Thread thread = null;

    PoolScavenger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        if (Trace.isOn) {
            Trace.entry(this, "run");
        }
        long l = 0L;
        StoredManagedConnection storedManagedConnection = null;
        long l2 = 0L;
        while (!this.quit) {
            long l3 = System.currentTimeMillis();
            boolean bl = false;
            Object object = this.updateLock;
            synchronized (object) {
                if (!this.smcs.isEmpty()) {
                    l = (Long)this.times.firstElement() + this.timeout;
                    storedManagedConnection = (StoredManagedConnection)this.smcs.firstElement();
                    l2 = this.smcs.size();
                    this.nonempty = true;
                } else {
                    this.nonempty = false;
                }
                if (!this.quit) {
                    if (this.nonempty) {
                        if (l <= l3 || l2 > (long)this.highThreshold) {
                            if (Trace.isOn) {
                                Trace.trace(2, this, "SMC expired; about to call trigger()");
                            }
                            bl = true;
                        } else {
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(2, this, "Waiting for SMC to expire");
                                }
                                this.updateLock.wait(l - l3);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(2, this, "No SMC in list; waiting");
                            }
                            this.updateLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!bl) continue;
            storedManagedConnection.trigger();
        }
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(StoredManagedConnection storedManagedConnection) {
        if (Trace.isOn) {
            Trace.entry(this, "register");
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.smcs.addElement(storedManagedConnection);
            this.times.addElement(new Long(System.currentTimeMillis()));
            if (Trace.isOn) {
                Trace.trace(2, this, "Notifying scavenger thread");
            }
            this.updateLock.notify();
        }
        if (Trace.isOn) {
            Trace.exit(this, "register");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(StoredManagedConnection storedManagedConnection) {
        if (Trace.isOn) {
            Trace.entry(this, "deregister");
        }
        Object object = this.updateLock;
        synchronized (object) {
            int n = this.smcs.indexOf(storedManagedConnection);
            if (n != -1) {
                this.smcs.removeElementAt(n);
                this.times.removeElementAt(n);
                if (Trace.isOn) {
                    Trace.trace(2, this, "Notifying scavenger thread");
                }
                this.updateLock.notify();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeout(long l) {
        if (Trace.isOn) {
            Trace.entry(this, "setTimeout");
        }
        this.timeout = l;
        if (Trace.isOn) {
            Trace.trace(2, this, "Notifying scavenger thread");
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        if (Trace.isOn) {
            Trace.exit(this, "setTimeout");
        }
    }

    long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxUnusedConnections(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setMaxUnusedConnections");
        }
        this.highThreshold = n;
        if (Trace.isOn) {
            Trace.trace(2, this, "Notifying scavenger thread");
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        if (Trace.isOn) {
            Trace.exit(this, "setMaxUnusedConnections");
        }
    }

    int getMaxUnusedConnections() {
        return this.highThreshold;
    }

    void start() {
        Trace.entry(this, "start");
        this.quit = false;
        if (this.thread == null) {
            Trace.trace(2, this, "Creating new Pool Scavenger thread");
            String string = CLASSNAME + tid;
            ++tid;
            this.thread = MQEnvironment.createThread(this, string, true);
            this.thread.start();
        } else {
            Trace.trace(2, this, "A thread has already been created for this Pool Scavenger");
        }
        Trace.exit(this, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit() {
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, "quit");
            }
            this.quit = true;
            if (Trace.isOn) {
                Trace.trace(2, this, "Notifying scavenger thread");
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.updateLock.notify();
            }
            if (Trace.isOn) {
                Trace.trace(2, this, "Waiting for scavenger thread to end");
            }
            try {
                if (this.thread != null) {
                    this.thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!Trace.isOn) break block10;
                Trace.trace(2, this, "WARNING: Thread was interrupted");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "quit");
        }
    }

    public int inPool() {
        return this.smcs.size();
    }

    public void destroyNext(int n) {
        String string = "destroyNext";
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, string);
        }
        if (this.smcs.isEmpty()) {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, string);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "destroying " + n + " inactive connections");
        }
        StoredManagedConnection storedManagedConnection = null;
        for (int i = 0; i < n && !this.smcs.isEmpty(); ++i) {
            storedManagedConnection = (StoredManagedConnection)this.smcs.firstElement();
            storedManagedConnection.trigger();
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, string);
        }
    }

    static {
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, sccsid);
        }
    }
}

