/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mqservices.Trace;
import java.util.Vector;

public class PeerName {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/PeerName.java, java, j600, j600-201-061220 1.15.1.1 05/05/25 15:42:11";
    private String originalName = null;
    String CN = null;
    String T = null;
    String O = null;
    String L = null;
    String ST = null;
    String C = null;
    Vector OU = new Vector();
    boolean matcher;
    private static final int DNCLEAR = 1;
    private static final int DNSYMBOL = 2;
    private static final int DNVALUE = 3;
    private static final int DNQVALUE = 4;
    private static final int DNFINISHED = 5;

    public PeerName(String string, boolean bl) throws MQException {
        this.originalName = string;
        this.matcher = bl;
        this.parseDN(string);
    }

    public String getDN() {
        return this.originalName;
    }

    private void parseDN(String string) throws MQException {
        int n = 1;
        String string2 = "";
        String string3 = "";
        if (Trace.isOn()) {
            Trace.entry(this, "parseDN(" + string + ")");
        }
        if (string != null && string.equals("")) {
            n = 5;
        }
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (n == 1) {
                    if (c == '\"' || c == ',' || c == ';' || c == '=') {
                        throw new MQException(2, 2399, this);
                    }
                    if (c == ' ' || c == '\t') continue;
                    string2 = string2 + c;
                    n = 2;
                    continue;
                }
                if (n == 2) {
                    if (c == ' ' || c == '\"') {
                        throw new MQException(2, 2399, this);
                    }
                    if (c == '=') {
                        string3 = "";
                        if (i + 1 >= string.length()) {
                            n = 3;
                            continue;
                        }
                        if (string.charAt(i + 1) == '\"') {
                            ++i;
                            n = 4;
                            continue;
                        }
                        n = 3;
                        continue;
                    }
                    string2 = string2 + c;
                    continue;
                }
                if (n == 3) {
                    if (!(c != ',' && c != ';' || i != 0 && string.charAt(i - 1) == '\\')) {
                        n = 1;
                        this.setValue(string2, string3.trim());
                        string2 = "";
                        continue;
                    }
                    string3 = string3 + c;
                    continue;
                }
                if (n == 4) {
                    if (c == '\"' && (i == 0 || string.charAt(i - 1) != '\\')) {
                        n = 5;
                        this.setValue(string2, string3);
                        string2 = "";
                        continue;
                    }
                    string3 = string3 + c;
                    continue;
                }
                if (n != 5) continue;
                if (c == ',' || c == ';') {
                    n = 1;
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                throw new MQException(2, 2399, this);
            }
            if (n == 3) {
                this.setValue(string2, string3.trim());
            }
            if (n == 2 || n == 1) {
                throw new MQException(2, 2399, this);
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn()) {
                Trace.trace(this, "Exception in parser: " + mQException);
            }
            throw mQException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "parseDN");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValue(String string, String string2) throws MQException {
        String string3 = string.toUpperCase();
        if (Trace.isOn()) {
            Trace.trace(this, "PeerName setting " + string + " term to " + string2);
        }
        if (string3.equals("CN")) {
            if (this.CN != null) throw new MQException(2, 2399, this);
            this.CN = string2.toUpperCase();
            return;
        } else if (string3.equals("T")) {
            if (this.T != null) throw new MQException(2, 2399, this);
            this.T = string2.toUpperCase();
            return;
        } else if (string3.equals("O")) {
            if (this.O != null) throw new MQException(2, 2399, this);
            this.O = string2.toUpperCase();
            return;
        } else if (string3.equals("L")) {
            if (this.L != null) throw new MQException(2, 2399, this);
            this.L = string2.toUpperCase();
            return;
        } else if (string3.equals("ST") || string3.equals("SP") || string3.equals("S")) {
            if (this.ST != null) throw new MQException(2, 2399, this);
            this.ST = string2.toUpperCase();
            return;
        } else if (string3.equals("C")) {
            if (this.C != null) throw new MQException(2, 2399, this);
            this.C = string2.toUpperCase();
            return;
        } else if (string3.equals("OU")) {
            this.OU.add(string2.toUpperCase());
            return;
        } else {
            if (!this.matcher) return;
            throw new MQException(2, 2399, this);
        }
    }

    public boolean isMatchingPeerName(PeerName peerName) {
        if (Trace.isOn()) {
            Trace.entry(this, "isMatchingPeerName");
            Trace.trace(this, "Comparing \"" + this.getDN() + "\" with \"" + peerName.getDN() + "\"");
        }
        boolean bl = true;
        if (this.CN != null && !this.wequals(this.CN, peerName.CN)) {
            bl = false;
        }
        if (this.T != null && !this.wequals(this.T, peerName.T)) {
            bl = false;
        }
        if (this.O != null && !this.wequals(this.O, peerName.O)) {
            bl = false;
        }
        if (this.L != null && !this.wequals(this.L, peerName.L)) {
            bl = false;
        }
        if (this.ST != null && !this.wequals(this.ST, peerName.ST)) {
            bl = false;
        }
        if (this.C != null && !this.wequals(this.C, peerName.C)) {
            bl = false;
        }
        if (this.OU.size() > peerName.OU.size()) {
            bl = false;
        } else {
            for (int i = 0; i < this.OU.size(); ++i) {
                if (this.wequals((String)this.OU.elementAt(i), (String)peerName.OU.elementAt(i))) continue;
                bl = false;
            }
        }
        if (Trace.isOn()) {
            Trace.exit(this, "isMatchingPeerName");
        }
        return bl;
    }

    public boolean wequals(String string, String string2) {
        if (Trace.isOn()) {
            Trace.trace(this, "wequals(\"" + string + "\",\"" + string2 + "\"");
        }
        if (string2 == null) {
            return string == null && string.length() != 0;
        }
        String string3 = string2.toUpperCase();
        if (string.equals("*")) {
            return true;
        }
        if (string.charAt(0) == '*') {
            if (string.charAt(string.length() - 1) == '*') {
                return string3.indexOf(string3.substring(1, string.length() - 2)) != -1;
            }
            return string3.endsWith(string.substring(1));
        }
        if (string.charAt(string.length() - 1) == '*' && string.charAt(string.length() - 2) != '\\') {
            return string3.startsWith(string.substring(0, string.length() - 1));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            stringBuffer.deleteCharAt(i);
        }
        String string4 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer(string3);
        for (int i = 0; i < stringBuffer2.length(); ++i) {
            if (stringBuffer2.charAt(i) != '\\') continue;
            stringBuffer2.deleteCharAt(i);
        }
        String string5 = stringBuffer2.toString();
        if (Trace.isOn()) {
            Trace.trace(this, "Comparing " + string4);
        }
        if (Trace.isOn()) {
            Trace.trace(this, "     with " + string5);
        }
        return string4.equals(string5);
    }
}

