/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BatchMatchingCriteria;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.util.Vector;

class MessageBufferManager {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MessageBufferManager.java, java, j600, j600-201-061220 1.8.1.1 05/05/25 15:42:04";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector bufferedMsgs = null;
    private BatchMatchingCriteria bufferCriteria = null;
    private BatchMatchingCriteria testCriteria = null;

    protected MessageBufferManager() {
        if (Trace.isOn) {
            Trace.entry(this, "MessageBufferManager (constructor)");
            Trace.trace(2, this, sccsid);
            Trace.exit(this, "MessageBufferManager (constructor)");
        }
    }

    protected void purgeBuffer(int n, int n2) {
        if (this.bufferedMsgs != null && this.bufferCriteria.hcon == n && this.bufferCriteria.hobj == n2 && !this.bufferedMsgs.isEmpty()) {
            this.bufferedMsgs.clear();
        }
    }

    protected void purgeAllBuffers() {
        if (this.bufferedMsgs != null) {
            this.bufferedMsgs.clear();
        }
    }

    protected boolean bufferExists(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        if (Trace.isOn) {
            Trace.entry(this, "bufferExists");
        }
        boolean bl = false;
        if (this.bufferedMsgs != null && !this.bufferedMsgs.isEmpty()) {
            if (this.testCriteria == null) {
                this.testCriteria = new BatchMatchingCriteria();
            }
            this.testCriteria.set(n, n2, mQMsg2, mQGetMessageOptions);
            bl = this.testCriteria.matches(this.bufferCriteria);
        }
        if (Trace.isOn) {
            Trace.exit(this, "bufferExists");
        }
        return bl;
    }

    protected void bufferMessage(byte[] byArray, BatchMatchingCriteria batchMatchingCriteria) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "bufferMessage");
        }
        if (this.testCriteria == null) {
            this.testCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferCriteria == null) {
            this.bufferCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferedMsgs == null) {
            this.bufferedMsgs = new Vector();
        }
        if (this.bufferedMsgs.isEmpty()) {
            this.bufferCriteria.set(batchMatchingCriteria);
        } else {
            this.testCriteria.set(batchMatchingCriteria);
            if (!this.bufferCriteria.matches(this.testCriteria)) {
                if (Trace.isOn) {
                    Trace.exit(this, "bufferMessage (via exception");
                }
                throw new MQInternalException(2, 2195, 117, "inconsistent buffering");
            }
        }
        this.bufferedMsgs.addElement(byArray);
        if (Trace.isOn) {
            Trace.exit(this, "bufferMessage");
        }
    }

    protected byte[] getBufferedMessage(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getBufferedMessage");
        }
        if (this.bufferedMsgs == null || this.bufferedMsgs.isEmpty() || !this.bufferExists(n, n2, mQMsg2, mQGetMessageOptions)) {
            if (Trace.isOn) {
                Trace.exit(this, "getBufferedMessage via exception");
            }
            throw new MQInternalException(2, 2195, 117, "Batched buffer underflow");
        }
        byte[] byArray = (byte[])this.bufferedMsgs.firstElement();
        this.bufferedMsgs.remove(0);
        if (Trace.isOn) {
            Trace.exit(this, "getBufferedMessage");
        }
        return byArray;
    }

    protected boolean canCreateNewBuffer() {
        return this.bufferedMsgs == null || this.bufferedMsgs.isEmpty();
    }
}

