/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQBindingsManagedConnectionFactory;
import com.ibm.mq.MQBindingsManagedConnectionFactoryJ11;
import com.ibm.mq.MQClientManagedConnectionFactory;
import com.ibm.mq.MQClientManagedConnectionFactoryJ11;
import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQJDConnectionRequestInfo;
import com.ibm.mq.MQJDManagedConnectionFactory;
import com.ibm.mq.MQJDManagedConnectionFactoryJ11;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mq.MQSESSIONServer;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mqservices.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.resource.spi.ConnectionRequestInfo;
import javax.sql.XAConnection;

public abstract class MQSESSION {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQSESSION.java, java, j600, j600-201-070208 1.77.1.9 07/01/12 09:09:39";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSION";
    private static final String LIBVERSION = "05";
    protected MQManagedConnectionJ11 mqManCon = null;
    protected static final int ENC_ASCII = 1;
    protected static final int ENC_EBCDIC = 2;
    protected static boolean zSeries = false;
    protected static boolean iSeries = false;
    protected static boolean zSeries64 = false;
    protected boolean supportsQAT2 = false;
    protected boolean authenticateBindings = false;
    private static String libraryName;
    private static final Object libNameLock;
    private static final int CHARINITARRAYSIZE = 100;
    private static char[] charInitArray;

    protected abstract void MQCLOSE(int var1, Pint var2, int var3, Pint var4, Pint var5);

    protected abstract void MQCONN(String var1, Pint var2, Pint var3, Pint var4, Pthrowable var5);

    protected abstract void MQDISC(Pint var1, Pint var2, Pint var3);

    protected abstract void MQGET(int var1, int var2, MQMD var3, MQGetMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8, Pint var9);

    protected abstract void MQGET(int var1, int var2, MQMsg2 var3, MQGetMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8, Pint var9);

    protected abstract void MQINQ(int var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, byte[] var8, Pint var9, Pint var10);

    protected abstract String MQINQ(int var1, int var2, int var3, int var4, Pint var5, Pint var6);

    protected abstract void MQOPEN(int var1, MQOD var2, int var3, Pint var4, Pint var5, Pint var6);

    protected abstract void MQPUT(int var1, int var2, MQMD var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT1(int var1, MQOD var2, MQMD var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT1(int var1, MQOD var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQSET(int var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, byte[] var8, Pint var9, Pint var10);

    protected abstract void MQSET(int var1, int var2, int var3, String var4, int var5, Pint var6, Pint var7);

    protected abstract void MQCONNX(String var1, MQConnectionOptions var2, Pint var3, Pint var4, Pint var5, Pthrowable var6);

    protected abstract void MQBACK(int var1, Pint var2, Pint var3);

    protected abstract void MQBEGIN(int var1, Pint var2, Pint var3);

    protected abstract void MQCMIT(int var1, Pint var2, Pint var3);

    protected abstract void spiConnect(String var1, MQConnectionOptions var2, Pint var3, Pint var4, Pint var5, Pthrowable var6) throws MQException;

    protected abstract boolean spiSupportsDeferred();

    protected abstract void spiDefPut(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void spiDefActivate(int var1, byte[] var2, Pint var3, Pint var4);

    protected abstract void spiDefCancel(int var1, byte[] var2, Pint var3, Pint var4);

    protected abstract boolean spiSupportsInherited();

    protected abstract void spiAsyncCmit(int var1, Pint var2, Pint var3);

    protected void spiBatchedGet(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
    }

    protected abstract void spiGet(int var1, int var2, MQMsg2 var3, MQGetMessageOptions var4, int var5, int var6, byte[] var7, Pint var8, Pint var9, Pint var10) throws MQException;

    protected abstract void spiPut(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, int var6, byte[] var7, Pint var8, Pint var9);

    protected boolean authenticate(int n, String string, String string2, Pint pint, Pint pint2) {
        pint.x = 0;
        pint2.x = 0;
        return true;
    }

    protected int getMaxMessageSizeForBatch() {
        return 0;
    }

    protected abstract void setThreadAccess(String var1, Boolean var2) throws MQException;

    protected abstract void resolveV2Support(int var1, int var2, Pint var3, Pint var4);

    protected abstract boolean supportsV2Structures(int var1);

    final void honourRRS(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(clsName, "honourRRS");
        }
        if (zSeries) {
            if (!MQSESSION.getLibraryName().startsWith("wmqjrrs")) {
                if (Trace.isOn) {
                    Trace.trace(1, clsName, "honourRRS called outside WebSphere!");
                }
                pint.x = 2;
                pint2.x = 2012;
            } else {
                this.honourRRSInternal(n, pint, pint2);
            }
        } else {
            pint.x = 2;
            pint2.x = 2012;
            if (Trace.isOn) {
                Trace.trace(1, clsName, "honourRRS called outside OS/390!");
            }
        }
        if (Trace.isOn) {
            Trace.exit(clsName, "honourRRS");
        }
    }

    protected abstract void honourRRSInternal(int var1, Pint var2, Pint var3);

    static MQSESSION getSession(MQManagedConnectionJ11 mQManagedConnectionJ11) throws MQException {
        Trace.entry("com.ibm.mq.MQSESSION", "getSession - mancon = " + mQManagedConnectionJ11);
        MQSESSION mQSESSION = null;
        boolean bl = false;
        String string = mQManagedConnectionJ11.getStringProperty("transport");
        try {
            String string2 = mQManagedConnectionJ11.getStringProperty("hostname", "");
            if (string.equals("MQSeries Bindings") || string.equals("MQSeries") && string2.equals("")) {
                mQSESSION = MQSESSIONServer.getMQSESSION();
                if (zSeries && bl) {
                    mQSESSION.setAuthenticateBindings(true);
                } else {
                    mQSESSION.mqManCon = mQManagedConnectionJ11;
                }
            }
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(1, clsName, "getSESSION exception: " + exception);
            }
            System.err.println(exception);
        }
        if (mQSESSION == null && string.equals("MQJD")) {
            mQSESSION = new com.ibm.mq.mqjd.MQSESSION();
            mQSESSION.mqManCon = mQManagedConnectionJ11;
        }
        if (mQSESSION == null && (!zSeries || string.equals("MQSeries Client") && MQEnvironment.forceAllowClientConnection())) {
            mQSESSION = new MQSESSIONClient();
            mQSESSION.mqManCon = mQManagedConnectionJ11;
        }
        if (mQSESSION == null) {
            if (Trace.isOn) {
                Trace.exit(clsName, "getSession - via exception");
            }
            throw new MQException(2, 2298, "static method in MQSESSION");
        }
        mQSESSION.setThreadAccess(mQManagedConnectionJ11.getStringProperty("Thread access"), (Boolean)mQManagedConnectionJ11.getProperty("Thread affinity"));
        Trace.exit("com.ibm.mq.MQSESSION", "getSession");
        return mQSESSION;
    }

    static final MQManagedConnectionFactory getMQManagedConnectionFactory(String string, String string2, Hashtable hashtable, boolean bl) throws MQException {
        if (string.equals("MQSeries Bindings")) {
            if (bl) {
                return new MQBindingsManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQBindingsManagedConnectionFactory(string2, hashtable);
        }
        if (string.equals("MQSeries Client")) {
            if (bl) {
                return new MQClientManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQClientManagedConnectionFactory(string2, hashtable);
        }
        if (string.equals("MQJD")) {
            if (bl) {
                return new MQJDManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQJDManagedConnectionFactory(string2, hashtable);
        }
        throw new MQException(2, 2012, "static method in MQSESSION");
    }

    static final ConnectionRequestInfo getConnectionRequestInfo(String string, Hashtable hashtable, boolean bl) throws MQException {
        if (string.equals("MQSeries Bindings")) {
            return new BindingsConnectionRequestInfo(hashtable);
        }
        if (string.equals("MQSeries Client") && (!zSeries || MQEnvironment.forceAllowClientConnection())) {
            return new ClientConnectionRequestInfo(hashtable, bl);
        }
        if (string.equals("MQJD")) {
            return new MQJDConnectionRequestInfo(hashtable);
        }
        throw new MQException(2, 2012, "static method in MQSESSION");
    }

    protected static final String getLibraryName() {
        String string = "";
        if (Trace.isOn) {
            Trace.entry(clsName, "getLibraryName");
        }
        string = iSeries ? "mqjbnd05" : (zSeries ? MQSESSION.get390LibraryName() : "mqjbnd05");
        if (Trace.isOn) {
            Trace.trace(3, "getLibraryName", string);
            Trace.exit(clsName, "getLibraryName");
        }
        return string;
    }

    private static native String adapter_detect();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String get390LibraryName() {
        if (Trace.isOn) {
            Trace.entry(clsName, "get390LibraryName");
        }
        Object object = libNameLock;
        synchronized (object) {
            if (libraryName == null && zSeries64) {
                libraryName = MQSESSION.get390LibraryName64();
            } else if (libraryName == null) {
                String string;
                int n = 0;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            System.loadLibrary("wmqjbind");
                            return null;
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.websphere.ServerType");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                if (string2 != null) {
                    if (Trace.isOn) {
                        Trace.trace(3, "get390LibraryName", "WebSphere detected - com.ibm.websphere.ServerType is " + string2 + "");
                    }
                    n = 2;
                } else {
                    string = MQSESSION.adapter_detect();
                    if (string.equals("wmqjcics")) {
                        if (Trace.isOn) {
                            Trace.trace(3, "get390LibraryName", "CICS detected");
                        }
                        n = 1;
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(3, "get390LibraryName", "Neither CICS nor WebSphere detected");
                        }
                        n = 0;
                    }
                }
                string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.mq.adapter");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                if (string == null) {
                    switch (n) {
                        case 0: {
                            libraryName = "wmqjbatch";
                            break;
                        }
                        case 1: {
                            libraryName = "wmqjcics";
                            break;
                        }
                        case 2: {
                            libraryName = "wmqjrrs";
                        }
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(3, "get390LibraryName", "com.ibm.mq.adapter is " + string);
                    }
                    if ((string = string.trim().toLowerCase()).equals("batch")) {
                        if (n == 0 || n == 2) {
                            libraryName = "wmqjbatch";
                        }
                    } else if (string.equals("cics")) {
                        if (n == 1) {
                            libraryName = "wmqjcics";
                        }
                    } else if (string.equals("rrs") && (n == 0 || n == 2)) {
                        libraryName = "wmqjrrs";
                    }
                }
                if (libraryName == null) {
                    Error error = new Error(MQException.getNLSMsg(68, string));
                    if (Trace.isOn) {
                        Trace.trace(3, "get390LibraryName", "Invalid com.ibm.mq.adapter for this environment");
                    }
                    if (Trace.isOn) {
                        Trace.exit(clsName, "get390LibraryName (via Error)");
                    }
                    throw error;
                }
            }
        }
        if (Trace.isOn) {
            Trace.trace(3, "get390LibraryName", libraryName);
            Trace.exit(clsName, "get390LibraryName");
        }
        return libraryName;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String get390LibraryName64() {
        String string;
        String string2;
        block18: {
            if (Trace.isOn) {
                Trace.entry(clsName, "get390LibraryName64");
            }
            if (!zSeries64) {
                if (Trace.isOn) {
                    Trace.trace(3, "get390LibraryName64", "Did not detect 64-bit environment");
                    Trace.exit(clsName, "get390LibraryName64");
                }
                return null;
            }
            string2 = null;
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("com.ibm.websphere.ServerType");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            };
            PrivilegedAction privilegedAction2 = new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("com.ibm.mq.adapter");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            };
            int n = 0;
            String string3 = (String)AccessController.doPrivileged(privilegedAction);
            if (string3 != null) {
                if (Trace.isOn) {
                    Trace.trace(3, "get390LibraryName64", "WebSphere detected - com.ibm.websphere.ServerType is " + string3 + "");
                }
                n = 2;
            } else {
                if (Trace.isOn) {
                    Trace.trace(3, "get390LibraryName64", "WebSphere not detected - assuming batch");
                }
                n = 0;
            }
            string = (String)AccessController.doPrivileged(privilegedAction2);
            if (string == null) {
                if (n == 2) {
                    string2 = "wmqjrrs64";
                    break block18;
                } else {
                    Error error = new Error(MQException.getNLSMsg(127));
                    if (Trace.isOn) {
                        Trace.trace(3, "get390LibraryName64", "In 64-bit mode, but did not detect WebSphere");
                        Trace.exit(clsName, "get390LibraryName64 (via Error)");
                    }
                    throw error;
                }
            }
            if (Trace.isOn) {
                Trace.trace(3, "get390LibraryName64", "com.ibm.mq.adapter is " + string);
            }
            if ((string = string.trim().toLowerCase()).equals("rrs")) {
                string2 = "wmqjrrs64";
            } else {
                Error error = new Error(MQException.getNLSMsg(127));
                if (Trace.isOn) {
                    Trace.trace(3, "get390LibraryName64", "Not permitted to use non-RRS adapter in 64-bit mode");
                    Trace.exit(clsName, "get390LibraryName64 (via Error)");
                }
                throw error;
            }
        }
        if (string2 == null) {
            Error error = new Error(MQException.getNLSMsg(126, string));
            if (Trace.isOn) {
                Trace.trace(3, "get390LibraryName64", "Invalid com.ibm.mq.adapter for this environment");
                Trace.exit(clsName, "get390LibraryName64 (via Error)");
            }
            throw error;
        }
        if (Trace.isOn) {
            Trace.trace(3, "get390LibraryName64", string2);
            Trace.exit(clsName, "get390LibraryName64");
        }
        return string2;
    }

    public static final String getLibraryPath() {
        String string = "";
        if (Trace.isOn) {
            Trace.entry(clsName, "getLibraryPath");
        }
        if (iSeries) {
            string = "/QSYS.LIB/QMQMJAVA.LIB/";
            if (Trace.isOn) {
                Trace.exit(clsName, "getLibraryPath");
            }
            return string;
        }
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(clsName, "path '" + string + "'");
                Trace.exit(clsName, "getLibraryPath");
            }
            return string;
        }
        if (Trace.isOn) {
            Trace.trace(clsName, "path '" + string + "'");
            Trace.exit(clsName, "getLibraryPath");
        }
        return string;
    }

    public static final void loadLib(String string) {
        if (iSeries) {
            if (Trace.isOn) {
                Trace.entry(clsName, "loadLib (iSeries)");
            }
            String string2 = string.toUpperCase() + ".SRVPGM";
            if (Trace.isOn) {
                Trace.trace(clsName, "  Load this library: '" + string2 + "'");
            }
            System.load(string2);
        } else {
            if (Trace.isOn) {
                Trace.entry(clsName, "loadLib");
                Trace.trace(clsName, "  Load this library: '" + string + "'");
            }
            System.loadLibrary(string);
        }
        if (Trace.isOn) {
            Trace.exit(clsName, "loadLib");
        }
    }

    protected static final int getDefaultCCSID() {
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "getDefaultCCSID", "500");
            }
            return 500;
        }
        if (Trace.isOn) {
            Trace.trace(3, "getDefaultCCSID", "819");
        }
        return 819;
    }

    protected int getCharEncoding() {
        if (iSeries || zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "getCharEncoding", "ENC_EBCDIC");
            }
            return 2;
        }
        if (Trace.isOn) {
            Trace.trace(3, "getCharEncoding", "ENC_ASCII");
        }
        return 1;
    }

    public boolean distributionListCapable(int n) {
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "distributionListCapable", "false");
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.entry(this, "distributionListCapable");
            Trace.exit(this, "distributionListCapable");
        }
        return true;
    }

    protected static final String getProductPrefix() {
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "getProductPrefix", "CSQ");
            }
            return "CSQ";
        }
        if (Trace.isOn) {
            Trace.trace(3, "getProductPrefix", "AMQ");
        }
        return "AMQ";
    }

    protected static final GregorianCalendar getInquireCalendar() {
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "getInquireCalendar", "GMT");
            }
            return new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return new GregorianCalendar();
    }

    protected static final boolean backoutOnImplicitDisc() {
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(3, "backoutOnImplicitDisc", "false");
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.trace(3, "backoutOnImplicitDisc", "true");
        }
        return true;
    }

    public static String setStringToLength(String string, int n) {
        if (Trace.isOn) {
            Trace.entry(clsName, "setStringToLength");
        }
        String string2 = null;
        if (string != null && string.length() == n) {
            if (Trace.isOn) {
                Trace.exit(clsName, "setStringToLength");
            }
            return string;
        }
        if (string == null) {
            if (n <= 100) {
                string2 = new String(charInitArray, 0, n);
            } else {
                StringBuffer stringBuffer = new StringBuffer(n);
                for (int i = n; i > 0; i -= 100) {
                    if (i > 100) {
                        stringBuffer.append(charInitArray);
                        continue;
                    }
                    stringBuffer.append(charInitArray, 0, i);
                }
                string2 = stringBuffer.toString();
            }
        } else if (string.length() > n) {
            try {
                string2 = string.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (Trace.isOn) {
                    Trace.trace(1, clsName, "setStringToLength - index error");
                }
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.ensureCapacity(n);
            for (int i = n - string.length(); i > 0; i -= 100) {
                if (i > 100) {
                    stringBuffer.append(charInitArray);
                    continue;
                }
                stringBuffer.append(charInitArray, 0, i);
            }
            string2 = stringBuffer.toString();
        }
        if (Trace.isOn) {
            Trace.exit(clsName, "setStringToLength");
        }
        return string2;
    }

    public void XAREGISTER(XAConnection xAConnection) throws MQException, SQLException, Exception {
        throw new MQException(2, 2012, this);
    }

    public void deregisterResource(XAConnection xAConnection) throws Exception {
        throw new MQException(2, 2012, this);
    }

    protected int getConnectionCCSID() {
        return MQSESSION.getDefaultCCSID();
    }

    public boolean getAuthenticateBindings() {
        return this.authenticateBindings;
    }

    public void setAuthenticateBindings(boolean bl) {
        this.authenticateBindings = bl;
    }

    protected void updateDestinationCounts(MQPutMessageOptions mQPutMessageOptions, Pint pint, Pint pint2) {
        if (zSeries) {
            if (pint.x == 2) {
                mQPutMessageOptions.knownDestCount = 0;
                mQPutMessageOptions.unknownDestCount = 0;
                mQPutMessageOptions.invalidDestCount = 1;
            } else {
                mQPutMessageOptions.knownDestCount = 0;
                mQPutMessageOptions.unknownDestCount = 1;
                mQPutMessageOptions.invalidDestCount = 0;
            }
        }
    }

    public boolean getSupportsQAT2() {
        return this.supportsQAT2;
    }

    static {
        PrivilegedAction privilegedAction = null;
        PrivilegedAction privilegedAction2 = null;
        privilegedAction = new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("os.name");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        };
        privilegedAction2 = new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.vm.bitmode");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        };
        String string = (String)AccessController.doPrivileged(privilegedAction);
        if (string.equals("OS/390") || string.equals("z/OS")) {
            zSeries = true;
            zSeries64 = "64".equals(AccessController.doPrivileged(privilegedAction2));
        } else if (string.equals("OS/400") || string.equals("OS400")) {
            iSeries = true;
        }
        libraryName = null;
        libNameLock = new Object();
        charInitArray = null;
        charInitArray = new char[100];
        for (int i = 0; i < 100; ++i) {
            MQSESSION.charInitArray[i] = 32;
        }
    }
}

