/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQChannelHeader;
import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQDistributionList;
import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQExternalReceiveExit;
import com.ibm.mq.MQExternalSecurityExit;
import com.ibm.mq.MQExternalSendExit;
import com.ibm.mq.MQExternalUserExit;
import com.ibm.mq.MQJavaLevel;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQProcess;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManagerFactory;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQReceiveExitChain;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.MQSendExitChain;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mq.Pint;
import com.ibm.mq.QueueManagerFactoryProperties;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.SSLCRLHelper;
import com.ibm.mq.SSLHelper;
import com.ibm.mq.XAtoJTA;
import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XADataSource;

public class MQQueueManager
extends MQManagedObject {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQQueueManager.java, java, j600, j600-202-070608 1.137.1.13 07/01/19 16:26:49";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String clsName = "MQQueueManager";
    private static final int MQOT_Q = 1;
    private static final int MQOT_PROCESS = 3;
    private static final int MQOT_Q_MGR = 5;
    private static final int RECEIVE_EXIT = 1;
    private static final int SECURITY_EXIT = 2;
    private static final int SEND_EXIT = 3;
    protected static final int MQ_Q_NAME_LENGTH = 48;
    protected static final int MQIA_CODED_CHAR_SET_ID = 2;
    protected static final int MQIA_MAX_MSG_LENGTH = 13;
    protected static final int MQIA_COMMAND_LEVEL = 31;
    protected static final int MQCA_COMMAND_INPUT_Q_NAME = 2003;
    protected static final int MQIA_MAX_PRIORITY = 14;
    protected static final int MQIA_SYNCPOINT = 30;
    private Vector queues;
    private Vector processes;
    private Vector distributionLists;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private MQManagedConnectionJ11 mqManCon = null;
    private MQException latestConnectMQE = null;
    private MQQueueManager copy = null;
    private MQQueueManager original = null;
    private MQException exceptionForDisconnect = null;
    private boolean allowErrorEvents = false;
    private boolean forSPI = false;
    private boolean inheritTx = false;
    private boolean asyncCmt = false;
    private boolean supportsQAT2 = false;
    private static MQQueueManagerFactory factory = null;
    int association = 0;
    public boolean isConnected = false;
    protected boolean connectStatus = false;
    private URL cdUrl;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getJDBCConnection(XADataSource xADataSource) throws MQException, SQLException, Exception {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getJDBCConnection");
            }
            Connection connection = this.getJDBCConnection(xADataSource, null, null);
            return connection;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getJDBCConnection");
            }
        }
    }

    public Connection getJDBCConnection(XADataSource xADataSource, String string, String string2) throws MQException, SQLException, Exception {
        Object var4_4 = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getJDBCConnection");
                Trace.trace(this, "xads=" + xADataSource);
                Trace.trace(this, "userid=" + string);
                if (string2 != null) {
                    Trace.trace(this, "password is not-null");
                    Trace.trace(this, "password length=" + string2.length());
                } else {
                    Trace.trace(this, "password is null");
                }
            }
            if (!this.connectStatus) {
                throw new MQException(2, 2018, (Object)this, 2);
            }
            if (this.mqManCon.getIntegerProperty("connectOptions", 0) == 1) {
                throw new MQException(2, 2012, this);
            }
            Connection connection = XAtoJTA.helpGetConnection(xADataSource, string, string2, this.osession);
            return connection;
        }
        catch (SQLException sQLException) {
            if (Trace.isOn) {
                Trace.trace(this, "failure, throwing: " + sQLException);
            }
            throw sQLException;
        }
        catch (MQException mQException) {
            if (mQException.reasonCode == 2003) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "Attempting backout after registerResource failed to reregister existing connection");
                    }
                    this.backout();
                    if (Trace.isOn) {
                        Trace.trace(this, "Backout successful - throwing rollback error back to application");
                    }
                }
                catch (MQException mQException2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Backout failed - throwing " + mQException);
                    }
                    throw mQException2;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "failure, throwing: " + mQException);
            }
            throw mQException;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "failure, throwing: " + exception);
            }
            throw exception;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getJDBCConnection");
            }
        }
    }

    public boolean isConnected() {
        return this.connectStatus;
    }

    public int getCharacterSet() throws MQException {
        return this.getInt(2);
    }

    public int getMaximumMessageLength() throws MQException {
        return this.getInt(13);
    }

    public int getCommandLevel() throws MQException {
        return this.getInt(31);
    }

    public String getCommandInputQueueName() throws MQException {
        return this.getString(2003, 48);
    }

    public int getMaximumPriority() throws MQException {
        return this.getInt(14);
    }

    public int getSyncpointAvailability() throws MQException {
        return this.getInt(30);
    }

    public boolean getDistributionListCapable() {
        return this.osession.distributionListCapable(this.Hconn.x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setMgr(this);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, int n) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (MQCONNX)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setMgr(this);
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("connectOptions", new Integer(n));
            queueManagerFactoryProperties.setProperties(hashtable);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (MQCONNX)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, Hashtable hashtable) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String,Hashtable)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setProperties(hashtable);
            queueManagerFactoryProperties.setMgr(this);
            if (hashtable.containsKey("QMgr_Association")) {
                int n = MQEnvironment.getIntegerProperty("QMgr_Association", hashtable);
                this.initialize(factory.createQueueManager(n, queueManagerFactoryProperties));
            } else {
                this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            }
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, Hashtable)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, MQConnectionManager mQConnectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, MQConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setConMgr(mQConnectionManager);
            queueManagerFactoryProperties.setMgr(this);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, MQConnectionManager)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, int n, MQConnectionManager mQConnectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, int, MQConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setMgr(this);
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("connectOptions", new Integer(n));
            queueManagerFactoryProperties.setProperties(hashtable);
            queueManagerFactoryProperties.setConMgr(mQConnectionManager);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, int, MQConnectionManager)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, Hashtable, MQConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setMgr(this);
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setProperties(hashtable);
            queueManagerFactoryProperties.setConMgr(mQConnectionManager);
            if (hashtable.containsKey("QMgr_Association")) {
                int n = MQEnvironment.getIntegerProperty("QMgr_Association", hashtable);
                this.initialize(factory.createQueueManager(n, queueManagerFactoryProperties));
            } else {
                this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            }
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, Hashtable, MQConnectionManager)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, ConnectionManager connectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, ConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setConMgr(connectionManager);
            queueManagerFactoryProperties.setMgr(this);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, ConnectionManager)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, int n, ConnectionManager connectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, int, ConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setMgr(this);
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("connectOptions", new Integer(n));
            queueManagerFactoryProperties.setProperties(hashtable);
            queueManagerFactoryProperties.setConMgr(connectionManager);
            this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, int, ConnectionManager)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor (String, Hashtable, ConnectionManager)");
            Trace.trace(2, this, sccsid);
        }
        try {
            QueueManagerFactoryProperties queueManagerFactoryProperties = new QueueManagerFactoryProperties();
            queueManagerFactoryProperties.setName(string);
            queueManagerFactoryProperties.setProperties(hashtable);
            queueManagerFactoryProperties.setConMgr(connectionManager);
            queueManagerFactoryProperties.setMgr(this);
            if (hashtable.containsKey("QMgr_Association")) {
                int n = MQEnvironment.getIntegerProperty("QMgr_Association", hashtable);
                this.initialize(factory.createQueueManager(n, queueManagerFactoryProperties));
            } else {
                this.initialize(factory.createQueueManager(0, queueManagerFactoryProperties));
            }
            this.allowErrorEvents = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor (String, Hashtable, ConnectionManager)");
            }
        }
    }

    public MQQueueManager(String string, URL uRL) throws MQException {
        String string2 = "MQQueueManager constructor (String, URL)";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
        }
        this.cdUrl = uRL;
        this.sequentialConstruct(string, uRL, null, null, null);
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    public MQQueueManager(String string, Hashtable hashtable, URL uRL) throws MQException {
        String string2 = "MQQueueManager constructor (String, Properties, URL)";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
        }
        this.cdUrl = uRL;
        this.sequentialConstruct(string, uRL, null, null, hashtable);
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    private void sequentialConstruct(String string, URL uRL, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager, Hashtable hashtable) throws MQException {
        String string2 = "sequentialConstruct";
        if (Trace.isOn) {
            Trace.entry(this, string2);
        }
        Hashtable hashtable2 = hashtable;
        Object object = null;
        boolean bl = false;
        Vector<Object> vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        String string3 = MQEnvironment.channel;
        String string4 = (String)MQEnvironment.properties.get("channel");
        if (string4 == null && hashtable != null) {
            string4 = (String)hashtable.get("channel");
        }
        if ((string3 != null && string3.length() > 1 || string4 != null && string4.length() > 1) && (string4 == null || !string4.equals("SYSTEM.DEF.SVRCONN"))) {
            if (Trace.isOn()) {
                Trace.trace(this, "Error: Attempting to use CCDT when a channel name is specified in MQEnvironment");
            }
            MQException mQException = new MQException(2, 2423, this);
            if (Trace.isOn) {
                Trace.exceptionTrace(5, this, mQException);
            }
            throw mQException;
        }
        if (string == null) {
            string = "";
        } else if ((string = string.trim()).startsWith("*") || string.endsWith("*")) {
            bl = true;
        }
        try {
            SortedMap sortedMap = MQChannelHeader.prepareURL(uRL);
            vector = new Vector<Object>();
            vector2 = new Vector();
            if (Trace.isOn) {
                Trace.trace(this, "Building the key and object vector for channelDefinition");
            }
            while (sortedMap.size() > 0) {
                object = sortedMap.firstKey();
                Object v = sortedMap.get(object);
                vector.addElement(object);
                vector2.addElement(v);
                sortedMap.remove(object);
                if (!object.equals(MQChannelHeader.crlKey)) continue;
                vector3 = (Vector)v;
            }
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(this, "Problem extracting information from channel definition");
            }
            if (Trace.isOn) {
                Trace.exit(this, string2);
            }
            throw new MQException(2, 2278, this);
        }
        boolean bl2 = MQException.isExcluded(2009);
        boolean bl3 = MQException.isExcluded(2059);
        MQException.logExclude(new Integer(2009));
        MQException.logExclude(new Integer(2059));
        boolean bl4 = false;
        if (Trace.isOn) {
            Trace.trace(this, "Look for existing connections which can be reused");
        }
        if (!(bl4 = this.loopSearch(true, vector, vector2, string, bl, hashtable2, uRL, vector3, mQConnectionManager, connectionManager))) {
            if (Trace.isOn) {
                Trace.trace(this, "Loop around, trying to make new connections");
            }
            bl4 = this.loopSearch(false, vector, vector2, string, bl, hashtable2, uRL, vector3, mQConnectionManager, connectionManager);
        }
        if (!bl2) {
            if (Trace.isOn) {
                Trace.trace(this, "Connection was broken");
            }
            MQException.logInclude(new Integer(2009));
        }
        if (!bl3) {
            if (Trace.isOn) {
                Trace.trace(this, "Queue Manager not available");
            }
            MQException.logInclude(new Integer(2059));
        }
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
        if (!bl4) {
            if (this.latestConnectMQE != null) {
                throw this.latestConnectMQE;
            }
            throw new MQException(2, 2278, this);
        }
    }

    private boolean loopSearch(boolean bl, Vector vector, Vector vector2, String string, boolean bl2, Hashtable hashtable, URL uRL, Vector vector3, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager) throws MQException {
        String string2 = "loopSearch";
        if (Trace.isOn) {
            Trace.entry(this, string2);
        }
        boolean bl3 = false;
        String string3 = string;
        if (string3.startsWith("*")) {
            string3 = string3.substring(1, string3.length());
        }
        for (int i = 0; i < vector.size(); ++i) {
            MQChannelHeader mQChannelHeader;
            String string4;
            String string5 = (String)vector.elementAt(i);
            if (string5.equals(MQChannelHeader.crlKey) || (string4 = (mQChannelHeader = (MQChannelHeader)vector2.elementAt(i)).getShortConName()).length() <= 0) continue;
            String string6 = mQChannelHeader.getQmName();
            if (string6.equals("*")) {
                string6 = "";
            }
            if (!string3.equals(string6)) continue;
            try {
                hashtable = MQQueueManager.getProperties(hashtable, string5, mQChannelHeader, uRL);
                hashtable.put("transport", "MQSeries Client");
                ArrayList arrayList = new ArrayList();
                if (vector3 != null) {
                    Enumeration enumeration = vector3.elements();
                    while (enumeration.hasMoreElements()) {
                        Object var22_23 = null;
                        var22_23 = enumeration.nextElement();
                        try {
                            SSLCRLHelper.addMQCrlCertStore(var22_23, arrayList);
                        }
                        catch (Exception exception) {}
                    }
                    hashtable.put("SSL CertStores", arrayList);
                } else {
                    hashtable.put("SSL CertStores", arrayList);
                }
            }
            catch (IOException iOException) {
                if (Trace.isOn) {
                    Trace.exit(this, string2);
                }
                throw new MQException(2, 2278, this);
            }
            try {
                if (bl) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Attempting to recycle a connection for Qmgr Name : " + string);
                    }
                    bl3 = this.recycle(string, hashtable, mQConnectionManager, connectionManager);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Attempting to create a connection for Qmgr Name : " + string);
                    }
                    bl3 = this.construct(string, hashtable, mQConnectionManager, connectionManager);
                }
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Exception caught trying to connect via a CCDT definition");
                    Trace.exceptionTrace(5, this, mQException);
                    Trace.trace(this, "Ignoring Exception and continuing with other Channel Definitions in the table");
                }
                this.latestConnectMQE = mQException;
            }
            if (bl3 && !bl2 && !this.pszName.equals(string)) {
                bl3 = false;
            }
            if (!bl3) continue;
            this.allowErrorEvents = true;
            ((MQSESSIONClient)this.osession).maxMessageSize = (int)mQChannelHeader.getMaxMessageLength();
            break;
        }
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
        return bl3;
    }

    public MQQueueManager(String string, URL uRL, ConnectionManager connectionManager) throws MQException {
        String string2 = "MQQueueManager constructor (String, URL, ConnectionManager)";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
        }
        this.cdUrl = uRL;
        this.sequentialConstruct(string, uRL, null, connectionManager, null);
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    public MQQueueManager(String string, URL uRL, MQConnectionManager mQConnectionManager) throws MQException {
        String string2 = "MQQueueManager constructor (String, URL, MQConnectionManager)";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
            Trace.trace(2, this, "Specified URL is " + uRL);
        }
        this.cdUrl = uRL;
        this.sequentialConstruct(string, uRL, mQConnectionManager, null, null);
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    protected static Hashtable getProperties(Hashtable hashtable, Object object, MQChannelHeader mQChannelHeader, URL uRL) throws IOException, MQException {
        String string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        InputStream inputStream = uRL.openStream();
        long l = 0L;
        long l2 = MQChannelHeader.longRead(inputStream, 4 + (int)mQChannelHeader.getOffset());
        hashtable.put("channel", object);
        int n = (int)MQChannelHeader.longRead(inputStream, 32L);
        String string2 = MQChannelHeader.stringRead(inputStream, 304L, 128L).trim();
        if (string2.length() == 0) {
            MQChannelHeader.stringRead(inputStream, 432L, 0L);
        } else {
            String string3 = MQChannelHeader.stringRead(inputStream, 400L, 32L).trim();
            Object object2 = MQQueueManager.createExit(string2, string3, 2);
            if (object2 != null) {
                hashtable.put("securityExit", object2);
            }
        }
        int n2 = 888;
        long l3 = 0L;
        if (n > 1) {
            Integer n3;
            Object object3;
            String string4 = MQChannelHeader.stringRead(inputStream, 136L, 264L).trim();
            n2 = 1288;
            if (string4.length() > 0) {
                int n4 = string4.indexOf(40);
                if (n4 > 0) {
                    string = string4.substring(0, n4);
                    int n5 = string4.indexOf(41, n4);
                    object3 = string4.substring(n4 + 1, n5);
                    n3 = new Integer((String)object3);
                    hashtable.put("hostname", string);
                    hashtable.put("port", n3);
                } else {
                    hashtable.put("hostname", string4);
                }
            }
            if (n > 3) {
                l = MQChannelHeader.longRead(inputStream, 204L);
                n2 = 1496;
                if (n > 6) {
                    String string5 = MQChannelHeader.stringRead(inputStream, 152L, 32L).trim();
                    string = "";
                    if (string5 != null) {
                        string = SSLHelper.translate(string5, 1);
                    }
                    hashtable.put("SSL Cipher Suite", string);
                    l3 = MQChannelHeader.longRead(inputStream, 4L);
                    String string6 = MQChannelHeader.stringRead(inputStream, 8L, 48L).trim();
                    hashtable.put("Local Address Property", string6);
                    n2 = 1744;
                    if (n > 7) {
                        object3 = new Vector(2);
                        n3 = new Integer((int)MQChannelHeader.longRead(inputStream, 4L));
                        ((Vector)object3).insertElementAt(n3, 0);
                        n3 = new Integer((int)MQChannelHeader.longRead(inputStream, 0L));
                        ((Vector)object3).insertElementAt(n3, 1);
                        hashtable.put("Header Compression Property", object3);
                        Vector<Integer> vector = new Vector<Integer>(16);
                        for (int i = 0; i < 16; ++i) {
                            n3 = new Integer((int)MQChannelHeader.longRead(inputStream, 0L));
                            vector.insertElementAt(n3, i);
                        }
                        hashtable.put("Message Compression Property", vector);
                        n2 = 1820;
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        l = 984L;
                        break;
                    }
                    case 2: {
                        l = 1312L;
                        break;
                    }
                    case 3: {
                        l = 1480L;
                    }
                }
            }
        }
        if (l2 >= l + 12L) {
            long l4 = MQChannelHeader.longRead(inputStream, 8L + l - (long)n2);
            string = null;
            string = n >= 8 ? MQChannelHeader.stringRead(inputStream, 120L, l4) : MQChannelHeader.stringRead(inputStream, 120L, l4);
            if (string != null) {
                Vector[] vectorArray = MQQueueManager.getExitVector(string);
                if (vectorArray[0] != null && vectorArray[0].size() > 0) {
                    MQQueueManager.exitProperties(vectorArray[0], vectorArray[1], 3, hashtable);
                }
                if (vectorArray[2] != null && vectorArray[2].size() > 0) {
                    MQQueueManager.exitProperties(vectorArray[2], vectorArray[3], 1, hashtable);
                }
            }
            MQChannelHeader.stringRead(inputStream, 2L, 0L);
            if (l3 > 0L) {
                String string7 = MQChannelHeader.stringRead(inputStream, 0L, l3);
                hashtable.put("SSL Peer Name", string7);
            }
        }
        inputStream.close();
        return hashtable;
    }

    public static Hashtable getProperties(Object object, MQChannelHeader mQChannelHeader, URL uRL) throws IOException, MQException {
        return MQQueueManager.getProperties(null, object, mQChannelHeader, uRL);
    }

    private static Vector[] getExitVector(String string) {
        Vector[] vectorArray = null;
        if (string.length() >= 4) {
            vectorArray = new Vector[4];
            String string2 = null;
            int n = 2;
            for (int i = 0; i < 4; ++i) {
                int n2;
                vectorArray[i] = new Vector();
                int n3 = string.indexOf(1, n);
                if (n3 <= n) {
                    ++n;
                    continue;
                }
                string2 = string.substring(n, n3);
                while ((n2 = string2.indexOf(2)) > 0) {
                    vectorArray[i].add(string2.substring(0, n2));
                    string2 = string2.substring(n2 + 1);
                }
                n = n3 + 1;
            }
        }
        return vectorArray;
    }

    private static void exitProperties(Vector vector, Vector vector2, int n, Hashtable hashtable) throws MQException {
        Object object = null;
        int n2 = vector.size();
        if (n2 < 1) {
            object = null;
        } else if (n2 == 1) {
            String string = vector2.size() > 0 ? (String)vector2.firstElement() : "";
            object = MQQueueManager.createExit((String)vector.firstElement(), string, n);
        } else {
            Vector<Object> vector3 = new Vector<Object>();
            int n3 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = n3 > i ? (String)vector2.elementAt(i) : "";
                object = MQQueueManager.createExit(string, string2, n);
                vector3.add(object);
            }
            if (n == 3) {
                object = new MQSendExitChain(vector3);
            } else if (n == 1) {
                object = new MQReceiveExitChain(vector3);
            }
        }
        if (object != null) {
            if (n == 3) {
                hashtable.put("sendExit", object);
            } else if (n == 1) {
                hashtable.put("receiveExit", object);
            }
        }
    }

    private static String getLibName(String string) {
        int n = string.indexOf(40);
        if (n < 1) {
            return string.trim();
        }
        return string.substring(0, n).trim();
    }

    private static String getFuncName(String string) {
        int n = string.indexOf(40);
        if (n < 1) {
            return "";
        }
        int n2 = string.indexOf(41, n);
        if (n2 < n + 2) {
            return "";
        }
        return string.substring(n + 1, n2).trim();
    }

    private static Object createExit(String string, String string2, int n) throws MQException {
        String string3 = MQQueueManager.getLibName(string);
        String string4 = MQQueueManager.getFuncName(string);
        MQExternalUserExit mQExternalUserExit = null;
        if (string3.length() > 0) {
            if (string4.length() == 0) {
                URL[] uRLArray = MQExternalUserExit.getWMQExitClasspath();
                if (Trace.isOn) {
                    Trace.trace("MQQueueManager.createExit", "Got  exit classpath=" + uRLArray);
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
                Class<?> clazz = null;
                try {
                    clazz = uRLClassLoader.loadClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MQException(2, 2278, "createExit");
                }
                try {
                    Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = MQQueueManager.class$("java.lang.String")) : class$java$lang$String);
                    mQExternalUserExit = constructor.newInstance(string2);
                }
                catch (Exception exception) {
                    try {
                        mQExternalUserExit = clazz.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new MQException(2, 2278, "createExit");
                    }
                    catch (InstantiationException instantiationException) {
                        throw new MQException(2, 2278, "createExit");
                    }
                }
            } else {
                switch (n) {
                    case 2: {
                        mQExternalUserExit = new MQExternalSecurityExit(string3, string4, string2);
                        break;
                    }
                    case 3: {
                        mQExternalUserExit = new MQExternalSendExit(string3, string4, string2);
                        break;
                    }
                    case 1: {
                        mQExternalUserExit = new MQExternalReceiveExit(string3, string4, string2);
                    }
                }
            }
        }
        return mQExternalUserExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean construct(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager) throws MQException {
        MQJavaLevel.traceBuildInfo();
        Trace.entry(this, "construct");
        MQQueueManager mQQueueManager = null;
        try {
            if (mQConnectionManager == null && connectionManager == null) {
                Vector vector = MQEnvironment.poolTokenSet;
                synchronized (vector) {
                    mQConnectionManager = MQEnvironment.defaultMQCxManager;
                    connectionManager = MQEnvironment.defaultCxManager;
                }
            }
            if (mQConnectionManager == null && connectionManager != null && connectionManager instanceof MQConnectionManager) {
                mQConnectionManager = (MQConnectionManager)connectionManager;
                connectionManager = null;
            }
            mQQueueManager = mQConnectionManager != null ? MQQueueManager.createBaseMQQueueManager(string, hashtable, mQConnectionManager) : MQQueueManager.obtainBaseMQQueueManager(string, hashtable, connectionManager, true);
            this.initialize(mQQueueManager);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "construct");
            }
        }
        return mQQueueManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recycle(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager) throws MQException {
        String string2 = "recycle";
        MQJavaLevel.traceBuildInfo();
        if (Trace.isOn) {
            Trace.entry(this, string2);
        }
        boolean bl = false;
        try {
            Object object;
            if (mQConnectionManager == null && connectionManager == null) {
                object = MQEnvironment.poolTokenSet;
                synchronized (object) {
                    mQConnectionManager = MQEnvironment.defaultMQCxManager;
                    connectionManager = MQEnvironment.defaultCxManager;
                }
            }
            if (mQConnectionManager == null && connectionManager != null && connectionManager instanceof MQConnectionManager) {
                mQConnectionManager = (MQConnectionManager)connectionManager;
                connectionManager = null;
            }
            object = null;
            object = mQConnectionManager != null ? MQQueueManager.recycleBaseMQQueueManager(string, hashtable, mQConnectionManager) : MQQueueManager.recycleBaseMQQueueManager(string, hashtable, connectionManager);
            if (object != null) {
                this.initialize((MQQueueManager)object);
                bl = true;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, string2);
            }
        }
        return bl;
    }

    private static MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager, boolean bl) throws MQException {
        MQQueueManager mQQueueManager;
        Object object;
        String string2;
        String string3 = "obtainBaseMQQueueManager (Java 1.1 version";
        if (Trace.isOn) {
            Trace.entry(clsName, string3);
        }
        if (bl) {
            string2 = "MQSeries Client";
        } else {
            string2 = MQEnvironment.getStringProperty("transport", hashtable);
            if (string2.equals("MQSeries")) {
                object = MQEnvironment.getStringProperty("hostname", hashtable);
                string2 = object == null || ((String)object).equals("") ? "MQSeries Bindings" : "MQSeries Client";
            }
            if (!string2.equals("MQSeries Client") && (object = MQEnvironment.getStringProperty("SSL Cipher Suite", hashtable)) != null && !((String)object).equals("")) {
                throw new MQException(2, 2396, null);
            }
        }
        object = MQSESSION.getMQManagedConnectionFactory(string2, string, hashtable, true);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string2, hashtable, bl);
        try {
            mQQueueManager = (MQQueueManager)mQConnectionManager.allocateConnection((MQManagedConnectionFactory)object, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            if (resourceException.getMessage().equals("allocateConnection")) {
                throw new MQException(2, 2025, "no more connections available");
            }
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, string3);
            }
        }
        return mQQueueManager;
    }

    private static MQQueueManager createBaseMQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        MQQueueManager mQQueueManager;
        String string2 = "createBaseMQQueueManager (Java 1.1 version";
        if (Trace.isOn) {
            Trace.entry(clsName, string2);
        }
        String string3 = "MQSeries Client";
        MQManagedConnectionFactory mQManagedConnectionFactory = MQSESSION.getMQManagedConnectionFactory(string3, string, hashtable, true);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string3, hashtable, true);
        try {
            mQQueueManager = mQConnectionManager instanceof MQSimpleConnectionManager ? (MQQueueManager)((MQSimpleConnectionManager)mQConnectionManager).createConnection(mQManagedConnectionFactory, connectionRequestInfo) : (MQQueueManager)mQConnectionManager.allocateConnection(mQManagedConnectionFactory, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            if (resourceException.getMessage().equals("allocateConnection")) {
                throw new MQException(2, 2025, "no more connections available");
            }
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, string2);
            }
        }
        return mQQueueManager;
    }

    private static MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager, boolean bl) throws MQException {
        MQQueueManager mQQueueManager;
        String string2;
        String string3;
        if (Trace.isOn) {
            Trace.entry(clsName, "obtainBaseMQQueueManager (Java 2 version)");
        }
        if ((string3 = MQEnvironment.getStringProperty("transport", hashtable)).equals("MQSeries")) {
            string2 = MQEnvironment.getStringProperty("hostname", hashtable);
            string3 = string2 == null || string2.equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        string2 = (ManagedConnectionFactory)MQSESSION.getMQManagedConnectionFactory(string3, string, hashtable, false);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string3, hashtable, bl);
        try {
            mQQueueManager = (MQQueueManager)connectionManager.allocateConnection((ManagedConnectionFactory)string2, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            if (resourceException.getMessage().equals("allocateConnection")) {
                throw new MQException(2, 2025, "no more connections available");
            }
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "obtainBaseMQQueueManager (Java 2 version)");
            }
        }
        return mQQueueManager;
    }

    private static MQQueueManager recycleBaseMQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        String string2 = "recycleBaseMQQueueManager (Java 1.1 version)";
        if (Trace.isOn) {
            Trace.entry(clsName, string2);
        }
        String string3 = "MQSeries Client";
        MQManagedConnectionFactory mQManagedConnectionFactory = MQSESSION.getMQManagedConnectionFactory(string3, string, hashtable, true);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string3, hashtable, true);
        MQQueueManager mQQueueManager = null;
        try {
            mQQueueManager = mQConnectionManager instanceof MQSimpleConnectionManager ? (MQQueueManager)((MQSimpleConnectionManager)mQConnectionManager).recycleConnection(mQManagedConnectionFactory, connectionRequestInfo) : (MQQueueManager)mQConnectionManager.allocateConnection(mQManagedConnectionFactory, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        if (Trace.isOn) {
            Trace.exit(clsName, string2);
        }
        return mQQueueManager;
    }

    private static MQQueueManager recycleBaseMQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager) throws MQException {
        MQQueueManager mQQueueManager;
        String string2;
        String string3;
        String string4 = "recycleBaseMQQueueManager (Java 2 version)";
        if (Trace.isOn) {
            Trace.entry(clsName, string4);
        }
        if ((string3 = MQEnvironment.getStringProperty("transport", hashtable)).equals("MQSeries")) {
            string2 = MQEnvironment.getStringProperty("hostname", hashtable);
            string3 = string2 == null || string2.equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        string2 = (ManagedConnectionFactory)MQSESSION.getMQManagedConnectionFactory(string3, string, hashtable, false);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string3, hashtable, true);
        try {
            mQQueueManager = (MQQueueManager)connectionManager.allocateConnection((ManagedConnectionFactory)string2, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            if (resourceException.getMessage().equals("allocateConnection")) {
                throw new MQException(2, 2025, "no more connections available");
            }
            Exception exception = resourceException.getLinkedException();
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            throw new MQException(2, 2195, "static method in MQQueueManager");
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, string4);
            }
        }
        return mQQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQQueueManager(MQManagedConnectionJ11 mQManagedConnectionJ11) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueManager constructor - based on MQManagedConnection");
        }
        try {
            Object object;
            this.name = this.pszName = mQManagedConnectionJ11.getQmgrName();
            this.queues = new Vector(5);
            this.processes = new Vector(5);
            this.distributionLists = new Vector(5);
            this.mqManCon = mQManagedConnectionJ11;
            this.osession = mQManagedConnectionJ11.getMQSESSION();
            this.Hconn = mQManagedConnectionJ11.getHConn();
            this.isConnected = this.connected = this.mqManCon.isConnected();
            this.connectStatus = this.connected;
            this.connectionReference = this;
            this.parentQmgr = this;
            this.resourceOpen = false;
            this.openStatus = false;
            this.forSPI = "SPI_ENABLE".equals(mQManagedConnectionJ11.getStringProperty("SPI"));
            Boolean bl = (Boolean)mQManagedConnectionJ11.getProperty("SPI_INHERIT_TX");
            this.inheritTx = null != bl ? bl : false;
            if (Trace.isOn) {
                object = new String("gotInheritTx property = " + this.inheritTx);
                Trace.trace(this, (String)object);
            }
            this.asyncCmt = null != (bl = (Boolean)mQManagedConnectionJ11.getProperty("SPI_ASYNC_CMIT")) ? bl : false;
            if (Trace.isOn) {
                object = new String("gotAsyncCmt property = " + this.asyncCmt);
                Trace.trace(this, (String)object);
            }
            if (this.connected) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Opening Qmgr for inquire");
                }
                object = new MQOD();
                ((MQOD)object).ObjectType = 5;
                this.osession.MQOPEN(this.Hconn.x, (MQOD)object, 32, this.Hobj, this.completionCode, this.reason);
                if (this.completionCode.x != 0 || this.reason.x != 0) {
                    if (Trace.isOn) {
                        Trace.exit(this, "MQQueueManager constructor (via exception)");
                    }
                    throw new MQException(this.completionCode.x, this.reason.x, this);
                }
                this.resourceOpen = true;
                this.openStatus = true;
                this.osession.resolveV2Support(this.Hconn.x, this.Hobj.x, this.completionCode, this.reason);
                if (this.completionCode.x != 0 || this.reason.x != 0) {
                    if (Trace.isOn) {
                        Trace.exit(this, "MQQueueManager constructor (via exception)");
                    }
                    throw new MQException(this.completionCode.x, this.reason.x, this);
                }
                this.setSupportsQAT2(this.osession.supportsQAT2);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueueManager constructor - based on MQManagedConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(MQQueueManager mQQueueManager) {
        if (Trace.isOn) {
            Trace.entry(this, "initialize");
        }
        MQQueueManager mQQueueManager2 = mQQueueManager;
        synchronized (mQQueueManager2) {
            this.pszName = mQQueueManager.pszName;
            this.name = mQQueueManager.name;
            this.queues = mQQueueManager.queues;
            this.processes = mQQueueManager.processes;
            this.distributionLists = mQQueueManager.distributionLists;
            this.mqManCon = mQQueueManager.mqManCon;
            this.osession = mQQueueManager.osession;
            this.Hconn = mQQueueManager.Hconn;
            this.Hobj = mQQueueManager.Hobj;
            this.connected = mQQueueManager.connected;
            this.isConnected = mQQueueManager.isConnected;
            this.connectStatus = mQQueueManager.connectStatus;
            this.resourceOpen = mQQueueManager.resourceOpen;
            this.openStatus = mQQueueManager.openStatus;
            this.forSPI = mQQueueManager.forSPI;
            this.setSupportsQAT2(mQQueueManager.getSupportsQAT2());
            this.parentQmgr = this;
            this.connectionReference = this;
            this.original = mQQueueManager;
            mQQueueManager.copy = this;
        }
        if (Trace.isOn) {
            Trace.exit(this, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws MQException {
        block21: {
            if (Trace.isOn) {
                Trace.entry(this, "disconnect");
            }
            try {
                if (!MQQueueManagerFactory.isLastReference(this)) {
                    if (factory != null) {
                        factory.remove(this);
                    }
                    break block21;
                }
                this.allowErrorEvents = false;
                MQQueueManager mQQueueManager = this;
                synchronized (mQQueueManager) {
                    block22: {
                        if (this.connected) break block22;
                        if (Trace.isOn) {
                            Trace.exit(this, "disconnect (already disconnected)");
                        }
                        return;
                    }
                    this.cleanup();
                }
                mQQueueManager = this;
                synchronized (mQQueueManager) {
                    if (this.original != null) {
                        this.mqManCon.fireConnectionClosedEvent(this.original);
                    } else {
                        this.mqManCon.fireConnectionClosedEvent(this);
                    }
                    if (this.exceptionForDisconnect != null) {
                        if (Trace.isOn) {
                            Trace.exit(this, "disconnect (via exception)");
                        }
                        throw this.exceptionForDisconnect;
                    }
                    if (factory != null) {
                        factory.remove(this);
                    }
                }
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "disconnect");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "commit");
        }
        try {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "commit (via exception)");
                }
                throw new MQException(2, 2018, (Object)this, 2);
            }
            this.osession.MQCMIT(this.Hconn.x, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "commit (via exception)");
                }
                throw mQException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void backout() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "backout");
        }
        try {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "backout (via exception)");
                }
                throw new MQException(2, 2018, (Object)this, 2);
            }
            this.osession.MQBACK(this.Hconn.x, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "backout (via exception)");
                }
                throw mQException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "backout");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void begin() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "begin");
        }
        try {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "begin (via exception)");
                }
                throw new MQException(2, 2018, (Object)this, 2);
            }
            this.osession.MQBEGIN(this.Hconn.x, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                if (this.reason.x == 2122) {
                    this.reason.x = 2195;
                    this.completionCode.x = 2;
                }
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                if (Trace.isOn) {
                    Trace.exit(this, "begin (via exception)");
                }
                throw mQException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "begin");
            }
        }
    }

    MQSESSION getSession() {
        return this.osession;
    }

    MQManagedConnectionJ11 getMQManagedConnection() {
        return this.mqManCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(String string, String string2, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions, String string3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "put");
        }
        try {
            Object object;
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "put (via exception)");
                }
                throw new MQException(2, 2018, this);
            }
            MQOD mQOD = new MQOD();
            if (string != null && string.length() > 0) {
                mQOD.ObjectName = string;
            }
            if (string2 != null && string2.length() > 0) {
                mQOD.ObjectQMgrName = string2;
            }
            if (string3 != null && string3.length() > 0) {
                mQOD.AlternateUserId = string3;
            }
            if (mQMessage != null) {
                object = mQMessage.toByteArray();
                this.osession.MQPUT1(this.Hconn.x, mQOD, mQMessage, mQPutMessageOptions, ((byte[])object).length, (byte[])object, this.completionCode, this.reason);
            } else {
                this.osession.MQPUT1(this.Hconn.x, mQOD, (MQMD)null, mQPutMessageOptions, 0, null, this.completionCode, this.reason);
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                object = new MQException(this.completionCode.x, this.reason.x, this);
                this.errorOccurred((MQException)object);
                if (Trace.isOn) {
                    Trace.exit(this, "put (via exception)");
                }
                throw object;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "put");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, String string3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "putMsg2");
        }
        try {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "putMsg2 (via exception)");
                }
                throw new MQException(2, 2018, this);
            }
            MQOD mQOD = new MQOD();
            if (string != null && string.length() > 0) {
                mQOD.ObjectName = string;
            }
            if (string2 != null && string2.length() > 0) {
                mQOD.ObjectQMgrName = string2;
            }
            if (string3 != null && string3.length() > 0) {
                mQOD.AlternateUserId = string3;
            }
            byte[] byArray = null;
            if (mQMsg2 != null) {
                byArray = mQMsg2.getInternalBuffer();
                this.osession.MQPUT1(this.Hconn.x, mQOD, mQMsg2, mQPutMessageOptions, mQMsg2.getMessageDataLength(), byArray, this.completionCode, this.reason);
            } else {
                this.osession.MQPUT1(this.Hconn.x, mQOD, mQMsg2, mQPutMessageOptions, 0, null, this.completionCode, this.reason);
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "putMsg2 (via exception)");
                }
                throw mQException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2");
            }
        }
    }

    public synchronized void put(String string, String string2, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.put(string, string2, mQMessage, mQPutMessageOptions, "");
    }

    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.putMsg2(string, string2, mQMsg2, mQPutMessageOptions, "");
    }

    public synchronized void put(String string, String string2, MQMessage mQMessage) throws MQException {
        this.put(string, string2, mQMessage, new MQPutMessageOptions(), null);
    }

    public synchronized void putMsg2(String string, String string2, MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(string, string2, mQMsg2, new MQPutMessageOptions(), null);
    }

    public synchronized void put(String string, MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.put(string, "", mQMessage, mQPutMessageOptions, "");
    }

    public synchronized void putMsg2(String string, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        this.putMsg2(string, "", mQMsg2, mQPutMessageOptions, "");
    }

    public synchronized void put(String string, MQMessage mQMessage) throws MQException {
        this.put(string, "", mQMessage, new MQPutMessageOptions(), null);
    }

    public synchronized void putMsg2(String string, MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(string, "", mQMsg2, new MQPutMessageOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MQQueue accessQueue(String string, int n, String string2, String string3, String string4) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "accessQueue");
        }
        try {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit(this, "accessQueue (via exception)");
                }
                throw new MQException(2, 2018, (Object)this, 2);
            }
            if (Trace.isOn) {
                Trace.trace(this, "inheritTx = " + this.inheritTx);
                Trace.trace(this, "asyncCmt = " + this.asyncCmt);
            }
            MQOD mQOD = new MQOD();
            if (string != null && string.length() > 0) {
                mQOD.ObjectName = string;
            }
            if (string2 != null && string2.length() > 0) {
                mQOD.ObjectQMgrName = string2;
            }
            if (string3 != null && string3.length() > 0) {
                mQOD.DynamicQName = string3;
            }
            if (string4 != null && string4.length() > 0) {
                mQOD.AlternateUserId = string4;
            }
            MQQueue mQQueue = this.forSPI ? new MQSPIQueue() : new MQQueue();
            mQQueue.Hconn = this.Hconn;
            mQQueue.connected = this.connected;
            if (Trace.isOn()) {
                Trace.trace(2, this, "queue = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\ndynamic queue name = " + mQOD.DynamicQName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
            }
            this.osession.MQOPEN(mQQueue.Hconn.x, mQOD, n, mQQueue.Hobj, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mQQueue.resourceOpen = false;
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "accessQueue (via exception)");
                }
                throw mQException;
            }
            mQQueue.resourceOpen = true;
            mQQueue.mgr = this;
            this.queues.addElement(mQQueue);
            mQQueue.name = mQOD.ObjectName;
            mQQueue.openOptions = n;
            mQQueue.openStatus = true;
            mQQueue.parentQmgr = this;
            mQQueue.connectionReference = this;
            if (string4 != null) {
                mQQueue.alternateUserId = string4;
            }
            mQQueue.mqca_description = 2013;
            if (Trace.isOn()) {
                Trace.trace(2, this, "Opened queue name = " + mQQueue.name);
            }
            MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "accessQueue");
            }
        }
    }

    public synchronized MQQueue accessQueue(String string, int n) throws MQException {
        return this.accessQueue(string, n, null, null, null);
    }

    public synchronized MQProcess accessProcess(String string, int n, String string2, String string3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "accessProcess");
        }
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "accessProcess (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        MQOD mQOD = new MQOD();
        mQOD.ObjectType = 3;
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.AlternateUserId = string3;
        }
        MQProcess mQProcess = new MQProcess();
        mQProcess.Hconn = this.Hconn;
        mQProcess.connected = this.connected;
        n |= 0x20;
        if (Trace.isOn()) {
            Trace.trace(2, this, "process = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession.MQOPEN(mQProcess.Hconn.x, mQOD, n, mQProcess.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            mQProcess.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "accessProcess (via exception)");
            }
            throw mQException;
        }
        mQProcess.resourceOpen = true;
        this.processes.addElement(mQProcess);
        mQProcess.name = string;
        mQProcess.openOptions = n;
        mQProcess.openStatus = true;
        mQProcess.parentQmgr = this;
        mQProcess.connectionReference = this;
        if (string3 != null) {
            mQProcess.alternateUserId = string3;
        }
        mQProcess.mqca_description = 2011;
        if (Trace.isOn) {
            Trace.exit(this, "accessProcess");
        }
        return mQProcess;
    }

    public synchronized MQProcess accessProcess(String string, int n) throws MQException {
        return this.accessProcess(string, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MQDistributionList accessDistributionList(MQDistributionListItem[] mQDistributionListItemArray, int n, String string) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "accessDistributionList");
        }
        try {
            MQDistributionList mQDistributionList;
            MQDistributionList mQDistributionList2 = mQDistributionList = new MQDistributionList(this, mQDistributionListItemArray, n, string);
            return mQDistributionList2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "accessDistributionList");
            }
        }
    }

    public MQDistributionList accessDistributionList(MQDistributionListItem[] mQDistributionListItemArray, int n) throws MQException {
        return this.accessDistributionList(mQDistributionListItemArray, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        block26: {
            block25: {
                MQManagedObject mQManagedObject;
                int n;
                Vector vector;
                block24: {
                    block23: {
                        if (Trace.isOn) {
                            Trace.entry(this, "cleanup");
                        }
                        if (this.copy != null) {
                            MQQueueManager mQQueueManager = this.copy;
                            synchronized (mQQueueManager) {
                                this.copy.cleanup();
                                this.isConnected = false;
                                this.connectStatus = false;
                                this.connected = false;
                                this.openStatus = false;
                                this.resourceOpen = false;
                            }
                        }
                        try {
                            vector = (Vector)this.queues.clone();
                            for (n = 0; n < vector.size(); ++n) {
                                mQManagedObject = (MQQueue)vector.elementAt(n);
                                if (((MQQueue)mQManagedObject).resourceOpen) {
                                    ((MQQueue)mQManagedObject).close();
                                }
                                ((MQQueue)mQManagedObject).connected = false;
                            }
                        }
                        catch (Exception exception) {
                            if (!Trace.isOn) break block23;
                            Trace.trace(2, this, "Queue cleanup() exception " + exception);
                        }
                    }
                    this.queues.removeAllElements();
                    if (Trace.isOn) {
                        Trace.trace(2, this, "All queues closed.");
                    }
                    try {
                        vector = (Vector)this.processes.clone();
                        for (n = 0; n < vector.size(); ++n) {
                            mQManagedObject = (MQProcess)vector.elementAt(n);
                            if (((MQProcess)mQManagedObject).resourceOpen) {
                                ((MQProcess)mQManagedObject).close();
                            }
                            ((MQProcess)mQManagedObject).connected = false;
                        }
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block24;
                        Trace.trace(2, this, "Process cleanup() exception " + exception);
                    }
                }
                this.processes.removeAllElements();
                if (Trace.isOn) {
                    Trace.trace(2, this, "All processes closed.");
                }
                try {
                    vector = (Vector)this.distributionLists.clone();
                    for (n = 0; n < vector.size(); ++n) {
                        mQManagedObject = (MQDistributionList)vector.elementAt(n);
                        if (((MQDistributionList)mQManagedObject).resourceOpen) {
                            ((MQDistributionList)mQManagedObject).close();
                        }
                        ((MQDistributionList)mQManagedObject).connected = false;
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isOn) break block25;
                    Trace.trace(2, this, "Distribution List cleanup() exception " + exception);
                }
            }
            this.distributionLists.removeAllElements();
            if (Trace.isOn) {
                Trace.trace(2, this, "All distribution lists closed.");
            }
            try {
                this.close();
            }
            catch (MQException mQException) {
                if (!Trace.isOn) break block26;
                Trace.trace(1, this, "Exception during close, proceeding anyway.");
            }
        }
        this.isConnected = false;
        this.connectStatus = false;
        this.connected = false;
        this.connectionReference = null;
        if (Trace.isOn) {
            Trace.exit(this, "cleanup");
        }
    }

    protected final void registerQueue(MQQueue mQQueue) {
        this.queues.addElement(mQQueue);
    }

    protected final void registerProcess(MQProcess mQProcess) {
        this.processes.addElement(mQProcess);
    }

    protected final void registerDistributionList(MQDistributionList mQDistributionList) {
        this.distributionLists.addElement(mQDistributionList);
    }

    protected final void unregisterQueue(MQQueue mQQueue) {
        this.queues.removeElement(mQQueue);
    }

    protected final void unregisterProcess(MQProcess mQProcess) {
        this.processes.removeElement(mQProcess);
    }

    protected final void unregisterDistributionList(MQDistributionList mQDistributionList) {
        this.distributionLists.removeElement(mQDistributionList);
    }

    protected final boolean supportsV2Structures() {
        return this.osession.supportsV2Structures(this.Hconn.x);
    }

    void errorOccurred(MQException mQException) {
        if (Trace.isOn) {
            Trace.entry(this, "errorOccurred");
        }
        if (this.allowErrorEvents && mQException.completionCode == 2) {
            int n = ReasonCodeInfo.getReasonCodeCategory(mQException.reasonCode);
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    this.mqManCon.setNotReusable();
                    if (this.original != null) {
                        this.mqManCon.fireConnectionErrorEvent(this.original, mQException);
                        break;
                    }
                    this.mqManCon.fireConnectionErrorEvent(this, mQException);
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Bad Reason Code Category encountered");
                    }
                    this.mqManCon.setNotReusable();
                    if (this.original != null) {
                        this.mqManCon.fireConnectionErrorEvent(this.original, mQException);
                        break;
                    }
                    this.mqManCon.fireConnectionErrorEvent(this, mQException);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "errorOccurred");
        }
    }

    void setExceptionForDisconnect(MQException mQException) {
        this.exceptionForDisconnect = mQException;
        if (this.copy != null) {
            this.copy.exceptionForDisconnect = mQException;
        }
    }

    synchronized void honourRRS() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "honourRRS");
        }
        this.mqManCon.setNotReusable();
        this.osession.honourRRS(this.Hconn.x, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            if (Trace.isOn) {
                Trace.exit(this, "honourRRS (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "honourRRS");
        }
    }

    protected void finalize() {
        this.allowErrorEvents = false;
        if (this.connected) {
            if (this.association != 0) {
                try {
                    this.disconnect();
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.exceptionTrace(1, this, mQException);
                    }
                }
            } else {
                this.cleanup();
            }
        }
    }

    public int _getConnectionCCSID() {
        return this.osession.getConnectionCCSID();
    }

    public URL getCCDTURL() {
        return this.cdUrl;
    }

    boolean getInheritTX() {
        if (Trace.isOn) {
            Trace.trace(this, "got inheritTx = " + this.inheritTx);
        }
        return this.inheritTx;
    }

    boolean getAsyncCmt() {
        if (Trace.isOn) {
            Trace.trace(this, "getting asyncCmt = " + this.asyncCmt);
        }
        return this.asyncCmt;
    }

    public boolean getSupportsQAT2() {
        return this.supportsQAT2;
    }

    public void setSupportsQAT2(boolean bl) {
        this.supportsQAT2 = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (factory == null) {
            factory = MQQueueManagerFactory.getInstance();
        }
    }

    public static class MQExitWrapper
    implements MQReceiveExit,
    MQSendExit,
    MQSecurityExit {
        private Object exitObject;
        private int exitCount = 0;
        private Object exitLock = new Object();
        private boolean sendExit = false;
        private boolean receiveExit = false;
        private boolean securityExit = false;

        public MQExitWrapper(MQSendExit mQSendExit) {
            if (Trace.isOn) {
                Trace.trace("MQExitWrapper.callExit", "Creating new Wrapper SendExit");
            }
            this.exitObject = mQSendExit;
            this.sendExit = true;
        }

        public MQExitWrapper(MQReceiveExit mQReceiveExit) {
            if (Trace.isOn) {
                Trace.trace("MQExitWrapper.callExit", "Creating new Wrapper ReceiveExit");
            }
            this.exitObject = mQReceiveExit;
            this.receiveExit = true;
        }

        public MQExitWrapper(MQSecurityExit mQSecurityExit) {
            if (Trace.isOn) {
                Trace.trace("MQExitWrapper.callExit", "Creating new Wrapper SecurityExit");
            }
            this.exitObject = mQSecurityExit;
            this.securityExit = true;
        }

        private String exitType() {
            if (this.sendExit) {
                return "SendExit";
            }
            if (this.receiveExit) {
                return "RecieveExit";
            }
            if (this.securityExit) {
                return "SecurityExit";
            }
            return "UnkonwnExitType";
        }

        public byte[] receiveExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
            return this.callExit(mQChannelExit, mQChannelDefinition, byArray);
        }

        public byte[] sendExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
            return this.callExit(mQChannelExit, mQChannelDefinition, byArray);
        }

        public byte[] securityExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
            return this.callExit(mQChannelExit, mQChannelDefinition, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] callExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
            byte[] byArray2 = byArray;
            int n = mQChannelExit.exitReason;
            if (Trace.isOn) {
                Trace.entry("MQExitWrapper.callExit", "entry - handling a " + this.exitType());
            }
            if (11 == n) {
                Object object = this.exitLock;
                synchronized (object) {
                    if (Trace.isOn) {
                        Trace.trace("MQExitWrapper.callExit", "MQXR_INIT - attempt to route 1st call to exit. exitCount=" + this.exitCount);
                    }
                    if (this.exitCount <= 0) {
                        if (this.sendExit) {
                            byArray2 = ((MQSendExit)this.exitObject).sendExit(mQChannelExit, mQChannelDefinition, byArray);
                        } else if (this.receiveExit) {
                            byArray2 = ((MQReceiveExit)this.exitObject).receiveExit(mQChannelExit, mQChannelDefinition, byArray);
                        } else if (this.securityExit) {
                            byArray2 = ((MQSecurityExit)this.exitObject).securityExit(mQChannelExit, mQChannelDefinition, byArray);
                        }
                    }
                    ++this.exitCount;
                }
            } else if (12 == n) {
                Object object = this.exitLock;
                synchronized (object) {
                    if (Trace.isOn) {
                        Trace.trace("MQExitWrapper.callExit", "MQXR_TERM - attempt to route last call to exit. prior to decrement exitCount=" + this.exitCount);
                    }
                    --this.exitCount;
                    if (this.exitCount <= 0) {
                        if (this.sendExit) {
                            byArray2 = ((MQSendExit)this.exitObject).sendExit(mQChannelExit, mQChannelDefinition, byArray);
                        } else if (this.receiveExit) {
                            byArray2 = ((MQReceiveExit)this.exitObject).receiveExit(mQChannelExit, mQChannelDefinition, byArray);
                        } else if (this.securityExit) {
                            byArray2 = ((MQSecurityExit)this.exitObject).securityExit(mQChannelExit, mQChannelDefinition, byArray);
                        }
                    }
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace("MQExitWrapper.callExit", "Got exitreason=" + n + " sending direct to exit.");
                }
                if (this.sendExit) {
                    byArray2 = ((MQSendExit)this.exitObject).sendExit(mQChannelExit, mQChannelDefinition, byArray);
                } else if (this.receiveExit) {
                    byArray2 = ((MQReceiveExit)this.exitObject).receiveExit(mQChannelExit, mQChannelDefinition, byArray);
                } else if (this.securityExit) {
                    byArray2 = ((MQSecurityExit)this.exitObject).securityExit(mQChannelExit, mQChannelDefinition, byArray);
                }
            }
            if (Trace.isOn) {
                Trace.exit("MQExitWrapper", "exit");
            }
            return byArray2;
        }
    }
}

