/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class MQObjectInputStream
extends ObjectInputStream {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQObjectInputStream.java, jms, j600, j600-201-061220 1.7.1.4 06/08/31 11:10:19";
    private static HashMap primitiveClasses = new HashMap();
    ClassLoader cl = null;

    protected MQObjectInputStream(ClassLoader classLoader) throws IOException, SecurityException {
        this.cl = classLoader;
    }

    public MQObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.cl = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "resolveClass");
            Trace.trace(this, "v = " + objectStreamClass.toString());
        }
        try {
            if (Trace.isOn) {
                Trace.trace(this, "Attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.cl);
            }
            Class<?> clazz = Class.forName(objectStreamClass.getName(), true, this.cl);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = (Class)primitiveClasses.get(objectStreamClass.getName());
            if (clazz != null) {
                Trace.trace(this, "Resolved as primitive!");
                Class clazz2 = clazz;
                return clazz2;
            }
            if (Trace.isOn) {
                Trace.trace(this, "forName() failed to resolve the class " + objectStreamClass.getName() + " with the classloader " + this.cl);
                Trace.trace(this, "exception : " + classNotFoundException.toString());
                Trace.trace(this, "Now attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.getClass().getClassLoader());
            }
            Class<?> clazz3 = Class.forName(objectStreamClass.getName());
            return clazz3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "resolveClass");
            }
        }
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("void", Void.TYPE);
    }
}

