/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUParameterMetadataCache;
import oracle.jdbc.driver.OracleParameterMetaDataParser;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.utils.SQLTokenizer;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

class OracleParameterMetaData
implements oracle.jdbc.internal.OracleParameterMetaData,
Monitor {
    private static final String CLASS_NAME = OracleParameterMetaData.class.getName();
    static final Set<Integer> BAD_SQL = Collections.synchronizedSet(new HashSet());
    static final int BAD_SQL_LIMIT = 10000;
    private static final LRUParameterMetadataCache cache;
    private boolean isResolved = false;
    private Connection connection;
    private OracleSql sqlObject;
    int parameterCount = 0;
    OracleParameterMetaDataParser.ParameterMetadataSql pmdSql = null;
    OracleParameterMetaDataParser.ParameterMetadataSql[] pmdSqls = null;
    CompressedStatement compressedStatement = null;
    OracleParameterMetaData parent = null;
    int[] isNullable;
    boolean[] isSigned;
    int[] precision;
    int[] scale;
    int[] parameterType;
    String[] parameterTypeName;
    String[] parameterClassName;
    int[] parameterMode;
    private VectorMetaData[] parameterVectorMetaData;
    boolean throwUnsupportedFeature = false;
    boolean isPlsqlOrCall = false;
    boolean isReturningParameters = false;
    SQLException syntaxError = null;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    int parameterNoNulls = 0;
    int parameterNullable = 1;
    int parameterNullableUnknown = 2;
    int parameterModeUnknown = 0;
    int parameterModeIn = 1;
    int parameterModeInOut = 2;
    int parameterModeOut = 4;
    Object acProxy;

    static final ParameterMetaData getParameterMetaData(OracleSql sqlObject, Connection connection, OraclePreparedStatement stmt) throws SQLException {
        ParameterMetaData result = null;
        String sql = sqlObject.getOriginalSql();
        String sqlid = sqlObject.getSqlId(true, true);
        int paramCount = sqlObject.getParameterCount();
        if (paramCount != 0 && !sqlObject.sqlKind.isPlsqlOrCall() && sqlObject.getReturnParameterCount() < 1 && !BAD_SQL.contains(sql.hashCode())) {
            CompressedStatement compressedStatement = null;
            PhysicalConnection pConnection = (PhysicalConnection)connection;
            if (paramCount > 0 && pConnection.parameterMetadataPreprocess) {
                compressedStatement = OracleParameterMetaData.compressInClauses(sqlObject);
                sql = compressedStatement.compressedStatement;
                if (sqlObject.getOriginalSql().length() != sql.length()) {
                    sqlObject = new OracleSql(pConnection.conversion, pConnection.allowMixingJdbcAndNamedBinds);
                    sqlObject.initialize(sql);
                    sqlObject.computeBasicInfo();
                    sqlid = sqlObject.getSqlId(true, true);
                } else {
                    compressedStatement = null;
                }
            }
            if (cache != null && (result = cache.searchCache(sqlid, pConnection.sessionProperties.getProperty("AUTH_DB_ID"), connection.getSchema(), connection.getMetaData().getUserName())) != null) {
                if (compressedStatement != null) {
                    return new OracleParameterMetaData(connection, (OracleParameterMetaData)result, compressedStatement);
                }
                return result;
            }
            result = new OracleParameterMetaData(connection, sqlObject);
            if (compressedStatement != null) {
                result = new OracleParameterMetaData(connection, (OracleParameterMetaData)result, compressedStatement);
            }
        } else {
            result = new OracleParameterMetaData(sqlObject.sqlKind.isPlsqlOrCall(), sqlObject.getReturnParameterCount() > 0, paramCount);
        }
        return result;
    }

    private OracleParameterMetaData(Connection conn, OracleSql sqlObject) throws SQLException {
        if (sqlObject == null) {
            throw new IllegalArgumentException("sqlObject can not be null");
        }
        this.sqlObject = sqlObject;
        this.parameterCount = sqlObject.parameterCount;
        this.connection = conn;
    }

    private void copyParent(OracleParameterMetaData parent) {
        this.syntaxError = parent.syntaxError;
        this.pmdSql = parent.pmdSql;
        this.pmdSqls = parent.pmdSqls;
        this.isResolved = parent.isResolved;
        this.isNullable = parent.isNullable;
        this.isSigned = parent.isSigned;
        this.precision = parent.precision;
        this.scale = parent.scale;
        this.parameterType = parent.parameterType;
        this.parameterTypeName = parent.parameterTypeName;
        this.parameterClassName = parent.parameterClassName;
        this.parameterMode = parent.parameterMode;
        this.parameterVectorMetaData = parent.parameterVectorMetaData;
    }

    private void parseAndQuery(Connection conn) throws SQLException {
        block18: {
            if (!this.isResolved) {
                try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                    if (this.isResolved) break block18;
                    PhysicalConnection pConn = (PhysicalConnection)conn;
                    if (this.parent != null) {
                        this.parent.parseAndQuery(conn);
                        this.copyParent(this.parent);
                        this.parent = null;
                    } else {
                        OracleParameterMetaDataParser parser = new OracleParameterMetaDataParser();
                        parser.initialize(this.sqlObject.originalSql, this.sqlObject.sqlKind, this.parameterCount);
                        try {
                            this.pmdSql = parser.getParameterMetaDataSql();
                            this.query(conn);
                        }
                        catch (SQLSyntaxErrorException e) {
                            if (e.getErrorCode() == 918) {
                                try {
                                    this.pmdSql = null;
                                    this.pmdSqls = parser.getParameterMetaDataSqls();
                                    this.query(conn);
                                }
                                catch (Exception ex) {
                                    this.syntaxError = e;
                                }
                            } else {
                                this.syntaxError = e;
                            }
                        }
                        catch (SQLException e) {
                            this.syntaxError = e;
                        }
                        if (cache != null) {
                            if (!pConn.parameterMetadataCacheIncludeParsing) {
                                this.pmdSql = null;
                                this.pmdSqls = null;
                            }
                            String sqlid = this.sqlObject.getSqlId(true, true);
                            this.connection = null;
                            this.sqlObject = null;
                            cache.add(this, sqlid, pConn.sessionProperties.getProperty("AUTH_DB_ID"), conn.getSchema(), conn.getMetaData().getUserName());
                        }
                    }
                    this.isResolved = true;
                }
            }
        }
    }

    private OracleParameterMetaData(boolean _isPlsqlOrCall, boolean _isReturningParameters, int _parameterCount) throws SQLException {
        this.isPlsqlOrCall = _isPlsqlOrCall;
        this.isReturningParameters = _isReturningParameters;
        this.parameterCount = _parameterCount;
        this.throwUnsupportedFeature = true;
        this.isResolved = true;
    }

    private OracleParameterMetaData(Connection connection, OracleParameterMetaData parentParamMetadata, CompressedStatement compressedStatement) throws SQLException {
        if (parentParamMetadata.isResolved) {
            this.copyParent(parentParamMetadata);
        } else {
            this.parent = parentParamMetadata;
            this.connection = connection;
        }
        this.compressedStatement = compressedStatement;
        this.parameterCount = compressedStatement.nbBindsInCompressedStatement;
    }

    private static CompressedStatement compressInClauses(OracleSql sqlObject) {
        if (sqlObject == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder compressedStatementBuilder = new StringBuilder();
        boolean inINClause = false;
        boolean inUnion = false;
        int parentheseTracker = 0;
        int inParentheseTracker = 0;
        int nbDuplicateBinds = 0;
        int unionParenthesesState = 0;
        int lastToken = 0;
        int lastWhitespace = 0;
        int parameterCount = 0;
        ArrayList compressedBindsList = new ArrayList();
        StringBuilder valueBuilder = null;
        int nbBindsInValue = 0;
        HashMap duplicateBindsMap = new HashMap();
        boolean commaPending = false;
        for (int i = 0; i < sqlObject.sqlTokenizer.getNbTokens(); ++i) {
            SQLTokenizer.TokenType currentToken = sqlObject.sqlTokenizer.getTokenType(i);
            if (!inINClause && currentToken == SQLTokenizer.TokenType.OPEN_PARENTHESE && lastToken > 0 && sqlObject.sqlTokenizer.getTokenLength(lastToken) == 2 && "IN".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(lastToken))) {
                inINClause = true;
                valueBuilder = new StringBuilder();
                lastWhitespace = i;
                inParentheseTracker = 0;
                ++parentheseTracker;
                compressedStatementBuilder.append("(");
                continue;
            }
            if (inINClause) {
                switch (currentToken) {
                    case OPEN_PARENTHESE: {
                        valueBuilder.append("(");
                        ++inParentheseTracker;
                        ++parentheseTracker;
                        lastWhitespace = i;
                        break;
                    }
                    case CLOSE_PARENTHESE: {
                        --inParentheseTracker;
                        --parentheseTracker;
                    }
                    case COMMA: {
                        if (currentToken == SQLTokenizer.TokenType.COMMA && inParentheseTracker == 0 || currentToken == SQLTokenizer.TokenType.CLOSE_PARENTHESE && inParentheseTracker == -1) {
                            if (currentToken == SQLTokenizer.TokenType.COMMA) {
                                lastWhitespace = i;
                            }
                            String value = valueBuilder.toString();
                            if (nbBindsInValue > 0) {
                                List<Integer> valueBindIndices = null;
                                if (duplicateBindsMap.get(value) != null) {
                                    parameterCount += nbBindsInValue;
                                    nbDuplicateBinds += nbBindsInValue;
                                    valueBindIndices = (List)duplicateBindsMap.get(value);
                                } else {
                                    if (commaPending) {
                                        compressedStatementBuilder.append(",");
                                    }
                                    compressedStatementBuilder.append(value);
                                    valueBindIndices = new ArrayList(nbBindsInValue);
                                    for (int j = parameterCount - nbDuplicateBinds; j < parameterCount - nbDuplicateBinds + nbBindsInValue; ++j) {
                                        valueBindIndices.add(j);
                                    }
                                    parameterCount += nbBindsInValue;
                                    duplicateBindsMap.put(value, valueBindIndices);
                                }
                                compressedBindsList.addAll(valueBindIndices);
                            } else {
                                if (commaPending) {
                                    compressedStatementBuilder.append(",");
                                }
                                compressedStatementBuilder.append(value);
                            }
                            nbBindsInValue = 0;
                            valueBuilder = new StringBuilder();
                            if (currentToken == SQLTokenizer.TokenType.CLOSE_PARENTHESE) {
                                compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                                duplicateBindsMap.clear();
                                inINClause = false;
                                inParentheseTracker = 0;
                                commaPending = false;
                                break;
                            }
                            commaPending = true;
                            break;
                        }
                        if (currentToken == SQLTokenizer.TokenType.CLOSE_PARENTHESE) {
                            valueBuilder.append(")");
                            break;
                        }
                        valueBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                        break;
                    }
                    case BIND: {
                        ++nbBindsInValue;
                        valueBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                        break;
                    }
                    case TOKEN: {
                        if (sqlObject.sqlTokenizer.getTokenLength(i) == 6 && "SELECT".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(i))) {
                            inINClause = false;
                            compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                            valueBuilder = null;
                        } else {
                            valueBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                        }
                        lastToken = i;
                        break;
                    }
                    case WHITESPACES: {
                        if (lastWhitespace != i - 1) {
                            valueBuilder.append(" ");
                        }
                        lastWhitespace = i;
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        valueBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                        break;
                    }
                }
                continue;
            }
            Object toAppend = null;
            if (currentToken == SQLTokenizer.TokenType.BIND) {
                compressedBindsList.add(parameterCount - nbDuplicateBinds);
                ++parameterCount;
                toAppend = sqlObject.sqlTokenizer.getToken(i);
            } else if (currentToken == SQLTokenizer.TokenType.TOKEN) {
                lastToken = i;
                if (sqlObject.sqlTokenizer.getTokenLength(lastToken) == 5 && "UNION".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(lastToken))) {
                    boolean isUnionAll;
                    int nextToken = sqlObject.sqlTokenizer.nextSignificantToken(i + 1);
                    boolean bl = isUnionAll = nextToken != i && SQLTokenizer.TokenType.TOKEN == sqlObject.sqlTokenizer.getTokenType(nextToken) && "ALL".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(nextToken));
                    toAppend = inUnion && unionParenthesesState == parentheseTracker ? ") " + sqlObject.sqlTokenizer.getToken(i) + " " + (isUnionAll ? sqlObject.sqlTokenizer.getToken(nextToken) : "") + " (" : sqlObject.sqlTokenizer.getToken(i) + " " + (isUnionAll ? sqlObject.sqlTokenizer.getToken(nextToken) : "") + " (";
                    if (isUnionAll) {
                        i = nextToken;
                    }
                    inUnion = true;
                    unionParenthesesState = parentheseTracker;
                } else {
                    toAppend = sqlObject.sqlTokenizer.getToken(i);
                }
            } else if (currentToken == SQLTokenizer.TokenType.OPEN_PARENTHESE) {
                ++parentheseTracker;
                toAppend = "(";
            } else if (currentToken == SQLTokenizer.TokenType.CLOSE_PARENTHESE) {
                if (inUnion && --parentheseTracker == unionParenthesesState - 1) {
                    toAppend = "))";
                    inUnion = false;
                } else {
                    toAppend = ")";
                }
            } else {
                toAppend = sqlObject.sqlTokenizer.getToken(i);
            }
            compressedStatementBuilder.append((String)toAppend);
        }
        if (inUnion) {
            compressedStatementBuilder.append(")");
        }
        int[] compressedBinds = new int[compressedBindsList.size()];
        for (int j = 0; j < compressedBinds.length; ++j) {
            compressedBinds[j] = (Integer)compressedBindsList.get(j);
        }
        return new CompressedStatement(compressedStatementBuilder.toString(), sqlObject.parameterCount - nbDuplicateBinds, compressedBinds);
    }

    private void storeParametersMetadata(OracleParameterMetaDataParser.ParameterMetadataSql myPmdSql) {
        OracleParameterMetaDataParser.ParameterMetadataSql.ParameterMetadata[] binds = myPmdSql.getParametersMetadata();
        if (this.syntaxError != null) {
            return;
        }
        if (this.isNullable == null) {
            this.isNullable = new int[this.parameterCount];
            this.isSigned = new boolean[this.parameterCount];
            this.precision = new int[this.parameterCount];
            this.scale = new int[this.parameterCount];
            this.parameterType = new int[this.parameterCount];
            this.parameterTypeName = new String[this.parameterCount];
            this.parameterClassName = new String[this.parameterCount];
            this.parameterMode = new int[this.parameterCount];
            this.parameterVectorMetaData = new VectorMetaData[this.parameterCount];
        }
        for (int j = 0; j < binds.length; ++j) {
            int arrayPos = binds[j].bindNumber - 1;
            this.isNullable[arrayPos] = binds[j].isNullable;
            this.isSigned[arrayPos] = binds[j].isSigned;
            this.precision[arrayPos] = binds[j].precision;
            this.scale[arrayPos] = binds[j].scale;
            this.parameterType[arrayPos] = binds[j].parameterType;
            this.parameterTypeName[arrayPos] = binds[j].parameterTypeName;
            this.parameterClassName[arrayPos] = binds[j].parameterClassName;
            this.parameterMode[arrayPos] = binds[j].parameterMode;
            this.parameterVectorMetaData[arrayPos] = binds[j].parameterVectorMetaData;
        }
    }

    @Override
    public void query(Connection conn) throws SQLException {
        block20: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                block21: {
                    if (this.syntaxError != null && this.pmdSql != null) {
                        throw this.syntaxError;
                    }
                    try {
                        if (this.pmdSqls != null) {
                            SQLException originalSyntaxError = this.syntaxError;
                            this.syntaxError = null;
                            try {
                                int allParametersFound = 0;
                                for (OracleParameterMetaDataParser.ParameterMetadataSql myPmdSql : this.pmdSqls) {
                                    int nbParametersFound = myPmdSql.getNbParameters();
                                    if (nbParametersFound <= 0) continue;
                                    myPmdSql.query(conn);
                                    if ((allParametersFound += nbParametersFound) > this.parameterCount) {
                                        throw new SQLException("ParameterMetadata MultiSQLs returned an invalid number of parameters");
                                    }
                                    this.storeParametersMetadata(myPmdSql);
                                }
                                break block20;
                            }
                            catch (SQLSyntaxErrorException e) {
                                this.syntaxError = originalSyntaxError;
                                break block20;
                            }
                        }
                        if (this.pmdSql != null) {
                            if (this.pmdSql.getNbParameters() != this.parameterCount) {
                                throw DatabaseError.createSqlException(1734, null);
                            }
                            this.pmdSql.query(conn);
                            this.storeParametersMetadata(this.pmdSql);
                            break block20;
                        }
                        if (!this.isPlsqlOrCall && !this.isReturningParameters) break block21;
                        return;
                    }
                    catch (SQLSyntaxErrorException e) {
                        this.syntaxError = e;
                        throw e;
                    }
                }
                if (this.isNullable != null) {
                    if (this.sqlObject != null) {
                        this.parseAndQuery(conn);
                    }
                    break block20;
                }
                throw DatabaseError.createSqlException(1734, null);
            }
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        if (this.compressedStatement != null) {
            return this.compressedStatement.compressedBinds.length;
        }
        return this.parameterCount;
    }

    void checkValidIndex(int index) throws SQLException {
        this.parseAndQuery(this.connection);
        this.connection = null;
        if (this.throwUnsupportedFeature) {
            if (this.isPlsqlOrCall) {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("API not supported with PL/SQL").fillInStackTrace();
            }
            if (this.isReturningParameters) {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("API not supported with DML returning").fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("checkValidIndex").fillInStackTrace();
        }
        if (this.syntaxError != null) {
            throw this.syntaxError;
        }
        if (!(index >= 1 && index <= this.parameterCount || this.compressedStatement != null && this.compressedStatement.compressedBinds != null && index <= this.compressedStatement.compressedBinds.length && index > 0)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.isNullable[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.isNullable[param - 1];
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.isSigned[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.isSigned[param - 1];
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.precision[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.precision[param - 1];
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.scale[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.scale[param - 1];
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterType[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterType[param - 1];
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterTypeName[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterTypeName[param - 1];
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterClassName[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterClassName[param - 1];
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterMode[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterMode[param - 1];
    }

    @Override
    public VectorMetaData getVectorMetaData(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterVectorMetaData[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterVectorMetaData[param - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        Integer parameterMetadataCacheSize = null;
        try {
            parameterMetadataCacheSize = Integer.valueOf(System.getProperty("oracle.jdbc.parameterMetadataCacheSize"));
        }
        catch (NumberFormatException e) {
            CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.CONFIG, CLASS_NAME, "static initializer", "Parameter Metadata cache size is invalid: %s - disabling cache", (String)null, e, (Object)System.getProperty("oracle.jdbc.parameterMetadataCacheSize"));
            parameterMetadataCacheSize = 0;
        }
        if (parameterMetadataCacheSize > 0) {
            LRUParameterMetadataCache myCache = null;
            try {
                myCache = new LRUParameterMetadataCache(parameterMetadataCacheSize);
            }
            catch (SQLException e) {
                CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.CONFIG, CLASS_NAME, "static initializer", "Could not initialize Parameter Metadata cache: disabling cache", null, e);
            }
            cache = myCache;
        } else {
            CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.CONFIG, CLASS_NAME, "static initializer", "Parameter Metadata cache size can not be negative: disabling cache", null, null);
            cache = null;
        }
    }

    static class CompressedStatement {
        private String compressedStatement;
        private int nbBindsInCompressedStatement;
        private int[] compressedBinds;

        private CompressedStatement(String compressedStatement, int nbBindsInCompressedStatement, int[] compressedBinds) {
            this.compressedStatement = compressedStatement;
            this.nbBindsInCompressedStatement = nbBindsInCompressedStatement;
            this.compressedBinds = compressedBinds;
        }
    }
}

