/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.InvalidCommandLineArgument;
import com.ibm.mq.jms.services.psk.NLSServices;
import com.ibm.mq.jms.services.psk.PSK;
import com.ibm.mq.jms.services.psk.Trace;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineParser {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/CommandLineParser.java, jms, j600, j600-201-061220 1.5.1.1 05/05/25 15:10:44";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String flags = "";
    private String options = "";
    private String[] permissibleFlags;
    private String[] permissibleOptions;
    private Vector detectedFlags = new Vector();
    private Hashtable detectedOptions = new Hashtable();
    private char switchCharacter = (char)45;
    private String usage = "";

    private boolean flagMatch(String string) {
        int n;
        boolean bl = false;
        String string2 = "" + this.getSwitchCharacter();
        while (string.startsWith(string2)) {
            string = string.substring(1);
        }
        for (n = 0; n < this.permissibleFlags.length; ++n) {
            if (!string.equals(this.permissibleFlags[n])) continue;
            bl = true;
            this.detectedFlags.addElement(string);
            Trace.trace(2, this, "Flag matched: " + string);
            break;
        }
        if (!bl) {
            bl = true;
            for (int i = 0; i < string.length(); ++i) {
                String string3 = "" + string.charAt(i);
                n = 0;
                for (int j = 0; j < this.permissibleFlags.length; ++j) {
                    if (!this.permissibleFlags[j].equals(string3)) continue;
                    this.detectedFlags.addElement(string3);
                    n = 1;
                    Trace.trace(2, this, "Flag matched: " + string3);
                    break;
                }
                if (n != 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getOption(String string) {
        return (String)this.detectedOptions.get(string);
    }

    public String getOptions() {
        return this.options;
    }

    public char getSwitchCharacter() {
        return this.switchCharacter;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isFlagSet(String string) {
        return this.detectedFlags.contains(string);
    }

    public boolean isOptionSet(String string) {
        return this.detectedOptions.containsKey(string);
    }

    private String optionMatch(String string) {
        String string2 = null;
        if (string.startsWith("" + this.getSwitchCharacter())) {
            string = string.substring(1);
        }
        for (int i = 0; i < this.permissibleOptions.length; ++i) {
            if (!string.equals(this.permissibleOptions[i])) continue;
            string2 = string;
            break;
        }
        return string2;
    }

    public void parseCommandLine(String[] stringArray) throws InvalidCommandLineArgument {
        Trace.entry(this, "parseCommandLine");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = this.optionMatch(string);
            if (string2 != null) {
                String string3;
                if (++i < n) {
                    string3 = stringArray[i];
                    if (string3.startsWith("" + this.getSwitchCharacter())) {
                        string3 = "";
                        --i;
                    }
                } else {
                    string3 = "";
                }
                this.detectedOptions.put(string2, string3);
                Trace.trace(2, this, "Option found: " + string2 + " = " + string3);
                continue;
            }
            boolean bl = this.flagMatch(string);
            if (bl) continue;
            Trace.trace(this, "Invalid argument: " + string);
            Trace.exit(this, "parseCommandLine");
            throw new InvalidCommandLineArgument(string);
        }
        Trace.exit(this, "parseCommandLine");
    }

    public void printUsage() {
        NLSServices.out.println(PSK.getPSKMessage("usage", "Usage: " + this.getUsage(), this.getUsage()));
    }

    public void setFlags(String string) {
        Trace.entry(this, "setFlags", string);
        this.flags = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.permissibleFlags = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.permissibleFlags[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        Trace.exit(this, "setFlags");
    }

    public void setOptions(String string) {
        Trace.entry(this, "setOptions", string);
        this.options = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.permissibleOptions = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.permissibleOptions[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        Trace.exit(this, "setOptions");
    }

    public void setSwitchCharacter(char c) {
        this.switchCharacter = c;
    }

    public void setUsage(String string) {
        if (string != null) {
            this.usage = string;
        }
    }
}

