/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APNTFY
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2004, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APNTFY.java, jms, j600, j600-201-061220 1.6.1.1 05/05/25 16:00:40";
    private static final String CLASSNAME = "APNTFY";
    public static final String LONGNAME = "OUTCOMENOTIFICATION";
    public static final String SHORTNAME = "NOTIFY";
    public static final String YES = "YES";
    public static final String NO = "NO";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        try {
            boolean bl;
            Object object2;
            if (Trace.isOn) {
                Trace.entry(this, "setObjectFromProperty");
            }
            if ((object2 = APNTFY.getProperty(SHORTNAME, hashtable)) == null) return;
            if (object2 instanceof Integer) {
                int n = (Integer)object2;
                bl = n == 1;
            } else if (object2 instanceof String) {
                String string = ((String)object2).toUpperCase();
                if (string.equals(NO)) {
                    bl = false;
                } else {
                    if (!string.equals(YES)) throw new BAOException(4, SHORTNAME, string);
                    bl = true;
                }
            } else if (object2 instanceof Boolean) {
                bl = (Boolean)object2;
            } else {
                String string = "value supplied as an unexpected object type " + object2.getClass();
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            if (object instanceof MQConnectionFactory) {
                ((MQConnectionFactory)object).setOutcomeNotification(bl);
                return;
            }
            String string = "object supplied as an unexpected type " + object.getClass();
            String string4 = "MQJMS1016";
            String string5 = ConfigEnvironment.getErrorMessage(string4, string);
            JMSException jMSException = new JMSException(string5, string4);
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setObjectFromProperty");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (object instanceof MQConnectionFactory) {
                boolean bl = ((MQConnectionFactory)object).getOutcomeNotification();
                string = bl ? YES : NO;
            } else {
                String string2 = "object is an unexpected type";
                String string3 = "MQJMS1016";
                String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                JMSException jMSException = new JMSException(string4, string3);
                throw jMSException;
            }
            if (string != null) {
                hashtable.put(LONGNAME, string);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

