/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.security.MinCrypto;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TopicConnectionImpl;
import com.ibm.mq.jms.TopicPublisherImpl;
import com.ibm.mq.jms.TopicSubscriberImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public final class TopicSessionImpl
extends SessionImpl
implements TopicSession,
ClientExceptionConstants,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/TopicSessionImpl.java, disthub, j600, j600-201-061220 1.36.1.1 05/05/25 15:22:49";
    private static final long serialVersionUID = -707352621412550726L;
    private static final DebugObject debug;
    private static final MinCrypto cryptorand;
    private String unlikely;
    private int topicCounter;
    private static final char MIN_TEMP_TOPIC_CHAR = '0';
    private static final char MAX_TEMP_TOPIC_CHAR = 'z';
    private static final char[] TEMP_TOPIC_CHARS;

    TopicSessionImpl(TopicConnectionImpl topicConnectionImpl, boolean bl, int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        super(topicConnectionImpl, bl, n);
    }

    private void makeUnlikely() {
        byte[] byArray = cryptorand.random(20);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            char c = TEMP_TOPIC_CHARS[Math.abs(byArray[i] % TEMP_TOPIC_CHARS.length)];
            stringBuffer.append(c);
        }
        this.unlikely = stringBuffer.toString();
    }

    public Topic createTopic(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopic");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (string == null || string.length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "No topic Name - JMSParameterIsNullException");
                Trace.exit(this, "createTopic");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "TopicName");
            throw new JMSParameterIsNullException(string3);
        }
        MQTopic mQTopic = new MQTopic(string);
        if (Trace.isOn) {
            Trace.exit(this, "createTopic");
        }
        return mQTopic;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSubscriber topicSubscriber = this.createSubscriber(topic, null, false);
        return topicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createSubscriber");
        }
        TopicSubscriber topicSubscriber = this.createSubscriber(topic, string, false);
        if (Trace.isOn) {
            Trace.exit(this, "createSubscriber");
        }
        return topicSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        MQTopic mQTopic = null;
        Object var5_5 = null;
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "createSubscriber");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "createSubscriber");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (topic == null || topic.toString().length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Topic is Null - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "Topic");
            throw new InvalidDestinationException(string3, string2);
        }
        if (!(topic instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string4 = "MQJMS0003";
            String string5 = ConfigEnvironment.getErrorMessage(string4);
            throw new InvalidDestinationException(string5, string4);
        }
        mQTopic = (MQTopic)topic;
        if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string6 = "MQJMS0003";
            String string7 = ConfigEnvironment.getErrorMessage(string6);
            throw new InvalidDestinationException(string7, string6);
        }
        if (topic instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)topic).isCreatedOnThisConnection(this)) {
            if (Trace.isOn) {
                Trace.trace(this, "Temporary Topic not created on this connection - JMSException");
                Trace.exit(this, "createSubscriber");
            }
            throw new JMSException(ExceptionBuilder.buildReasonString((int)793507705, null));
        }
        if (topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)topic).incUse();
        }
        TopicSubscriberImpl topicSubscriberImpl = new TopicSubscriberImpl(mQTopic, string, null, bl, this.getConnection().isPre1_2() ? 1 : 2, this);
        TopicSessionImpl topicSessionImpl = this;
        synchronized (topicSessionImpl) {
            this.consumers.addElement(topicSubscriberImpl);
            if (!this.isStopped()) {
                topicSubscriberImpl.start();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createSubscriber");
        }
        return topicSubscriberImpl;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2) throws JMSParameterIsNullException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createPublisher");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed - IllegalStateException");
                Trace.exit(this, "createPublisher");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)topic).incUse();
        }
        TopicPublisherImpl topicPublisherImpl = new TopicPublisherImpl(topic, this);
        this.producers.addElement(topicPublisherImpl);
        if (Trace.isOn) {
            Trace.exit(this, "createPublisher");
        }
        return topicPublisherImpl;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTemporaryTopic");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.unlikely == null) {
            this.makeUnlikely();
        }
        String string = this.unlikely + '/' + this.topicCounter++;
        TemporaryTopicImpl temporaryTopicImpl = new TemporaryTopicImpl(this, this.getConnection().getTemporaryTopicString(string));
        if (Trace.isOn) {
            Trace.exit(this, "createTemporaryTopic");
        }
        return temporaryTopicImpl;
    }

    public void unsubscribe(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "unsubscribe");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "unsubscribe");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        super.close(null, true);
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        TopicSubscriberImpl topicSubscriberImpl;
        int n;
        Vector vector;
        if (this.isClosed()) {
            return;
        }
        if (this.consumers != null) {
            vector = (Vector)this.consumers.clone();
            for (n = 0; n < vector.size(); ++n) {
                topicSubscriberImpl = (TopicSubscriberImpl)vector.elementAt(n);
                try {
                    topicSubscriberImpl.close(exception, bl);
                    continue;
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
        if (this.producers != null) {
            vector = (Vector)this.producers.clone();
            for (n = 0; n < vector.size(); ++n) {
                topicSubscriberImpl = (TopicPublisher)vector.elementAt(n);
                try {
                    topicSubscriberImpl.close();
                    continue;
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
        this.consumers.removeAllElements();
        this.producers.removeAllElements();
        super.close(exception, bl);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof MQTopic | destination == null) {
            return this.createPublisher((Topic)destination);
        }
        if (destination instanceof MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string = "MQJMS0003";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (destination instanceof MQTopic) {
            return this.createSubscriber((Topic)destination);
        }
        if (destination instanceof MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string = "MQJMS0003";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (destination instanceof MQTopic) {
            return this.createSubscriber((Topic)destination, string);
        }
        if (destination instanceof MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string2 = "MQJMS0003";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (destination instanceof MQTopic) {
            return this.createSubscriber((Topic)destination, string, bl);
        }
        if (destination instanceof MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string2 = "MQJMS0003";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
        throw invalidDestinationException;
    }

    static {
        int n;
        debug = new DebugObject("TopicSessionImpl");
        cryptorand = new MinCrypto();
        FastVector fastVector = new FastVector();
        for (n = 48; n <= 122; n = (int)((char)(n + 1))) {
            if (n == 47 || n == 35 || n == 43 || n == 63) continue;
            fastVector.addElement((Object)new Character((char)n));
        }
        TEMP_TOPIC_CHARS = new char[fastVector.size()];
        for (n = 0; n < fastVector.size(); ++n) {
            TopicSessionImpl.TEMP_TOPIC_CHARS[n] = ((Character)fastVector.elementAt(n)).charValue();
        }
    }
}

