/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.Logger;
import com.ibm.disthub2.impl.client.Security;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageEncrypter;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.security.CryptoInstantiationException;
import com.ibm.disthub2.impl.security.MessageProtection;
import com.ibm.disthub2.impl.security.Qop;
import com.ibm.disthub2.impl.security.SecurityContext;
import com.ibm.disthub2.impl.util.ExceptionWrapper;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.impl.util.Release;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.AuthResult;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.disthub2.spi.Principal;
import com.ibm.mq.jms.AuthBase;
import com.ibm.mq.jms.AuthClient;
import com.ibm.mq.jms.AuthPrincipal;
import com.ibm.mq.jms.ISSL;
import com.ibm.mq.jms.ISSLException;
import com.ibm.mq.jms.JsseCredsImpl;
import com.ibm.mq.jms.JsseImpl;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;

public class SxaSecurityImpl
implements Security,
ClientExceptionConstants,
ClientLogConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SxaSecurityImpl.java, disthub, j600, j600-201-061220 1.9.1.1 05/05/25 15:51:01";
    private static final DebugObject debug = new DebugObject("SxaSecurityImpl");
    protected ISSL issl = null;
    protected Object isslCreds = null;
    protected SecurityContext sc;
    protected Hashtable qopCache;
    protected static final Byte QOP_MINTEGRITY = new Byte(6);
    protected static final Byte QOP_PRIVACY = new Byte(14);
    protected Socket toAuth = null;
    BaseConfig baseConfig;

    public SxaSecurityImpl(BaseConfig baseConfig) throws AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "SxaSecurityImpl");
        }
        this.baseConfig = baseConfig;
        if (AuthBase.SSLrequired(AuthBase.parseAuthProtocols(this.baseConfig.AUTH_PROTOCOLS))) {
            try {
                this.issl = new JsseImpl();
                if (Trace.isOn()) {
                    Trace.trace(this, "Instantiated JsseImpl");
                }
                this.issl.setEnabledCipherSuites(this.baseConfig.SSL_CIPHER_SUITES);
                if (Trace.isOn()) {
                    Trace.trace(this, "Set cipherSuites");
                }
                JsseCredsImpl jsseCredsImpl = new JsseCredsImpl(this.baseConfig.SSL_SOCKET_FACTORY, this.baseConfig.SSL_PEER_NAME, this.baseConfig.SSL_CERT_STORES);
                if (Trace.isOn()) {
                    Trace.trace(this, "Created JsseCredsImpl object");
                }
                this.isslCreds = this.issl.createCredentials(jsseCredsImpl);
            }
            catch (ISSLException iSSLException) {
                if (Trace.isOn) {
                    Trace.exit(this, "sxaSecurity");
                }
                throw new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)841495238, (Object[])new Object[]{new ExceptionWrapper((Throwable)iSSLException)})), null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "SxaSecurityImpl");
        }
    }

    public Principal createPrincipal(String string, String string2) {
        return new RealSecUsername(string == null ? "" : string, string2 == null ? "" : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authorize(Socket socket, Principal principal) throws IOException {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"authorize", (Object)socket);
        }
        try {
            SxaSecurityImpl sxaSecurityImpl;
            Properties properties = new Properties();
            properties.put("release", "1.2");
            short[] sArray = AuthBase.parseAuthProtocols(this.baseConfig.AUTH_PROTOCOLS);
            if (this.baseConfig.AUTH_TIMEOUT > 0L) {
                sxaSecurityImpl = this;
                synchronized (sxaSecurityImpl) {
                    this.toAuth = socket;
                    if (this.baseConfig.THREADER != null) {
                        this.baseConfig.THREADER.schedule((Runnable)new AuthTimer(this, this.baseConfig.AUTH_TIMEOUT));
                    } else {
                        new Thread(new AuthTimer(this, this.baseConfig.AUTH_TIMEOUT)).start();
                    }
                }
            }
            sxaSecurityImpl = new AuthClient(socket, (AuthPrincipal)principal, properties, sArray, this.issl).authenticate();
            if (this.baseConfig.AUTH_TIMEOUT > 0L) {
                SxaSecurityImpl sxaSecurityImpl2 = this;
                synchronized (sxaSecurityImpl2) {
                    this.toAuth = null;
                    this.notifyAll();
                }
            }
            n = Release.getRemoteRelease((String)((AuthResult)sxaSecurityImpl).authMetaData.getProperty("release"));
            if (Boolean.valueOf(((AuthResult)sxaSecurityImpl).authMetaData.getProperty("qop", "false")).booleanValue()) {
                this.baseConfig.ENABLE_QOP_SECURITY = true;
            }
            this.sc = new SecurityContext(principal, ((AuthResult)sxaSecurityImpl).sharedSecret, this.baseConfig.ENABLE_QOP_SECURITY);
        }
        catch (CryptoInstantiationException cryptoInstantiationException) {
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"authorize", (Object)("Failed with exception: " + new ExceptionWrapper((Throwable)cryptoInstantiationException)));
            }
            throw new IOException(ExceptionBuilder.buildReasonString((int)-911376984, (Object[])new Object[]{cryptoInstantiationException}));
        }
        catch (Exception exception) {
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"authorize", (Object)("Failed with exception: " + new ExceptionWrapper((Throwable)exception)));
            }
            throw new IOException(ExceptionBuilder.buildReasonString((int)-873358984, (Object[])new Object[]{exception}));
        }
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            this.qopCache = new Hashtable();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"authorize", (Object)new Integer(n));
        }
        return n;
    }

    public MessageEncrypter incoming(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"incoming", (Object)byArray);
        }
        MessageProtection messageProtection = null;
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            Qop.checkIntegrity((byte[])byArray, (SecurityContext)this.sc, (boolean)false, (boolean)this.baseConfig.ENABLE_QOP_SECURITY);
            if (Framing.qop((byte[])byArray) == 14) {
                MessageProtection messageProtection2 = this.sc.getMP();
                Qop.sessionDecrypt((byte[])byArray, (MessageProtection)messageProtection2, (Object)this.sc.getServerKey(), (byte[])this.sc.getDecryptIV());
                messageProtection = messageProtection2;
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"incoming", (Object)Hex.toString((byte[])byArray));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"incoming", messageProtection);
        }
        return messageProtection;
    }

    public byte[] outgoing(MessageHandle messageHandle, byte by) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"outgoing", (Object)messageHandle, (Object)new Byte(by));
        }
        if (!this.baseConfig.ENABLE_QOP_SECURITY && by != 1) {
            throw new IOException(ExceptionBuilder.buildReasonString((int)-1015179332, null));
        }
        MessageProtection messageProtection = by == 14 ? this.sc.getMP() : null;
        int n = Framing.overhead((byte)by, (MessageEncrypter)this.sc.getMP(), (boolean)false);
        int n2 = messageHandle.getEncodedLength((MessageEncrypter)messageProtection);
        byte[] byArray = new byte[n + n2];
        int n3 = messageHandle.toByteArray(byArray, n, n2, (MessageEncrypter)messageProtection);
        if (by != 14) {
            n3 = 0;
        }
        if (by == 1) {
            Framing.frameMessage((byte[])byArray, (short)messageHandle.getInterpreterId(), (long)messageHandle.getEncodingSchema().getId(), (int)byArray.length);
        } else {
            byte[] byArray2 = null;
            if ((by & 6) == 6) {
                byArray2 = Qop.computeDigest((byte[])byArray, (int)(n + n3), (int)(n2 - n3), (MessageProtection)this.sc.getMP());
            }
            Qop.frameMessage((byte[])byArray, (short)messageHandle.getInterpreterId(), (long)messageHandle.getEncodingSchema().getId(), (byte)by, (int)(by == 14 ? n3 : -1), (SecurityContext)this.sc, (byte[])byArray2, (boolean)true, (int)(n + n2));
            Qop.channelProtect((byte[])byArray, (MessageProtection)this.sc.getMP(), (long)this.sc.getNextSendCount(), (Object[])this.sc.getClientMAC());
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"outgoing", (Object)Hex.toString((byte[])byArray));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"outgoing", (Object)byArray);
        }
        return byArray;
    }

    public byte[] framePropagationMessage(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"framePropagationMessage", (Object)byArray);
        }
        byte by = this.baseConfig.ENABLE_QOP_SECURITY ? (byte)14 : 1;
        int n = Framing.overhead((byte)by, (MessageEncrypter)this.sc.getMP(), (boolean)true);
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            Qop.framePropagationMessage((byte[])byArray2, (SecurityContext)this.sc, (boolean)true, (int)byArray2.length);
        } else {
            Framing.framePropagationMessage((byte[])byArray2, (int)byArray2.length);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"framePropagationMessage", (Object)byArray2);
        }
        return byArray2;
    }

    public byte getQop(MessageHandle messageHandle) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getQop", (Object)messageHandle);
        }
        int n = 1;
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            int n2 = messageHandle.getChoice(149);
            if (n2 == 10) {
                n = Qop.getSingleHopControlRequiredQop((int)messageHandle.getChoice(162));
            } else if (n2 != 1) {
                n = Qop.getPayloadRequiredQop((int)n2);
            } else {
                String string = messageHandle.getString(4);
                Byte by = (Byte)this.qopCache.get(string);
                if (by != null) {
                    n = by.byteValue();
                } else {
                    messageHandle.setBoolean(1, true);
                    n = 14;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"qopUpdate", (Object)new Byte((byte)n));
        }
        return (byte)n;
    }

    public void qopUpdate(MessageHandle messageHandle) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"qopUpdate", (Object)messageHandle);
        }
        if (this.qopCache == null) {
            throw new IOException(ExceptionBuilder.buildReasonString((int)-1015179332, null));
        }
        this.qopCache.put(messageHandle.getString(45), new Byte(messageHandle.getByte(44)));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"qopUpdate");
        }
    }

    static class AuthTimer
    implements Runnable {
        private SxaSecurityImpl instance;
        private long time;

        public AuthTimer(SxaSecurityImpl sxaSecurityImpl, long l) {
            this.instance = sxaSecurityImpl;
            this.time = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                try {
                    SxaSecurityImpl sxaSecurityImpl = this.instance;
                    synchronized (sxaSecurityImpl) {
                        this.instance.wait(this.time);
                        if (this.instance.toAuth != null) {
                            try {
                                this.instance.toAuth.shutdownInput();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                this.instance.toAuth.shutdownOutput();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.instance.toAuth.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!Logger.logIt((long)1198397518584002L)) break block10;
                    Logger.log((long)1198397518584002L, (String)"SxaSecurityImpl", (Object[])new Object[]{new ExceptionWrapper(throwable)});
                }
            }
        }
    }

    public class RealSecUsername
    implements Principal,
    AuthPrincipal {
        protected String m_login;
        protected String m_passwd;

        public RealSecUsername(String string, String string2) {
            this.m_login = string;
            this.m_passwd = string2;
        }

        public String toString() {
            return this.m_login;
        }

        public int hashCode() {
            return this.m_login.hashCode();
        }

        public String getName() {
            return this.m_login;
        }

        public String getPassword() {
            return this.m_passwd;
        }

        public Object getSSLCredentials() {
            return SxaSecurityImpl.this.isslCreds;
        }

        public boolean equals(Object object) {
            try {
                RealSecUsername realSecUsername = (RealSecUsername)object;
                return this.m_login.equals(realSecUsername.m_login);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

