/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/StreamMessageImpl.java, disthub, j600, j600-201-061220 1.23.1.1 05/05/25 15:42:46";
    private static final DebugObject debug = new DebugObject("StreamMessageImpl");
    static final StringBuffer NULL = new StringBuffer("<null>");
    Vector fields;
    int lastField = -1;
    private byte[] buf;
    private int offset;

    public StreamMessageImpl(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        super(messageHandle, connectionImpl);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"StreamMessageImpl", (Object)messageHandle);
        }
        this.messageClass = "jms_stream";
        this.fields = this.getFields();
        this.readOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"StreamMessageImpl");
        }
    }

    public StreamMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"StreamMessageImpl");
        }
        this.messageClass = "jms_stream";
        this.fields = new Vector();
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"StreamMessageImpl");
        }
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        this.fields = new Vector();
        this.buf = null;
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
    }

    public boolean readBoolean() throws JMSException {
        Boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBoolean");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e instanceof Boolean) {
            bl = (Boolean)e;
        } else if (e instanceof String) {
            bl = Boolean.valueOf((String)e);
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBoolean", (Object)bl);
        }
        return bl;
    }

    public byte readByte() throws JMSException {
        byte by;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readByte");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Byte) {
            by = (Byte)e;
        } else if (e instanceof String) {
            try {
                by = Byte.parseByte((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readByte", (Object)new Byte(by));
        }
        return by;
    }

    public short readShort() throws JMSException {
        short s;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readShort");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Short || e instanceof Byte) {
            s = ((Number)e).shortValue();
        } else if (e instanceof String) {
            try {
                s = Short.parseShort((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readShort", (Object)new Short(s));
        }
        return s;
    }

    public char readChar() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readChar");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NullPointerException();
        }
        char c = '\u0000';
        if (!(e instanceof Character)) {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        c = ((Character)e).charValue();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readChar", (Object)new Character(c));
        }
        return c;
    }

    public int readInt() throws JMSException {
        int n;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readInt");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Integer || e instanceof Short || e instanceof Byte) {
            n = ((Number)e).intValue();
        } else if (e instanceof String) {
            try {
                n = Integer.parseInt((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readInt", (Object)new Integer(n));
        }
        return n;
    }

    public long readLong() throws JMSException {
        long l;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readLong");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Long || e instanceof Integer || e instanceof Short || e instanceof Byte) {
            l = ((Number)e).longValue();
        } else if (e instanceof String) {
            try {
                l = Long.parseLong((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readLong", (Object)new Long(l));
        }
        return l;
    }

    public float readFloat() throws JMSException {
        Float f;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readFloat");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Float) {
            f = (Float)e;
        } else if (e instanceof String) {
            try {
                f = Float.valueOf((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readFloat", (Object)f);
        }
        return f.floatValue();
    }

    public double readDouble() throws JMSException {
        Double d;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readDouble");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (e == null || e == NULL) {
            --this.lastField;
            throw new NumberFormatException();
        }
        if (e instanceof Double) {
            d = (Double)e;
        } else if (e instanceof String) {
            try {
                d = Double.valueOf((String)e);
            }
            catch (NumberFormatException numberFormatException) {
                --this.lastField;
                throw numberFormatException;
            }
        } else if (e instanceof Float) {
            d = new Double(((Float)e).doubleValue());
        } else {
            --this.lastField;
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readDouble", (Object)d);
        }
        return d;
    }

    public String readString() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readString");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        String string = null;
        if (e != null) {
            if (e instanceof byte[]) {
                --this.lastField;
                String string2 = "MQJMS0006";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new MessageFormatException(string3, string2);
            }
            string = e instanceof String ? (String)e : e.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readString", (Object)string);
        }
        return string;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBytes", (Object)byArray);
        }
        int n = -1;
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf == null) {
            ++this.lastField;
            if (this.lastField >= this.fields.size()) {
                throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            }
            Object e = this.fields.elementAt(this.lastField);
            if (e == null || e == NULL) {
                this.buf = null;
                return -1;
            }
            if (e instanceof byte[]) {
                this.buf = (byte[])e;
                this.offset = 0;
            } else if (!(e instanceof byte[])) {
                --this.lastField;
                String string = "MQJMS0006";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                throw new MessageFormatException(string2, string);
            }
        }
        int n2 = this.buf.length - this.offset;
        if (this.buf.length == 0) {
            this.buf = null;
            return 0;
        }
        if (n2 == 0) {
            this.buf = null;
            return -1;
        }
        if (byArray.length > n2) {
            System.arraycopy(this.buf, this.offset, byArray, 0, n2);
            this.offset = 0;
            this.buf = null;
            n = n2;
        } else if (byArray.length == n2) {
            System.arraycopy(this.buf, this.offset, byArray, 0, n2);
            this.offset = this.buf.length;
            n = n2;
        } else {
            System.arraycopy(this.buf, this.offset, byArray, 0, byArray.length);
            this.offset += byArray.length;
            n = byArray.length;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBytes", (Object)new Integer(n2));
        }
        return n;
    }

    public Object readObject() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readObject");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.buf != null) {
            throw new MessageFormatException(ExceptionBuilder.buildReasonString((int)-881562132, null));
        }
        ++this.lastField;
        if (this.lastField >= this.fields.size()) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        Object e = this.fields.elementAt(this.lastField);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readObject", e);
        }
        return e;
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBoolean", (Object)new Boolean(bl));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Boolean(bl), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBoolean");
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeByte", (Object)new Byte(by));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Byte(by), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeByte");
        }
    }

    public void writeShort(short s) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeShort", (Object)new Short(s));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Short(s), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeShort");
        }
    }

    public void writeChar(char c) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeChar", (Object)new Character(c));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Character(c), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeChar");
        }
    }

    public void writeInt(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeInt", (Object)new Integer(n));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Integer(n), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeInt");
        }
    }

    public void writeLong(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeLong", (Object)new Long(l));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Long(l), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeLong");
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeFloat", (Object)new Float(f));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Float(f), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeFloat");
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeDouble", (Object)new Double(d));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(new Double(d), this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeDouble");
        }
    }

    public void writeString(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeString", (Object)string);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(string, this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeString");
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes", (Object)byArray);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        this.fields.insertElementAt(byArray, this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes", (Object)byArray, (Object)new Integer(n), (Object)new Integer(n2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        ++this.lastField;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.fields.insertElementAt(byArray2, this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeObject", object);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (!(object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof byte[] || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Float)) {
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        ++this.lastField;
        this.fields.insertElementAt(object, this.lastField);
        this.setFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeObject");
        }
    }

    public void reset() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"reset");
        }
        this.fields = this.getFields();
        this.lastField = -1;
        this.readOnly = true;
        this.buf = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"reset");
        }
    }
}

