/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MapMessageImpl.java, disthub, j600, j600-201-061220 1.20.1.1 05/05/25 15:43:22";
    private static final DebugObject debug = new DebugObject("MapMessageImpl");
    public boolean mapNameStyle = true;
    Dictionary fields;

    public MapMessageImpl(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        super(messageHandle, connectionImpl);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MapMessageImpl", (Object)messageHandle);
        }
        this.messageClass = "jms_map";
        this.fields = this.getNamedFields();
        this.readOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MapMessageImpl");
        }
    }

    public MapMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MapMessageImpl");
        }
        this.messageClass = "jms_map";
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MapMessageImpl");
        }
    }

    public boolean getBoolean(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBoolean", (Object)string);
        }
        Object v = this.fields.get(string);
        Boolean bl = null;
        if (v == null) {
            bl = new Boolean(false);
        } else if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v instanceof String) {
            bl = Boolean.valueOf((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBoolean", (Object)bl);
        }
        return bl;
    }

    public byte getByte(String string) throws JMSException {
        byte by;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getByte", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Byte) {
            by = (Byte)v;
        } else if (v instanceof String) {
            by = Byte.parseByte((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getByte", (Object)new Byte(by));
        }
        return by;
    }

    public short getShort(String string) throws JMSException {
        short s;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getShort", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Short || v instanceof Byte) {
            s = ((Number)v).shortValue();
        } else if (v instanceof String) {
            s = Short.parseShort((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getShort", (Object)new Short(s));
        }
        return s;
    }

    public char getChar(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getChar", (Object)string);
        }
        Object v = this.fields.get(string);
        char c = '\u0000';
        if (v == null) {
            throw new NullPointerException();
        }
        if (!(v instanceof Character)) {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        c = ((Character)v).charValue();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getChar", (Object)new Character(c));
        }
        return c;
    }

    public int getInt(String string) throws JMSException {
        int n;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getInt", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Integer || v instanceof Short || v instanceof Byte) {
            n = ((Number)v).intValue();
        } else if (v instanceof String) {
            n = Integer.parseInt((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getInt", (Object)new Integer(n));
        }
        return n;
    }

    public long getLong(String string) throws JMSException {
        long l;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getLong", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte) {
            l = ((Number)v).longValue();
        } else if (v instanceof String) {
            l = Long.parseLong((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getLong", (Object)new Long(l));
        }
        return l;
    }

    public float getFloat(String string) throws JMSException {
        Float f;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getFloat", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NullPointerException();
        }
        if (v instanceof Float) {
            f = (Float)v;
        } else if (v instanceof String) {
            f = Float.valueOf((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getFloat", (Object)f);
        }
        return f.floatValue();
    }

    public double getDouble(String string) throws JMSException {
        Double d;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDouble", (Object)string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NullPointerException();
        }
        if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof String) {
            d = Double.valueOf((String)v);
        } else if (v instanceof Float) {
            d = new Double(((Float)v).doubleValue());
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDouble", (Object)d);
        }
        return d;
    }

    public String getString(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getString", (Object)string);
        }
        Object v = this.fields.get(string);
        String string2 = null;
        if (v != null) {
            if (v instanceof byte[]) {
                String string3 = "MQJMS0006";
                String string4 = ConfigEnvironment.getErrorMessage(string3);
                throw new MessageFormatException(string4, string3);
            }
            string2 = v.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getString", (Object)string2);
        }
        return string2;
    }

    public byte[] getBytes(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBytes", (Object)string);
        }
        Object v = this.fields.get(string);
        byte[] byArray = null;
        if (v != null) {
            if (v instanceof byte[]) {
                byArray = (byte[])v;
            } else {
                String string2 = "MQJMS0006";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new MessageFormatException(string3, string2);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBytes", (Object)byArray);
        }
        return byArray;
    }

    public Object getObject(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getObject", (Object)string);
        }
        Object v = this.fields.get(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObject", v);
        }
        return v;
    }

    public Enumeration getMapNames() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMapNames");
        }
        Enumeration enumeration = this.fields.keys();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMapNames", enumeration);
        }
        return enumeration;
    }

    public void setBoolean(String string, boolean bl) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBoolean", (Object)string, (Object)new Boolean(bl));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Boolean(bl));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBoolean");
        }
    }

    public void setByte(String string, byte by) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setByte", (Object)string, (Object)new Byte(by));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Byte(by));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setByte");
        }
    }

    public void setShort(String string, short s) throws JMSException {
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setString");
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Short(s));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setShort");
        }
    }

    public void setChar(String string, char c) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setChar", (Object)string, (Object)new Character(c));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Character(c));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setChar");
        }
    }

    public void setInt(String string, int n) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setInt", (Object)string, (Object)new Integer(n));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Integer(n));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setInt");
        }
    }

    public void setLong(String string, long l) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setLong", (Object)string, (Object)new Long(l));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Long(l));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setLong");
        }
    }

    public void setFloat(String string, float f) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setFloat", (Object)string, (Object)new Float(f));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Float(f));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setFloat");
        }
    }

    public void setDouble(String string, double d) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDouble", (Object)string, (Object)new Double(d));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        this.fields.put(string, new Double(d));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDouble");
        }
    }

    public void setString(String string, String string2) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setString", (Object)string, (Object)string2);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = "MQJMS1058";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string);
            throw new IllegalArgumentException(string4);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        if (string2 == null) {
            this.fields.put(string, NULL);
        } else {
            this.fields.put(string, string2);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setString");
        }
    }

    public void setBytes(String string, byte[] byArray) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBytes", (Object)string, (Object)byArray);
        }
        if (byArray == null) {
            this.setObject(string, byArray);
        } else if (byArray.length == 0) {
            this.setObject(string, byArray);
        } else {
            this.setBytes(string, byArray, 0, byArray.length);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBytes");
        }
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBytes", (Object)string, (Object)byArray, (Object)new Integer(n), (Object)new Integer(n2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        if (n2 == 0) {
            this.fields.put(string, new byte[0]);
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.fields.put(string, byArray2);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBytes");
        }
    }

    public void setObject(String string, Object object) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObject", (Object)string, object);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.mapNameStyle && !this.isSettableMapName(string)) {
            throw new MessageFormatException("MQJMS1066", string);
        }
        if (object == null) {
            this.fields.put(string, NULL);
        } else if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[]) {
            this.fields.put(string, object);
        } else {
            String string4 = "MQJMS0006";
            String string5 = ConfigEnvironment.getErrorMessage(string4);
            throw new MessageFormatException(string5, string4);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObject");
        }
    }

    public boolean itemExists(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"itemExists", (Object)string);
        }
        boolean bl = ((Hashtable)this.fields).containsKey(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"itemExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
    }

    private boolean isSettableMapName(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isSettableMapName");
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) continue;
                bl = false;
                break;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            bl = false;
            break;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isSettableMapName");
        }
        return bl;
    }
}

