/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQXAQueueManager;
import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.MQXATopicSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAException;

public class MQXATopicConnection
extends MQTopicConnection
implements XATopicConnection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXATopicConnection.java, jms, j600, j600-201-061220 1.17.1.2 06/08/18 15:18:53";

    MQXATopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory) throws JMSException {
        super(mQTopicConnectionFactory);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    MQXATopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory, String string, String string2) throws JMSException {
        super(mQTopicConnectionFactory, string, string2);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    public XATopicSession createXATopicSession() throws JMSException {
        MQTopicSession mQTopicSession = null;
        try {
            MQXATopicSession mQXATopicSession;
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicSession");
            }
            boolean bl = true;
            mQTopicSession = (MQTopicSession)super.createTopicSession(true, 0, 1);
            MQQueueManager mQQueueManager = mQTopicSession.getQM();
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(mQQueueManager);
            MQXAResource mQXAResource = mQXAQueueManager.getXAResource();
            MQXATopicSession mQXATopicSession2 = mQXATopicSession = new MQXATopicSession((MQConnection)this, mQTopicSession, mQXAResource);
            return mQXATopicSession2;
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1068");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + xAException);
            }
            if (mQTopicSession != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Disabling XA transaction mode on MQTopicSession");
                }
                mQTopicSession.setDistTransactionMode(0);
            } else if (Trace.isOn) {
                Trace.trace(this, "MQTopicSession is null, unable to disable XA transaction mode.");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXATopicSession");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XASession createXASession() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXASession");
            }
            XATopicSession xATopicSession = this.createXATopicSession();
            return xATopicSession;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXASession");
            }
        }
    }
}

