/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQXAQueueManager;
import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.MQXAQueueSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.MQXATopicSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAException;

public class MQXAConnection
extends MQConnection
implements XAConnection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXAConnection.java, jms, j600, j600-201-061220 1.8.1.2 06/08/18 15:18:52";

    MQXAConnection(MQConnectionFactory mQConnectionFactory) throws JMSException {
        super(mQConnectionFactory, null, null, true);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    MQXAConnection(MQConnectionFactory mQConnectionFactory, String string, String string2) throws JMSException {
        super(mQConnectionFactory, string, string2, true);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        MQQueueSession mQQueueSession = null;
        try {
            MQXAQueueSession mQXAQueueSession;
            if (Trace.isOn) {
                Trace.entry(this, "createXAQueueSession");
            }
            mQQueueSession = (MQQueueSession)super.createSession(true, 0, 1);
            MQQueueManager mQQueueManager = mQQueueSession.getQM();
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(mQQueueManager);
            MQXAResource mQXAResource = mQXAQueueManager.getXAResource();
            MQXAQueueSession mQXAQueueSession2 = mQXAQueueSession = new MQXAQueueSession((MQConnection)this, mQQueueSession, mQXAResource);
            return mQXAQueueSession2;
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1068");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + xAException);
                Trace.trace(this, "linked exception reasonCode: " + xAException.errorCode);
            }
            if (mQQueueSession != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Disabling XA transaction mode on MQQueueSession");
                }
                mQQueueSession.setDistTransactionMode(0);
            } else if (Trace.isOn) {
                Trace.trace(this, "MQQueueSession is null, unable to disable XA transaction mode.");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAQueueSession");
            }
        }
    }

    public XATopicSession createXATopicSession() throws JMSException {
        MQTopicSession mQTopicSession = null;
        try {
            MQXATopicSession mQXATopicSession;
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicSession");
            }
            boolean bl = true;
            mQTopicSession = (MQTopicSession)super.createSession(true, 0, 1);
            MQQueueManager mQQueueManager = mQTopicSession.getQM();
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(mQQueueManager);
            MQXAResource mQXAResource = mQXAQueueManager.getXAResource();
            MQXATopicSession mQXATopicSession2 = mQXATopicSession = new MQXATopicSession((MQConnection)this, mQTopicSession, mQXAResource);
            return mQXATopicSession2;
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1068");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + xAException);
            }
            if (mQTopicSession != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Disabling XA transaction mode on MQTopicSession");
                }
                mQTopicSession.setDistTransactionMode(0);
            } else if (Trace.isOn) {
                Trace.trace(this, "MQTopicSession is null, unable to disable XA transaction mode.");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXATopicSession");
            }
        }
    }

    public XASession createXASession() throws JMSException {
        MQSession mQSession = null;
        try {
            MQXASession mQXASession;
            if (Trace.isOn) {
                Trace.entry(this, "createXASession");
            }
            boolean bl = true;
            mQSession = (MQSession)super.createSession(true, 0, 1);
            MQQueueManager mQQueueManager = mQSession.getQM();
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(mQQueueManager);
            MQXAResource mQXAResource = mQXAQueueManager.getXAResource();
            MQXASession mQXASession2 = mQXASession = new MQXASession((MQConnection)this, mQSession, mQXAResource);
            return mQXASession2;
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1068");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + xAException);
            }
            if (mQSession != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Disabling XA transaction mode on MQSession");
                }
                mQSession.setDistTransactionMode(0);
            } else if (Trace.isOn) {
                Trace.trace(this, "MQSession is null, unable to disable XA transaction mode.");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXASession");
            }
        }
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return super.createSession(bl, n);
    }

    public String getClientID() throws JMSException {
        return super.getClientID();
    }

    public void setClientID(String string) throws JMSException {
        super.setClientID(string);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return super.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return super.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        super.setExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        super.start();
    }

    public void stop() throws JMSException {
        super.stop();
    }

    public void close() throws JMSException {
        super.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return super.createConnectionConsumer(destination, string, serverSessionPool, n);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return super.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
    }
}

