/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQRRSQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQRRSTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.MQXATopicConnection;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class MQTopicConnection
extends MQConnection
implements TopicConnection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQTopicConnection.java, jms, j600, j600-201-061220 1.108.1.2 06/06/28 11:08:30";

    MQTopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory) throws JMSException {
        this(mQTopicConnectionFactory, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQTopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory, String string, String string2) throws JMSException {
        super(mQTopicConnectionFactory, string, string2);
        try {
            String string3;
            String string4;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            this.qmgrName = mQTopicConnectionFactory.getQueueManager();
            this.brkControlQueue = mQTopicConnectionFactory.getBrokerControlQueue();
            this.brkQueueManager = mQTopicConnectionFactory.getBrokerQueueManager();
            this.brkPubQueue = mQTopicConnectionFactory.getBrokerPubQueue();
            this.brkSubQueue = mQTopicConnectionFactory.getBrokerSubQueue();
            this.brkCCSubQueue = mQTopicConnectionFactory.getBrokerCCSubQueue();
            this.brkVersion = mQTopicConnectionFactory.getBrokerVersion();
            this.messageSelection = mQTopicConnectionFactory.getMessageSelection();
            this.pubAckInterval = mQTopicConnectionFactory.getPubAckInterval();
            this.statusRefreshInterval = mQTopicConnectionFactory.getStatusRefreshInterval();
            this.sparseSubscriptions = mQTopicConnectionFactory.getSparseSubscriptions();
            this.multicast = mQTopicConnectionFactory.getMulticast();
            if (!(mQTopicConnectionFactory instanceof MQXATopicConnectionFactory)) {
                this.receiveIsolation = mQTopicConnectionFactory.getReceiveIsolation();
                this.outcomeNotification = mQTopicConnectionFactory.getOutcomeNotification();
                this.processDuration = mQTopicConnectionFactory.getProcessDuration();
                this.optimisticPublication = mQTopicConnectionFactory.getOptimisticPublication();
            }
            if ((string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("MQJMS_SPARSE_SUBS");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            })) != null && ((string3 = string4.toUpperCase()).equals("YES") || string3.equals("TRUE"))) {
                if (Trace.isOn) {
                    Trace.trace(this, "sparseSubscriptions set by system property");
                }
                this.sparseSubscriptions = true;
            }
            if ((string3 = mQTopicConnectionFactory.getClientId()) != null) {
                this.setClientID(string3);
            }
            if (this instanceof MQXATopicConnection) {
                this.initialQm = this.createQMXA();
                try {
                    this.initialQm.disconnect();
                }
                catch (Exception exception) {
                }
                finally {
                    this.initialQm = null;
                }
            } else {
                if (this instanceof MQRRSTopicConnection) {
                    this.initialQm = this.createQMNonXA();
                    MQRRSQueueManager mQRRSQueueManager = new MQRRSQueueManager(this.initialQm);
                    try {
                        mQRRSQueueManager.honourRRS();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        try {
                            this.initialQm.disconnect();
                        }
                        catch (MQException mQException2) {
                            // empty catch block
                        }
                        this.initialQm = null;
                        throw jMSException;
                    }
                }
                this.initialQm = this.createQMNonXA();
            }
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
        catch (JMSException jMSException) {
            if (this.poolToken != null) {
                MQEnvironment.removeConnectionPoolToken((MQPoolToken)this.poolToken);
                this.poolToken = null;
            }
            this.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
    }

    public synchronized TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        MQTopicSession mQTopicSession = (MQTopicSession)this.createTopicSession(bl, n, 0);
        mQTopicSession.mapNameStyle = this.mapNameStyle;
        return mQTopicSession;
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public synchronized void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            super.close();
            if (this.psServices != null) {
                this.subscriptionEngine.close();
                this.psServices = null;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "close", (Throwable)jMSException);
            }
            this.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    synchronized TopicSession createTopicSession(boolean bl, int n, int n2) throws JMSException {
        MQTopicSession mQTopicSession;
        block41: {
            MQQueueManager mQQueueManager = null;
            mQTopicSession = null;
            try {
                Object object;
                if (Trace.isOn) {
                    Trace.entry(this, "createTopicSession");
                }
                if (!bl) {
                    switch (n) {
                        case 1: 
                        case 2: 
                        case 3: {
                            if (!Trace.isOn) break;
                            Trace.trace(this, "acknowledge mode " + n);
                            break;
                        }
                        default: {
                            if (Trace.isOn) {
                                Trace.trace(this, "Bad acknowledge mode " + n);
                            }
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1001");
                            throw jMSException;
                        }
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "distributed transactional mode " + n2);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Bad distributed transactional mode " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
                if (this.isClosed()) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                this.setClientIDFixed();
                if (this.initialQm != null) {
                    mQQueueManager = this.initialQm;
                    this.initialQm = null;
                } else {
                    if (this.factory.getCCDTURL() != null) {
                        this.mqProperties.put("channel", "");
                    }
                    switch (n2) {
                        case 0: {
                            mQQueueManager = this.createQMNonXA();
                            break;
                        }
                        case 1: {
                            mQQueueManager = this.createQMXA();
                            break;
                        }
                        case 2: {
                            mQQueueManager = this.createQMNonXA();
                            object = new MQRRSQueueManager(mQQueueManager);
                            try {
                                object.honourRRS();
                                break;
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                try {
                                    mQQueueManager.disconnect();
                                }
                                catch (MQException mQException2) {
                                    // empty catch block
                                }
                                mQQueueManager = null;
                                throw jMSException;
                            }
                        }
                        default: {
                            if (Trace.isOn) {
                                Trace.trace(this, "Distibuted transactional mode unexpectedly changed! Now " + n2);
                            }
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                            throw jMSException;
                        }
                    }
                }
                if (mQQueueManager != null) {
                    this.setSupportsQAT2(mQQueueManager.getSupportsQAT2());
                }
                if (mQQueueManager.name == null || mQQueueManager.name.trim().equals("")) {
                    if (Trace.isOn) {
                        Trace.trace(this, "QueueManager has null or empty name. Need to resolve it");
                    }
                    object = Utils.inquireString((MQManagedObject)mQQueueManager, 2015);
                    if (Trace.isOn) {
                        Trace.trace(this, "Got resolved QueueManager name = '" + (String)object + "'");
                    }
                    if (!((String)(object = object == null ? "" : ((String)object).trim())).equals(mQQueueManager.name)) {
                        mQQueueManager.name = object;
                    }
                }
                mQTopicSession = new MQTopicSession(this, mQQueueManager, bl, n);
                mQTopicSession.setDistTransactionMode(n2);
                mQTopicSession.mapNameStyle = this.mapNameStyle;
                this.addSession(mQTopicSession);
                if (!this.isStarted()) break block41;
                try {
                    mQTopicSession.start();
                }
                catch (JMSException jMSException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1033", jMSException.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println(ConfigEnvironment.getMessage("MQJMS1038") + logException);
                    }
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                this.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "createTopicSession");
                }
            }
        }
        return mQTopicSession;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createSession");
            }
            TopicSession topicSession = this.createTopicSession(bl, n);
            return topicSession;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createSession");
            }
        }
    }
}

