/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.client.Topic;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQTopic
extends MQDestination
implements javax.jms.Topic,
Referenceable,
Serializable,
Topic {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2007 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQTopic.java, jms, j600, j600-201-070220 1.75.1.7 07/02/16 15:08:49";
    private String baseTopicName = null;
    private String brokerDurSubQueue = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
    private String brokerCCDurSubQueue = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
    private int multicast = -1;
    private int brokerVersion = 0;
    protected int defaultBrkVer = 0;
    private String cachedTopicName = null;
    private String cachedNVs = null;
    private String cachedTopicOnlyNVs = null;
    private String brokerPubQueue = "";
    private String brokerPubQueueManager = "";
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopic;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicFactory;

    public MQTopic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQTopic(String string) throws JMSException {
        String string2 = "MQJMS0003";
        try {
            String string3;
            if (Trace.isOn) {
                Trace.entry(this, "constructor(topicName)");
            }
            if (string == null || string.trim().equals("") || string.length() > 0 && string.startsWith("/u0001")) {
                String string4 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string2);
                throw invalidDestinationException;
            }
            if ((string = string.trim()).startsWith("topic://")) {
                string3 = string.length() > 8 ? string.substring(8) : "";
            } else {
                this.setBaseTopicName(string);
                return;
            }
            int n = string3.indexOf(63);
            if (n != -1) {
                this.setBaseTopicName(string3.substring(0, n));
                String string5 = string3.substring(n + 1);
                Properties properties = this.getPropertiesFromURI(string5);
                this.setFromProperties(properties);
            } else {
                this.setBaseTopicName(string3);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(topicName)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTopicName() {
        try {
            CharSequence charSequence;
            if (Trace.isOn) {
                Trace.entry(this, "getTopicName");
            }
            if (this.cachedTopicName == null || this.cachedDNVs == null || this.cachedUNVs == null || this.cachedTopicOnlyNVs == null) {
                String string;
                charSequence = new StringBuffer(100).append("topic://");
                if (this.baseTopicName != null) {
                    ((StringBuffer)charSequence).append(this.baseTopicName);
                }
                if ((string = this.getNVs()).length() > 0) {
                    ((StringBuffer)charSequence).append('?').append(string);
                }
                this.cachedTopicName = ((StringBuffer)charSequence).toString();
            }
            charSequence = this.cachedTopicName;
            return charSequence;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getTopicName");
            }
        }
    }

    public String getBrokerDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerDurSubQueue");
            Trace.trace(this, "Returning: " + this.brokerDurSubQueue);
            Trace.exit(this, "getBrokerDurSubQueue");
        }
        return this.brokerDurSubQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerDurSubQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBrokerDurSubQueue");
                Trace.trace(this, "Param: " + string);
            }
            if (string == null || string.length() > 48) {
                String string2 = string == null ? "<null>" : string;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerDurSubQueue", string2);
                throw jMSException;
            }
            this.brokerDurSubQueue = string;
            this.cachedTopicOnlyNVs = null;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setBrokerDurSubQueue");
            }
        }
    }

    public String getBrokerCCDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerCCDurSubQueue");
            Trace.trace(this, "Returning: " + this.brokerCCDurSubQueue);
            Trace.exit(this, "getBrokerCCDurSubQueue");
        }
        return this.brokerCCDurSubQueue;
    }

    public void setMulticast(int n) throws JMSException {
        this.multicast = n;
        this.cachedTopicOnlyNVs = null;
    }

    public int getMulticast() {
        return this.multicast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerCCDurSubQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBrokerCCDurSubQueue");
                Trace.trace(this, "Param: " + string);
            }
            if (string == null || string.length() > 48) {
                String string2 = string == null ? "<null>" : string;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerCCDurSubQueue", string2);
                throw jMSException;
            }
            this.brokerCCDurSubQueue = string;
            this.cachedTopicOnlyNVs = null;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setBrokerCCDurSubQueue");
            }
        }
    }

    public int getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.brokerVersion = n;
                this.cachedTopicOnlyNVs = null;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerVersion", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public String toString() {
        return this.getTopicName();
    }

    public Reference getReference() throws NamingException {
        String string = null;
        Reference reference = new Reference((class$com$ibm$mq$jms$MQTopic == null ? (class$com$ibm$mq$jms$MQTopic = MQTopic.class$("com.ibm.mq.jms.MQTopic")) : class$com$ibm$mq$jms$MQTopic).getName(), (class$com$ibm$mq$jms$MQTopicFactory == null ? (class$com$ibm$mq$jms$MQTopicFactory = MQTopic.class$("com.ibm.mq.jms.MQTopicFactory")) : class$com$ibm$mq$jms$MQTopicFactory).getName(), null);
        reference.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
        string = this.getDescription();
        if (string != null) {
            reference.add(new StringRefAddr("DESC", string));
        }
        reference.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
        reference.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
        reference.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
        reference.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
        reference.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
        reference.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
        reference.add(new StringRefAddr("FIQ", String.valueOf(this.getFailIfQuiesce())));
        string = this.getBaseTopicName();
        if (string != null) {
            reference.add(new StringRefAddr("TOP", string));
        }
        if ((string = this.getBrokerDurSubQueue()) != null) {
            reference.add(new StringRefAddr("BDSUB", string));
        }
        if ((string = this.getBrokerCCDurSubQueue()) != null) {
            reference.add(new StringRefAddr("CCDSUB", string));
        }
        reference.add(new StringRefAddr("BVER", String.valueOf(this.getBrokerVersion())));
        reference.add(new StringRefAddr("MCAST", String.valueOf(this.getMulticast())));
        string = this.getBrokerPubQueue();
        if (string != null) {
            reference.add(new StringRefAddr("BPUBQ", string));
        }
        if ((string = this.getBrokerPubQueueManager()) != null) {
            reference.add(new StringRefAddr("BQM", string));
        }
        return reference;
    }

    public void setBaseTopicName(String string) throws JMSException {
        String string2 = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBaseTopicName");
            }
            if (string != null) {
                string2 = string.trim();
            }
            if (string2 == null || string2.equals("")) {
                String string3 = string2;
                if (string3 == null) {
                    string3 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseTopicName", string3);
                throw jMSException;
            }
            this.baseTopicName = string2;
            this.cachedTopicName = null;
        }
        catch (JMSException jMSException) {
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Trace.exit(this, "setBaseTopicName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseTopicName() {
        try {
            Trace.entry(this, "getBaseTopicName");
            String string = this.baseTopicName;
            return string;
        }
        finally {
            Trace.exit(this, "getBaseTopicName");
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "equals");
        }
        if (object == null) {
            bl = false;
        } else if (object instanceof MQTopic) {
            MQTopic mQTopic = (MQTopic)object;
            bl = super.equals(object) && this.twoStringsEqual(this.baseTopicName, mQTopic.baseTopicName) && this.twoStringsEqual(this.brokerDurSubQueue, mQTopic.brokerDurSubQueue) && this.twoStringsEqual(this.brokerCCDurSubQueue, mQTopic.brokerCCDurSubQueue) && this.brokerVersion == mQTopic.brokerVersion && this.multicast == mQTopic.multicast;
        } else {
            bl = false;
        }
        if (Trace.isOn) {
            Trace.trace(this, "equals - result is " + bl);
            Trace.exit(this, "equals");
        }
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.baseTopicName != null) {
            n ^= this.baseTopicName.hashCode();
        }
        if (this.brokerDurSubQueue != null) {
            n ^= this.brokerDurSubQueue.hashCode();
        }
        if (this.brokerCCDurSubQueue != null) {
            n ^= this.brokerCCDurSubQueue.hashCode();
        }
        n ^= this.brokerVersion;
        return n ^= this.multicast << 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemporary() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isTemporary");
            }
            boolean bl = this.getBaseTopicName().length() > 0 && this.getBaseTopicName().startsWith("/u0001");
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isTemporary");
            }
        }
    }

    String getNVs() {
        if (this.cachedDNVs == null || this.cachedUNVs == null || this.cachedNVs == null || this.cachedTopicOnlyNVs == null) {
            String string = super.getDestNVs();
            String string2 = super.getUserNVs();
            if (this.cachedTopicOnlyNVs == null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!this.brokerDurSubQueue.equals("SYSTEM.JMS.D.SUBSCRIBER.QUEUE")) {
                    stringBuffer.append("&brokerDurSubQueue=").append(this.brokerDurSubQueue);
                }
                if (!this.brokerCCDurSubQueue.equals("SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE")) {
                    stringBuffer.append("&brokerCCDurSubQueue=").append(this.brokerCCDurSubQueue);
                }
                if (this.brokerVersion != this.defaultBrkVer) {
                    stringBuffer.append("&brokerVersion=" + this.brokerVersion);
                }
                if (this.multicast != -1) {
                    stringBuffer.append("&multicast=").append(this.multicast);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.deleteCharAt(0);
                }
                this.cachedTopicOnlyNVs = stringBuffer.toString();
            }
            this.cachedNVs = string2.length() == 0 ? (this.cachedTopicOnlyNVs.length() == 0 ? string : (string.length() == 0 ? this.cachedTopicOnlyNVs : string + '&' + this.cachedTopicOnlyNVs)) : (this.cachedTopicOnlyNVs.length() == 0 ? (string.length() == 0 ? string2 : string + '&' + string2) : (string.length() == 0 ? this.cachedTopicOnlyNVs + '&' + string2 : string + '&' + this.cachedTopicOnlyNVs + '&' + string2));
        }
        return this.cachedNVs;
    }

    void setFromProperties(Properties properties) throws JMSException {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "setFromProperties");
            }
            if ((string = (String)properties.remove("brokerDurSubQueue")) != null) {
                this.setBrokerDurSubQueue(string);
            }
            if ((string = (String)properties.remove("brokerCCDurSubQueue")) != null) {
                this.setBrokerCCDurSubQueue(string);
            }
            if ((string = (String)properties.remove("brokerVersion")) != null) {
                this.setBrokerVersion(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("multicast")) != null) {
                this.setMulticast(Integer.parseInt(string));
            }
            super.setFromProperties(properties);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (NumberFormatException numberFormatException) {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
            invalidDestinationException.setLinkedException((Exception)numberFormatException);
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + invalidDestinationException);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + numberFormatException);
            }
            throw invalidDestinationException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromProperties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringInternal() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "toStringInternal");
            }
            String string = this.getBaseTopicName();
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "toStringInternal");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsWildcard() {
        if (Trace.isOn) {
            Trace.entry(this, "containsWildcard");
        }
        boolean bl = false;
        try {
            String string = this.getBaseTopicName();
            bl = this.findFirstMatchManyWildcard(string) >= 0 || this.findFirstMatchOneWildcard(string) >= 0;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "containsWildcard");
            }
        }
        return bl;
    }

    private final int findFirstMatchManyWildcard(String string) {
        int n = -1;
        int n2 = string.length();
        if (string == null || n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            if (string.charAt(0) == '#') {
                return 0;
            }
            return -1;
        }
        if (string.charAt(0) == '#' && string.charAt(1) == '/') {
            return 0;
        }
        n = string.indexOf("/#/");
        if (n != -1) {
            return n + 1;
        }
        if (string.charAt(n2 - 2) == '/' && string.charAt(n2 - 1) == '#') {
            return n2 - 1;
        }
        return n;
    }

    private final int findFirstMatchOneWildcard(String string) {
        int n = -1;
        int n2 = string.length();
        if (string == null || n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            if (string.charAt(0) == '+') {
                return 0;
            }
            return -1;
        }
        if (string.charAt(0) == '+' && string.charAt(1) == '/') {
            return 0;
        }
        n = string.indexOf("/+/");
        if (n != -1) {
            return n + 1;
        }
        if (string.charAt(n2 - 2) == '/' && string.charAt(n2 - 1) == '+') {
            return n2 - 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsAnyWildcard() {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "containsAnyWildcard");
            }
            if ((string = this.getBaseTopicName()) != null) {
                if (this.brokerVersion == 0) {
                    if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (string.indexOf(43) >= 0 || string.indexOf(35) >= 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "containsAnyWildcard");
            }
        }
    }

    void setFromReference(Reference reference) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFromReference");
            }
            super.setCommonFromReference(reference);
            RefAddr refAddr = reference.get("TOP");
            if (refAddr != null) {
                this.setBaseTopicName((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("BDSUB")) != null) {
                this.setBrokerDurSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("CCDSUB")) != null) {
                this.setBrokerCCDurSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("BVER")) != null) {
                this.setBrokerVersion(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("MCAST")) != null) {
                this.setMulticast(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("BPUBQ")) != null) {
                this.setBrokerPubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("BQM")) != null) {
                this.setBrokerPubQueueManager((String)refAddr.getContent());
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromReference");
            }
        }
    }

    public String getBrokerPubQueue() {
        return this.brokerPubQueue;
    }

    public void setBrokerPubQueue(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setBrokerPubQueue");
            if (string != null) {
                Trace.trace(this, "brokerPubQueue: " + string);
            } else {
                Trace.trace(this, "argument brokerPubQueue is null");
            }
        }
        if (string != null && string.length() > 48) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerPubQueue", string);
            throw jMSException;
        }
        this.brokerPubQueue = string;
        if (Trace.isOn) {
            Trace.exit(this, "setBrokerPubQueue");
        }
    }

    public String getBrokerPubQueueManager() {
        return this.brokerPubQueueManager;
    }

    public void setBrokerPubQueueManager(String string) throws JMSException {
        if (string != null && string.length() > 48) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerPubQueueManager", string);
            throw jMSException;
        }
        this.brokerPubQueueManager = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

