/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class MQTemporaryTopic
extends MQTopic
implements TemporaryTopic {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQTemporaryTopic.java, jms, j600, j600-201-061220 1.16.1.1 05/05/25 15:47:28";
    private static final String ttPrefix = "MQ/MQJMS/TT/";
    private String connID = null;
    private boolean deleteFlag = false;
    private int useCount = 0;
    private MQConnection connection = null;

    MQTemporaryTopic(MQConnection mQConnection, int n) throws JMSException {
        super(ttPrefix + mQConnection.getConnectionID() + "/" + Integer.toString(n));
        this.connection = mQConnection;
        this.connID = mQConnection.getConnectionID();
    }

    public synchronized void delete() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "delete");
            }
            if (this.deleteFlag) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3019");
                throw jMSException;
            }
            if (this.useCount > 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3025");
                throw jMSException;
            }
            this.deleteFlag = true;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught and rethrowing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception = " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "delete");
            }
        }
    }

    String getConnID() {
        return this.connID;
    }

    boolean isDeleted() {
        return this.deleteFlag || this.connection.isClosed();
    }

    synchronized void usageUp() {
        if (Trace.isOn) {
            Trace.entry(this, "usageUp");
        }
        ++this.useCount;
        if (Trace.isOn) {
            Trace.trace(this, "useCount = " + this.useCount);
            Trace.exit(this, "usageUp");
        }
    }

    synchronized void usageDown() {
        if (Trace.isOn) {
            Trace.entry(this, "usageDown");
        }
        --this.useCount;
        if (Trace.isOn) {
            Trace.trace(this, "useCount = " + this.useCount);
            Trace.exit(this, "usageDown");
        }
    }
}

