/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.Trace;

public class MQSubEntry {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQSubEntry.java, jms, j600, j600-201-061220 1.19.1.1 05/05/25 15:59:18";
    static final String SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    static final String v1SIGNATURE = "MQJMS_PS_ADMIN_ENTRY";
    private boolean validity = false;
    private String name = null;
    private String topic = null;
    private String qName = null;
    private String selector = null;
    private boolean noLocal = false;
    private byte[] statusMgrId;
    private byte[] subscriberId;
    private boolean shared_queue = false;
    private int version = 2;
    private char subscriberState = (char)117;

    MQSubEntry(String string, String string2, String string3, String string4, boolean bl, byte[] byArray, boolean bl2) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor, from props");
        }
        this.name = string;
        this.topic = string2;
        this.qName = string3;
        this.selector = string4;
        this.noLocal = bl;
        this.statusMgrId = byArray;
        this.shared_queue = bl2;
        this.subscriberState = (char)117;
        this.validity = true;
        if (Trace.isOn) {
            Trace.exit(this, "constructor, from props");
        }
    }

    MQSubEntry(String string, String string2, String string3, byte[] byArray, boolean bl) {
        this(string, string2, string3, null, false, byArray, bl);
    }

    MQSubEntry(MQMessage mQMessage) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor, from message");
        }
        try {
            String string = mQMessage.readStringOfByteLength(SIGNATURE.length());
            if (!string.equals(SIGNATURE)) {
                if (string.equals(v1SIGNATURE)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "v1 style subscriber entry found on DurSubAdmin queue.");
                    }
                    this.version = 1;
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Non-DurSubEntry message on DurSubAdmin queue!");
                    }
                    return;
                }
            }
            int n = mQMessage.readInt();
            this.name = mQMessage.readStringOfByteLength(n);
            n = mQMessage.readInt();
            this.topic = mQMessage.readStringOfByteLength(n);
            n = mQMessage.readInt();
            this.qName = mQMessage.readStringOfByteLength(n);
            n = mQMessage.readInt();
            if (n > 0) {
                this.selector = mQMessage.readStringOfByteLength(n);
            }
            boolean bl = this.noLocal = mQMessage.readChar() == 'y';
            if (this.version == 2) {
                this.shared_queue = mQMessage.readChar() == 'y';
                this.subscriberState = mQMessage.readChar();
                this.statusMgrId = mQMessage.correlationId;
                this.subscriberId = mQMessage.messageId;
            }
            this.validity = true;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "Could not create MQSubEntry" + exception);
            }
            this.validity = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor, from message");
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setTopic(String string) {
        this.topic = string;
    }

    public String getTopic() {
        return this.topic;
    }

    void setQName(String string) {
        this.qName = string;
    }

    public String getQName() {
        return this.qName;
    }

    void setSelector(String string) {
        this.selector = string;
    }

    public String getSelector() {
        return this.selector;
    }

    void setNoLocal(boolean bl) {
        this.noLocal = bl;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    void setSubscriberId(byte[] byArray) {
        this.subscriberId = byArray;
    }

    byte[] getSubscriberId() {
        return this.subscriberId;
    }

    void setStatusMgrId(byte[] byArray) {
        this.statusMgrId = byArray;
    }

    byte[] getStatusMgrId() {
        return this.statusMgrId;
    }

    void setSharedQueue(boolean bl) {
        this.shared_queue = bl;
    }

    boolean getSharedQueue() {
        return this.shared_queue;
    }

    void setSubscriberState(char c) {
        this.subscriberState = c;
    }

    char getSubscriberState() {
        return this.subscriberState;
    }

    void setVersion(int n) {
        this.version = n;
    }

    int getVersion() {
        return this.version;
    }

    boolean isValid() {
        return this.validity;
    }

    MQMessage toMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "toMessage");
        }
        MQMessage mQMessage = new MQMessage();
        try {
            mQMessage.writeString(SIGNATURE);
            mQMessage.writeInt(this.name.length());
            mQMessage.writeString(this.name);
            mQMessage.writeInt(this.topic.length());
            mQMessage.writeString(this.topic);
            mQMessage.writeInt(this.qName.length());
            mQMessage.writeString(this.qName);
            if (this.selector == null) {
                mQMessage.writeInt(0);
            } else {
                mQMessage.writeInt(this.selector.length());
                mQMessage.writeString(this.selector);
            }
            mQMessage.writeChar(this.noLocal ? 121 : 110);
            mQMessage.writeChar(this.shared_queue ? 121 : 110);
            mQMessage.writeChar((int)this.subscriberState);
            if (this.subscriberId != null) {
                mQMessage.messageId = this.subscriberId;
            }
            if (this.statusMgrId != null) {
                mQMessage.correlationId = this.statusMgrId;
            }
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "Could not convert MQSubEntry to MQMessage: " + exception);
            }
            mQMessage = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "toMessage");
        }
        return mQMessage;
    }

    public String toString() {
        return "\nName         : " + this.name + "\nTopic        : " + this.topic + "\nQueue Name   : " + this.qName + "\nSelector     : " + this.selector + "\nnoLocal?     : " + (this.noLocal ? "Y" : "N") + "\nsubscriberId : " + Utils.bytesToHex(this.subscriberId) + "\nsharedQ?     : " + (this.shared_queue ? "Y" : "N");
    }

    public boolean equals(Object object) {
        if (Trace.isOn) {
            Trace.entry(this, "equals");
        }
        boolean bl = false;
        if (object instanceof MQSubEntry) {
            MQSubEntry mQSubEntry = (MQSubEntry)object;
            if (this.selector == null) {
                bl = this.name.equals(mQSubEntry.name) && this.topic.equals(mQSubEntry.topic) && mQSubEntry.selector == null;
            } else {
                boolean bl2 = bl = this.name.equals(mQSubEntry.name) && this.topic.equals(mQSubEntry.topic) && this.selector.equals(mQSubEntry.selector);
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, "equals() returning " + (bl ? "true" : "false"));
            Trace.exit(this, "equals");
        }
        return bl;
    }
}

