/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSessionHandle;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class MQQueueSessionHandle
extends MQSessionHandle
implements QueueSession {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueSessionHandle.java, jms, j600, j600-201-061220 1.6.1.1 05/05/25 16:00:27";
    private MQSession session;

    protected MQQueueSessionHandle(MQSession mQSession, MQXASession mQXASession) {
        super(mQSession, mQXASession);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createQueue");
            }
            if (this.closed) {
                throw this.closedException;
            }
            Queue queue = this.session.createQueue(string);
            return queue;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueue");
            }
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createSender");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueSender queueSender = this.session.createQSender(queue);
            return queueSender;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createSender");
            }
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createReceiver");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueReceiver queueReceiver = this.session.createQReceiver(queue, string);
            return queueReceiver;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createReceiver");
            }
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTemporaryQueue");
            }
            if (this.closed) {
                throw this.closedException;
            }
            TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
            return temporaryQueue;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTemporaryQueue");
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "CreateBrowser");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueBrowser queueBrowser = this.session.createBrowser(queue, string);
            return queueBrowser;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueBrowser");
            }
        }
    }
}

