/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueueBrowser;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;

public class MQQueueEnumeration
implements Enumeration {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueEnumeration.java, jms, j600, j600-201-061220 1.27.1.2 05/07/07 12:36:42";
    private MQSession session;
    private MQQueueBrowser browser;
    private MQQueue queue;
    private JMSMessage message;
    private boolean bufferFilled = false;
    private MQJMSMessage baseMessage;
    private MQGetMessageOptions gmo;
    private MQMessageSelector messageSelector;

    MQQueueEnumeration(MQSession mQSession, MQQueue mQQueue, MQMessageSelector mQMessageSelector, MQQueueBrowser mQQueueBrowser) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueEnumeration constructor");
        }
        this.session = mQSession;
        this.queue = mQQueue;
        this.messageSelector = mQMessageSelector;
        this.browser = mQQueueBrowser;
        this.gmo = new MQGetMessageOptions();
        this.gmo.options |= 0x10;
        if (mQSession.connection.getFailIfQuiesce() == 1) {
            this.gmo.options |= 0x2000;
        }
        this.baseMessage = new MQJMSMessage();
        if (Trace.isOn) {
            Trace.exit(this, "MQQueueEnumeration constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "hasMoreElements");
            }
            if (this.bufferFilled) {
                if (Trace.isOn) {
                    Trace.trace(this, "hasMoreElements found previously cached message");
                }
                bl = true;
            } else {
                block13: {
                    try {
                        this.message = null;
                        this.message = this.retrieveMessage();
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block13;
                        Trace.trace(this, "hasMoreElements caught " + (Object)((Object)jMSException));
                    }
                }
                if (this.message == null) {
                    bl = false;
                } else {
                    this.bufferFilled = true;
                    bl = true;
                    if (Trace.isOn) {
                        Trace.trace(this, "hasMoreElements put message in cache");
                    }
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "hasMoreElements");
            }
        }
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            JMSMessage jMSMessage;
            block17: {
                jMSMessage = null;
                if (Trace.isOn) {
                    Trace.entry(this, "nextElement");
                }
                if (this.bufferFilled) {
                    jMSMessage = this.message;
                    this.bufferFilled = false;
                } else {
                    try {
                        jMSMessage = this.retrieveMessage();
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "nextElement caught exception thrown by retrieveMessage()", (Throwable)jMSException);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1016", exception.toString()));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        if (!Trace.isOn) break block17;
                        Trace.exception(this, "nextElement caught unexpected exception thrown by retrieveMessage()", (Throwable)exception);
                    }
                }
            }
            if (jMSMessage == null) {
                throw new NoSuchElementException();
            }
            JMSMessage jMSMessage2 = jMSMessage;
            return jMSMessage2;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + noSuchElementException);
            }
            throw noSuchElementException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "nextElement");
            }
        }
    }

    public MQQueue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JMSMessage retrieveMessage() throws JMSException {
        JMSMessage jMSMessage;
        try {
            jMSMessage = null;
            if (Trace.isOn) {
                Trace.entry(this, "retrieveMessage");
            }
            if (this.queue == null) {
                JMSMessage jMSMessage2 = null;
                return jMSMessage2;
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        while (jMSMessage == null) {
            this.baseMessage.setMessageId(MQC.MQMI_NONE);
            this.baseMessage.setCorrelationId(MQC.MQCI_NONE);
            try {
                this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                jMSMessage = this.baseMessage.createJMSMessage(this.session);
            }
            catch (MQException mQException) {
                if (mQException.reasonCode != 2033) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1025");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    MQConnection mQConnection = this.session.connection;
                    mQConnection.deliverException(jMSException);
                    throw jMSException;
                }
                try {
                    this.queue.close();
                    this.browser.removeEnumeration(this);
                }
                catch (MQException mQException2) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS2000"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                }
                finally {
                    this.queue = null;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "retrieveMessage");
                }
                JMSMessage jMSMessage3 = null;
                if (!Trace.isOn) return jMSMessage3;
                Trace.exit(this, "retrieveMessage");
                return jMSMessage3;
            }
            catch (IOException iOException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1000");
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            if (this.messageSelector != null && !this.messageSelector.isSelected(jMSMessage, this.baseMessage)) {
                if (Trace.isOn) {
                    Trace.trace(this, "retrieveMessage() message rejected");
                }
                jMSMessage = null;
            }
            this.gmo.options &= 0xFFFFFFEF;
            this.gmo.options |= 0x20;
        }
        return jMSMessage;
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "retrieveMessage");
            }
        }
    }
}

