/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionBrowser;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueAgentThread;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQQueueAgentThread2Impl
extends MQQueueAgentThread {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueAgentThread2Impl.java, jms, j600, j600-201-061220 1.3.1.3 06/09/01 10:00:51";

    MQQueueAgentThread2Impl(MQQueueAgent mQQueueAgent, MQConnection mQConnection, String string, String string2) throws JMSException {
        super(mQQueueAgent, mQConnection, string, string2);
        this.options = 139434;
        this.mqGMO = new MQGetMessageOptions(false);
    }

    MQMessageReference browse(int n, long l) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "browse");
        }
        MQMessageReference mQMessageReference = null;
        long l2 = 0L;
        try {
            boolean bl = false;
            if (this.startSweep) {
                bl = true;
                l2 = System.currentTimeMillis();
                this.sweepStartedTime = System.currentTimeMillis();
                this.startSweep = false;
                this.sweepTimeoutStart = 0L;
            }
            if ((mQMessageReference = this.browseMsg(n, bl, (int)l)) == null) {
                this.deliverNow();
                this.startSweep = true;
            } else if (this.sweepTimeoutStart != 0L) {
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis();
                }
                if (l2 > this.sweepTimeoutStart + 30000L) {
                    this.deliverNow();
                    this.startSweep = true;
                }
            } else {
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis();
                }
                this.sweepTimeoutStart = l2;
            }
            MQMessageReference mQMessageReference2 = mQMessageReference;
            return mQMessageReference2;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "browse caught", (Throwable)mQException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1025");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "browse");
            }
        }
    }

    private MQMessageReference browseMsg(int n, boolean bl, int n2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "browseMsg");
        }
        MQMessageReference mQMessageReference = null;
        try {
            int n3;
            boolean bl2;
            if (bl) {
                this.mqGMO.options &= 0xFFFFFFDF;
                this.mqGMO.options |= 0x10;
            } else {
                this.mqGMO.options &= 0xFFFFFFEF;
                this.mqGMO.options |= 0x20;
            }
            this.mqGMO.options |= 0x1100000;
            boolean bl3 = n != 0;
            boolean bl4 = bl2 = n == 0;
            this.mqGMO.options = bl3 ? (this.mqGMO.options &= 0xFFFFFFBF) : (this.mqGMO.options |= 0x40);
            this.mqGMO.options |= 1;
            this.mqGMO.waitInterval = n2;
            MQJMSMessage mQJMSMessage = new MQJMSMessage();
            if (Trace.isOn) {
                Trace.trace(this, "About to browse message:");
                Trace.trace(this, (this.mqGMO.options & 0x40) == 0 ? "- browsing full message" : "- browsing with truncation");
                Trace.trace(this, (this.mqGMO.options & 0x20) == 0 ? "- browsing first message" : "- browsing next message");
                Trace.trace(this, (this.mqGMO.options & 1) == 0 ? "- browsing without waiting" : "- browsing with wait for " + this.mqGMO.waitInterval);
                Trace.trace(this, bl2 ? "- using batched-get" : "- using non-batched get");
            }
            if (bl2) {
                n3 = ((MQSPIQueue)this.mqQueue).spiBatchedGetNoExc((MQMsg2)mQJMSMessage, this.mqGMO, 0);
                if (n3 == 2079) {
                    n3 = 0;
                }
            } else if (bl3) {
                n3 = this.mqQueue.getMsg2NoExc((MQMsg2)mQJMSMessage, this.mqGMO);
            } else {
                n3 = this.mqQueue.getMsg2NoExc((MQMsg2)mQJMSMessage, this.mqGMO, 0);
                if (n3 == 2079) {
                    n3 = 0;
                }
            }
            if (n3 == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "MQRC_NO_MSG_AVAILABLE: returning null");
                }
                MQMessageReference mQMessageReference2 = null;
                return mQMessageReference2;
            }
            if (n3 != 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unexpected reason code " + n3);
                }
                throw new MQException(2, n3, (Object)this);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Browsed message");
            }
            mQMessageReference = new MQMessageReference(this.jmsSession);
            mQMessageReference.setVersion(2);
            mQMessageReference.setMsgToken(this.mqGMO.msgToken);
            mQMessageReference.setMQJMSMessage(mQJMSMessage, bl3 ? 2 : 0);
            this.mqGMO.options &= 0xFEEFFFFF;
            MQMessageReference mQMessageReference3 = mQMessageReference;
            return mQMessageReference3;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "browseMsg passing ", (Throwable)mQException);
            }
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "browseMsg");
            }
        }
    }

    protected void deliverMsgRef(MQConnectionBrowser mQConnectionBrowser, MQMessageReference mQMessageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "deliverMsgRef");
        }
        MQJMSMessage mQJMSMessage = null;
        if (Trace.isOn) {
            Trace.trace(this, "Browsing message with MQGMO_MARK_BROWSE_CO_OP");
        }
        this.mqGMO.options &= 0xFEFFFFDE;
        this.mqGMO.options |= 0xA00010;
        this.mqGMO.matchOptions = 32;
        System.arraycopy(mQMessageReference.getMsgToken(), 0, this.mqGMO.msgToken, 0, 16);
        mQJMSMessage = new MQJMSMessage();
        int n = this.mqQueue.getMsg2NoExc((MQMsg2)mQJMSMessage, this.mqGMO);
        this.mqGMO.options &= 0xFF5FFFFF;
        this.mqGMO.matchOptions = 0;
        if (n == 2033 || n == 2200) {
            if (Trace.isOn) {
                Trace.trace(this, "Message has been marked or removed from the queue with reason: " + n);
            }
            mQMessageReference = null;
        } else if (n != 0 && n != 2079) {
            MQException mQException = new MQException(2, n, (Object)this);
            if (Trace.isOn) {
                Trace.exception(this, "browse caught", (Throwable)mQException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1025");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
        if (mQMessageReference != null) {
            mQConnectionBrowser.deliver(mQMessageReference);
        }
    }

    boolean updateConfig() throws JMSException {
        if (this.startSweep) {
            try {
                ((MQSPIQueue)this.mqQueue).close();
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                }
                throw jMSException;
            }
            try {
                this.mqQueue = this.mqQueueManager.accessQueue(this.qName, this.options);
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                }
                throw jMSException;
            }
            return true;
        }
        return false;
    }
}

