/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.EvalCache;
import com.ibm.disthub2.impl.matching.FormattedMessage;
import com.ibm.disthub2.impl.matching.InvalidTopicSyntaxException;
import com.ibm.disthub2.impl.matching.MatchSpace;
import com.ibm.disthub2.impl.matching.MatchTarget;
import com.ibm.disthub2.impl.matching.MatchingContext;
import com.ibm.disthub2.impl.matching.MatchingException;
import com.ibm.disthub2.impl.matching.QuerySyntaxException;
import com.ibm.disthub2.impl.matching.selector.EvalContext;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionBrowser;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueAgentThread;
import com.ibm.mq.jms.MQQueueAgentThread1Impl;
import com.ibm.mq.jms.MQQueueAgentThread2Impl;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SearchResults;
import com.ibm.mq.jms.SelectorDataAccessor;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;

class MQQueueAgent {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueAgent.java, jms, j600, j600-202-070608 1.39.1.5 07/02/28 08:48:26";
    private String agentKey;
    private static Hashtable agents = new Hashtable();
    private String mqQmgrName;
    private String mqQueueName;
    static final int DOMAIN_PTP = 0;
    static final int DOMAIN_PS = 1;
    private int domainFlag;
    static final int DELIVERED = 0;
    static final int NOT_DELIVERED = 1;
    static final int MSG_SELECTOR_FAILED = 2;
    static final int NO_CONSUMER = 3;
    Vector browsers = new Vector();
    private boolean allBrowsersReceiving = true;
    private int activeCount = 0;
    private int firstConsumer = 0;
    private int firstBrowser = 0;
    private MQQueueAgentThread thread = null;
    private static final int QAT_STOPPED = 0;
    private static final int QAT_STARTED = 1;
    private static final int QAT_STOPPING = 2;
    private int threadStatus = 0;
    private Object threadLock = new Object();
    static final int defWaitTime = 5000;
    long sweepInterval = 30000L;
    private Hashtable pubSubConsumerLookup = new Hashtable();
    private boolean useCorrelId = true;
    static final String EXCLUSIVE_SUB_KEY = "XXX-Exclusive-Subscriber-Key-XXX";
    boolean retainAllMessages = false;
    private int version;
    private Hashtable pubSubBrowserLookup = new Hashtable();
    private static final int MQQUEUE_AGENT_V1 = 1;
    private static final int MQQUEUE_AGENT_V2 = 2;
    int useSelectors = 0;
    int needData = 0;
    int quantityRequired = 0;
    private MatchSpace matchSpace;
    private EvalCache cache = new EvalCache();
    static final String PTPTOPIC = new String("PtPTopic");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MQQueueAgent getQueueAgent(MQConnection mQConnection, MQDestination mQDestination, String string, boolean bl) throws JMSException {
        MQQueueAgent mQQueueAgent = null;
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "getQueueAgent");
        }
        try {
            MQSession mQSession;
            int n;
            if (mQConnection instanceof MQQueueConnection) {
                n = 0;
                mQSession = (MQSession)((MQQueueConnection)mQConnection).createQueueSession(true, 0);
            } else if (mQConnection instanceof MQTopicConnection) {
                n = 1;
                mQSession = (MQSession)((MQTopicConnection)mQConnection).createTopicSession(true, 0);
            } else {
                if (mQDestination instanceof MQQueue) {
                    n = 0;
                } else if (mQDestination instanceof MQTopic) {
                    n = 1;
                } else {
                    throw ConfigEnvironment.newException("MQJMS1088");
                }
                mQSession = (MQSession)mQConnection.createSession(true, 0);
            }
            String string2 = MQQueueAgent.resolveQmgrName(mQSession);
            String string3 = MQQueueAgent.resolveQmgrID(mQSession, string2);
            String string4 = MQQueueAgent.resolveQueue(mQSession, string);
            String string5 = string3 + "/" + string4;
            mQSession.close();
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "QueueAgent ID is " + string5);
            }
            Hashtable hashtable = agents;
            synchronized (hashtable) {
                try {
                    mQQueueAgent = (MQQueueAgent)agents.get(string5);
                    if (mQQueueAgent == null) {
                        mQQueueAgent = new MQQueueAgent(string2, string, string5, n, bl);
                        agents.put(string5, mQQueueAgent);
                    } else if (mQQueueAgent.getDomain() != n) {
                        throw ConfigEnvironment.newException("MQJMS1088");
                    }
                    MQQueueAgent mQQueueAgent2 = mQQueueAgent;
                    return mQQueueAgent2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace("MQQueueAgent", "Throwing " + (Object)((Object)jMSException));
                        }
                        throw jMSException;
                    }
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit("MQQueueAgent", "getQueueAgent");
            }
        }
    }

    private MQQueueAgent(String string, String string2, String string3, int n, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.mqQmgrName = string;
        this.mqQueueName = string2;
        this.agentKey = string3;
        this.domainFlag = n;
        this.useCorrelId = bl;
        this.version = 1;
        this.matchSpace = new MatchSpace();
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    private static String resolveQmgrName(MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "resolveQmgrName");
        }
        try {
            MQQueueManager mQQueueManager;
            if (mQSession instanceof MQQueueSession) {
                mQQueueManager = ((MQQueueSession)mQSession).getQM();
            } else if (mQSession instanceof MQTopicSession) {
                mQQueueManager = ((MQTopicSession)mQSession).getQM();
            } else if (mQSession instanceof MQSession) {
                mQQueueManager = mQSession.getQM();
            } else {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1069");
                throw jMSException;
            }
            String string = Utils.inquireString((MQManagedObject)mQQueueManager, 2015);
            if (string == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1072");
                throw jMSException;
            }
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "Fully resolved Qmgr Name is " + string);
            }
            String string2 = string;
            return string2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit("MQQueueAgent", "resolveQmgrName");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resolveQmgrID(MQSession mQSession, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "resolveQmgrID");
        }
        try {
            MQQueueManager mQQueueManager;
            if (mQSession instanceof MQQueueSession) {
                mQQueueManager = ((MQQueueSession)mQSession).getQM();
            } else if (mQSession instanceof MQTopicSession) {
                mQQueueManager = ((MQTopicSession)mQSession).getQM();
            } else if (mQSession instanceof MQSession) {
                mQQueueManager = mQSession.getQM();
            } else {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1069");
                throw jMSException;
            }
            String string2 = Utils.inquireString((MQManagedObject)mQQueueManager, 2032);
            if (string2 == null) {
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "Inquire failed - falling back to qmgr name");
                }
                string2 = string;
            }
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "Qmgr ID " + string2);
            }
            String string3 = string2;
            return string3;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "Exception caught - returning fallback of qmgr name");
            }
            String string4 = string;
            return string4;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit("MQQueueAgent", "resolveQmgrID");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String resolveQueue(MQSession var0, String var1_1) throws JMSException {
        block35: {
            if (Trace.isOn) {
                Trace.entry("MQQueueAgent", "resolveQueue");
            }
            var2_2 = null;
            if (var0 instanceof MQQueueSession) {
                var3_3 = ((MQQueueSession)var0).getQM();
            } else if (var0 instanceof MQTopicSession) {
                var3_3 = ((MQTopicSession)var0).getQM();
            } else if (var0 instanceof MQSession) {
                var3_3 = var0.getQM();
            } else {
                var4_5 = ConfigEnvironment.newException("MQJMS1069");
                throw var4_5;
            }
            try {
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "resolveQueue is opening queue");
                }
                var2_2 = var3_3.accessQueue(var1_1, 8232);
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "resolveQueue opened queue OK");
                }
            }
            catch (MQException var4_6) {
                var5_8 = ConfigEnvironment.newException("MQJMS2008", var1_1);
                var5_8.setLinkedException((Exception)var4_6);
                throw var5_8;
            }
            var4_7 = Utils.inquireInt((MQManagedObject)var2_2, 20);
            switch (var4_7) {
                case 1: {
                    var5_9 = Utils.inquireInt((MQManagedObject)var2_2, 7);
                    if (var5_9 == 1) ** GOTO lbl45
                    var6_12 = Utils.inquireString((MQManagedObject)var2_2, 2016);
                    if (var1_1.trim().equals(var6_12.trim())) break;
                    var2_2.closeOptions = 1;
                    try {
                        var2_2.close();
                        var2_2 = null;
                    }
                    catch (MQException var7_13) {
                        if (!Trace.isOn) ** GOTO lbl42
                        Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                    }
lbl42:
                    // 3 sources

                    if (Trace.isOn) {
                        Trace.trace("MQQueueAgent", "Queue is a QMODEL");
                    }
                    throw ConfigEnvironment.newException("MQJMS1073");
lbl45:
                    // 1 sources

                    if (!Trace.isOn) break;
                    Trace.trace("MQQueueAgent", "Queue is a QLOCAL");
                    break;
                }
                case 3: {
                    if (!Trace.isOn) break;
                    Trace.trace("MQQueueAgent", "Queue " + var1_1 + " is a QALIAS");
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace("MQQueueAgent", "Unexpected response when determining Queue type: " + var4_7);
                    }
                    throw ConfigEnvironment.newException("MQJMS1073");
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "resolveQueue is closing queue");
                }
                var2_2.close();
                var2_2 = null;
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "resolveQueue closed queue okay");
                }
            }
            catch (MQException var5_10) {
                var6_12 = ConfigEnvironment.newException("MQJMS2000");
                throw var6_12;
            }
            if (Trace.isOn) {
                Trace.trace("MQQueueAgent", "Fully resolved Queue name is " + var1_1);
            }
            var5_11 = var1_1;
            var9_14 = null;
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
            }
            catch (MQException var10_16) {
                if (!Trace.isOn) break block35;
                Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                Trace.exception("MQQueueAgent", "resolveQueue", (Throwable)var10_16);
            }
        }
        if (Trace.isOn) {
            Trace.exit("MQQueueAgent", "resolveQueue");
        }
        return var5_11;
        catch (JMSException var3_4) {
            try {
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "Throwing " + (Object)var3_4);
                }
                throw var3_4;
            }
            catch (Throwable var8_18) {
                block37: {
                    block36: {
                        var9_15 = null;
                        try {
                            if (var2_2 != null) {
                                var2_2.close();
                            }
                        }
                        catch (MQException var10_17) {
                            if (!Trace.isOn) break block36;
                            Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                            Trace.exception("MQQueueAgent", "resolveQueue", (Throwable)var10_17);
                        }
                    }
                    if (!Trace.isOn) break block37;
                    Trace.exit("MQQueueAgent", "resolveQueue");
                }
                throw var8_18;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(MQConnection mQConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "activate");
        }
        Object object = this.threadLock;
        synchronized (object) {
            while (this.threadStatus == 2) {
                if (Trace.isOn) {
                    Trace.trace(this, "Thread stopping...");
                }
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.activeCount;
            if (this.threadStatus == 0) {
                String string;
                if (null == mQConnection && Trace.isOn) {
                    Trace.trace(this, "connection is null!");
                }
                if (mQConnection != null && mQConnection.getSupportsQAT2()) {
                    this.version = 2;
                }
                if ((string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.mq.jms.tuning.QATVersion");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                })) != null && (string.equals("1") || string.equals("2"))) {
                    this.version = new Integer(string);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Creating MQQueueAgentThread, version " + this.version);
                }
                switch (this.version) {
                    case 1: {
                        this.thread = new MQQueueAgentThread1Impl(this, mQConnection, this.mqQmgrName, this.mqQueueName);
                        break;
                    }
                    case 2: {
                        this.thread = new MQQueueAgentThread2Impl(this, mQConnection, this.mqQmgrName, this.mqQueueName);
                        break;
                    }
                    default: {
                        throw ConfigEnvironment.newException("MQJMS1099");
                    }
                }
                this.threadStatus = 1;
                if (this.retainAllMessages) {
                    this.thread.retainAllMessages();
                }
                this.thread.go();
            } else if (this.retainAllMessages) {
                this.thread.retainAllMessages();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "deactivate");
        }
        Object object = this.threadLock;
        synchronized (object) {
            --this.activeCount;
            if (this.activeCount == 0) {
                this.thread.quit();
                this.threadStatus = 2;
                this.retainAllMessages = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deactivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sweepStarting() {
        if (Trace.isOn) {
            Trace.entry(this, "sweepStarting");
        }
        Vector vector = this.browsers;
        synchronized (vector) {
            if (!this.allBrowsersReceiving) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting all ConnectionBrowsers to receive messages");
                }
                Enumeration enumeration = this.browsers.elements();
                while (enumeration.hasMoreElements()) {
                    ((MQConnectionBrowser)enumeration.nextElement()).receiveFlag.receiving = true;
                }
                this.allBrowsersReceiving = true;
                this.thread.redeliverUnwanted();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "sweepStarting");
        }
    }

    protected boolean configChangePending() {
        return !this.allBrowsersReceiving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performConfigChange() {
        if (Trace.isOn) {
            Trace.entry(this, "performConfigChange");
        }
        Vector vector = this.browsers;
        synchronized (vector) {
            if (!this.allBrowsersReceiving) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting all ConnectionBrowsers to receive messages");
                }
                Enumeration enumeration = this.browsers.elements();
                while (enumeration.hasMoreElements()) {
                    MQConnectionBrowser mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                    if (mQConnectionBrowser.receiveFlag.receiving) continue;
                    mQConnectionBrowser.receiveFlag.receiving = true;
                    if (mQConnectionBrowser.getQuantityHint() != 0) {
                        ++this.needData;
                    }
                    if (mQConnectionBrowser.getSelectorString() != null && !mQConnectionBrowser.getSelectorString().equals("")) {
                        ++this.useSelectors;
                    }
                    if (this.needData == 0 && this.useSelectors == 0) continue;
                    this.quantityRequired = 2;
                }
                this.allBrowsersReceiving = true;
                this.thread.redeliverUnwanted();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "performConfigChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deliverPubSub(MQMessageReference mQMessageReference) {
        if (Trace.isOn) {
            Trace.entry(this, "deliverPubSub");
        }
        int n = 1;
        byte[] byArray = mQMessageReference.getCorrelId();
        Hashtable hashtable = this.pubSubBrowserLookup;
        synchronized (hashtable) {
            block15: {
                MQConnectionBrowser mQConnectionBrowser = null;
                mQConnectionBrowser = this.useCorrelId ? (MQConnectionBrowser)this.pubSubBrowserLookup.get(Utils.bytesToHex(byArray)) : (MQConnectionBrowser)this.pubSubBrowserLookup.get(EXCLUSIVE_SUB_KEY);
                if (mQConnectionBrowser != null) {
                    try {
                        if (mQConnectionBrowser.getException() != null) break block15;
                        if (Trace.isOn) {
                            Trace.trace(this, "Found a prospective pub/sub browser to deliver to");
                        }
                        if (mQConnectionBrowser.deliver(mQMessageReference)) {
                            n = 0;
                            if (Trace.isOn) {
                                Trace.trace(this, "browser.deliver returned DELIVERED");
                            }
                        } else {
                            n = 2;
                            if (Trace.isOn) {
                                Trace.trace(this, "browser.deliver returned false; result is MSG_SELECTOR_FAILED");
                            }
                        }
                        break block15;
                    }
                    catch (RuntimeException runtimeException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "ConnectionBrowser threw exception from deliver; reject it");
                            Trace.exception(this, "deliver", (Throwable)runtimeException);
                        }
                        break block15;
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "No browser matching message correlId '" + Utils.bytesToHex(byArray) + "'");
                    Trace.trace(this, "outcome is NO_CONSUMER");
                }
                n = 3;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverPubSub");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverException(JMSException jMSException) {
        MQConnection[] mQConnectionArray;
        if (Trace.isOn) {
            Trace.entry(this, "deliverException");
        }
        int n = 0;
        Vector vector = this.browsers;
        synchronized (vector) {
            mQConnectionArray = new MQConnection[this.browsers.size()];
            Enumeration enumeration = this.browsers.elements();
            while (enumeration.hasMoreElements()) {
                MQConnectionBrowser mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                MQConnection mQConnection = mQConnectionBrowser.getConnection();
                boolean bl = false;
                for (int i = 0; i < n && !bl; ++i) {
                    if (mQConnectionArray[i] != mQConnection) continue;
                    bl = true;
                }
                if (bl) continue;
                mQConnectionArray[n] = mQConnection;
                ++n;
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, n + " unique Connections using QueueAgent");
        }
        for (int i = 0; i < n; ++i) {
            mQConnectionArray[i].deliverException(jMSException);
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverException");
        }
    }

    int getDomain() {
        return this.domainFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBrowser(MQConnectionBrowser mQConnectionBrowser, boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "addBrowser");
        }
        Vector vector = this.browsers;
        synchronized (vector) {
            if (!this.browsers.contains(mQConnectionBrowser)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Adding browser to Vector");
                }
                this.browsers.addElement(mQConnectionBrowser);
                if (this.domainFlag == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "This is a Point-to-Point agent");
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "Adding Browser to MatchSpace");
                            Trace.trace(this, "Browser = \n" + mQConnectionBrowser.toString());
                        }
                        if (null != mQConnectionBrowser.getSelectorString()) {
                            this.matchSpace.put(PTPTOPIC, mQConnectionBrowser.getSelectorString(), (MatchTarget)mQConnectionBrowser, null, null);
                        }
                    }
                    catch (MatchingException matchingException) {
                        if (Trace.isOn) {
                            Trace.entry(this, "TopicSubscriberImpl");
                            Trace.trace(this, "Exception - " + (Object)((Object)matchingException) + " \n throwing JMSWrappedException.");
                            Trace.exit(this, "TopicSubscriberImpl");
                        }
                        return;
                    }
                    catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
                        if (Trace.isOn) {
                            Trace.entry(this, "TopicSubscriberImpl");
                            Trace.trace(this, "Exception - " + (Object)((Object)invalidTopicSyntaxException) + " \n throwing JMSWrappedException.");
                            Trace.exit(this, "TopicSubscriberImpl");
                        }
                        return;
                    }
                    catch (QuerySyntaxException querySyntaxException) {
                        if (Trace.isOn) {
                            Trace.entry(this, "TopicSubscriberImpl");
                            Trace.trace(this, "Exception - " + (Object)((Object)querySyntaxException) + " \n throwing InvalidSelectorException.");
                            Trace.exit(this, "TopicSubscriberImpl");
                        }
                        return;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Browser added to MatchSpace.");
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "This is a PubSub QueueAgent");
                    }
                    if (this.useCorrelId) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Browser is Pub/Sub, and uses correlIdAsIdentity, so storing its correlId in lookup table");
                            Trace.trace(this, "correlId = '" + Utils.bytesToHex(mQConnectionBrowser.getCorrelId()) + "'");
                        }
                        this.pubSubBrowserLookup.put(Utils.bytesToHex(mQConnectionBrowser.getCorrelId()), mQConnectionBrowser);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Browser is Pub/Sub, but does NOT use correlIdAsIdentity. correlId storage not required");
                        }
                        this.pubSubBrowserLookup.put(EXCLUSIVE_SUB_KEY, mQConnectionBrowser);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Adding browser with selector: " + mQConnectionBrowser.getSelectorString());
                    }
                }
                mQConnectionBrowser.receiveFlag.receiving = false;
                this.allBrowsersReceiving = false;
                if (bl) {
                    this.retainAllMessages = true;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "addBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowser(MQConnectionBrowser mQConnectionBrowser) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeBrowser");
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.threadStatus == 2) {
                this.thread.waitForEnd();
                this.threadStatus = 0;
                this.thread = null;
                this.threadLock.notifyAll();
            }
        }
        object = this.browsers;
        synchronized (object) {
            boolean bl = this.browsers.removeElement(mQConnectionBrowser);
            if (Trace.isOn) {
                Trace.trace(this, "browser " + (bl ? "removed from " : "not found in ") + " Vector.");
            }
            this.firstBrowser = 0;
            if (mQConnectionBrowser.isPubSub()) {
                if (this.useCorrelId) {
                    this.pubSubBrowserLookup.remove(Utils.bytesToHex(mQConnectionBrowser.getCorrelId()));
                } else {
                    this.pubSubBrowserLookup.remove(EXCLUSIVE_SUB_KEY);
                }
            } else {
                try {
                    this.matchSpace.remove((MatchTarget)mQConnectionBrowser);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mQConnectionBrowser.receiveFlag.receiving && bl) {
                if (mQConnectionBrowser.getQuantityHint() != 0 && this.needData > 0) {
                    --this.needData;
                }
                if (mQConnectionBrowser.getSelectorString() != null && !mQConnectionBrowser.getSelectorString().equals("") && this.useSelectors > 0) {
                    --this.useSelectors;
                }
                if (this.needData == 0 && this.useSelectors == 0) {
                    this.quantityRequired = 0;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeBrowser");
        }
    }

    void startBrowsers() {
        if (Trace.isOn) {
            Trace.entry(this, "startBrowsers");
        }
        Enumeration enumeration = this.browsers.elements();
        while (enumeration.hasMoreElements()) {
            MQConnectionBrowser mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
            if (mQConnectionBrowser.getException() != null) continue;
            mQConnectionBrowser.endDeliver();
        }
        if (Trace.isOn) {
            Trace.exit(this, "startBrowsers");
        }
    }

    void getMatches(String string, MQMessageReference mQMessageReference, SearchResults searchResults) throws MatchingException, BadMessageFormatMatchingException, JMSException {
        Message message = mQMessageReference.getMessage();
        MQJMSMessage mQJMSMessage = mQMessageReference.getMQJMSMessage();
        SelectorDataAccessor selectorDataAccessor = new SelectorDataAccessor(message, mQJMSMessage);
        MatchingContext matchingContext = new MatchingContext();
        matchingContext.setMessage((FormattedMessage)selectorDataAccessor);
        this.matchSpace.get(string, (EvalContext)matchingContext, (com.ibm.disthub2.impl.matching.SearchResults)searchResults);
    }

    void putMatchTarget(String string, String string2, MatchTarget matchTarget, MatchTarget[] matchTargetArray) throws MatchingException, InvalidTopicSyntaxException, QuerySyntaxException {
        this.matchSpace.put(string, string2, matchTarget, matchTargetArray);
    }

    void removeMatchTarget(MatchTarget matchTarget) throws MatchingException {
        this.matchSpace.remove(matchTarget);
    }

    Vector getBrowsers() {
        return this.browsers;
    }

    Hashtable getPubSubBrowserLookup() {
        return this.pubSubBrowserLookup;
    }

    boolean getUseCorrelId() {
        return this.useCorrelId;
    }

    int getRequiredDataQuantity() {
        return this.quantityRequired;
    }
}

