/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.services.Trace;

public class MQConnectionState {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQConnectionState.java, jms, j600, j600-202-070608 1.1 07/05/11 15:07:47";
    static final int STATE_UNKNOWN = -1;
    static final int STATE_STOPPED = 0;
    static final int STATE_STARTED = 1;
    static final int STATE_CLOSED = 2;
    static final int STATE_QUIESCING = 3;
    static final int STATE_STARTING = 4;
    static final int STATE_CLOSING = 5;
    private int state;

    public MQConnectionState() {
        if (Trace.isOn) {
            Trace.entry(this, "MQConnectionState constructor");
        }
        this.state = 0;
        if (Trace.isOn) {
            Trace.exit(this, "MQConnectionState constructor");
        }
    }

    public synchronized void setState(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setState");
        }
        if (this.state != n) {
            if (Trace.isOn) {
                Trace.trace(this, "Old state is " + this.toString());
            }
            this.state = n;
            if (Trace.isOn) {
                Trace.trace(this, "New state is " + this.toString());
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setState");
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public String toString() {
        String string = this.state == 4 ? "STARTING" : (this.state == 3 ? "QUIESCING" : (this.state == 5 ? "CLOSING" : (this.state == 1 ? "STARTED" : (this.state == 0 ? "STOPPED" : (this.state == 2 ? "CLOSED" : "UNKNOWN")))));
        return string;
    }
}

