/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.Cleanup;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;

class CleanupHandle {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/CleanupHandle.java, jms, j600, j600-201-061220 1.16.1.1 05/05/25 16:03:55";
    private static final String CLSNAME = "CleanupHandle";
    private static final int CLEANUP_PROPERTY_NOT_SET = -1;
    private static final int CLEANUP_PROPERTY_ERROR = -2;
    String qmgrKey;
    int cleanupLevel;
    long cleanupInterval;
    Cleanup cleanupInstance;
    static int cleanupProperty = -1;
    static String invalidCleanupValue = null;
    static Object updateLock = new Object();
    static Hashtable cleanups = new Hashtable();
    static Hashtable handles = new Hashtable();

    private CleanupHandle(String string, int n, long l) {
        if (Trace.isOn) {
            Trace.entry(this, "CleanupHandle (constructor)");
        }
        this.qmgrKey = string;
        this.cleanupLevel = n;
        this.cleanupInterval = l;
        if (Trace.isOn) {
            Trace.trace(this, "Instantiated with following parameters:");
            Trace.trace(this, "qmgrKey         = " + string);
            Trace.trace(this, "cleanupLevel    = " + this.cleanupLevel);
            Trace.trace(this, "cleanupInterval = " + this.cleanupInterval);
        }
        if (Trace.isOn) {
            Trace.exit(this, "CleanupHandle (constructor)");
        }
    }

    public static CleanupHandle createCleanupHandle(MQConnectionFactory mQConnectionFactory, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "createCleanupHandle");
        }
        try {
            if (string == null) {
                string = mQConnectionFactory.getQueueManager();
            }
            String string2 = null;
            int n = mQConnectionFactory.getTransportType();
            switch (n) {
                case 0: 
                case 3: {
                    string2 = string;
                    break;
                }
                case 1: {
                    string2 = string + ":" + mQConnectionFactory.getHostName() + ":" + mQConnectionFactory.getPort();
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            int n2 = mQConnectionFactory.getCleanupLevel();
            if (n2 == -1) {
                if (cleanupProperty == -2) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", invalidCleanupValue);
                    throw jMSException;
                }
                n2 = cleanupProperty;
            }
            CleanupHandle cleanupHandle = new CleanupHandle(string2, n2, mQConnectionFactory.getCleanupInterval());
            if (n2 != 0) {
                cleanupHandle.cleanupInstance = CleanupHandle.obtainCleanupInstance(string2, mQConnectionFactory);
                CleanupHandle.addCleanupHandle(cleanupHandle);
            }
            CleanupHandle cleanupHandle2 = cleanupHandle;
            return cleanupHandle2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "createCleanupHandle");
            }
        }
    }

    public static CleanupHandle createCleanupHandle(MQConnectionFactory mQConnectionFactory, String string, Hashtable hashtable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "createCleanupHandle");
        }
        try {
            if (string == null) {
                string = mQConnectionFactory.getQueueManager();
            }
            String string2 = null;
            int n = mQConnectionFactory.getTransportType();
            switch (n) {
                case 0: 
                case 3: {
                    string2 = string;
                    break;
                }
                case 1: {
                    string2 = string + ":" + mQConnectionFactory.getHostName() + ":" + mQConnectionFactory.getPort();
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            int n2 = mQConnectionFactory.getCleanupLevel();
            if (n2 == -1) {
                if (cleanupProperty == -2) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", invalidCleanupValue);
                    throw jMSException;
                }
                n2 = cleanupProperty;
            }
            CleanupHandle cleanupHandle = new CleanupHandle(string2, n2, mQConnectionFactory.getCleanupInterval());
            if (n2 != 0) {
                cleanupHandle.cleanupInstance = CleanupHandle.obtainCleanupInstance(string2, mQConnectionFactory, hashtable);
                CleanupHandle.addCleanupHandle(cleanupHandle);
            }
            CleanupHandle cleanupHandle2 = cleanupHandle;
            return cleanupHandle2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "createCleanupHandle");
            }
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.cleanupLevel != 0) {
            this.removeCleanupHandle(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cleanup obtainCleanupInstance(String string, MQConnectionFactory mQConnectionFactory) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "obtainCleanupInstance");
        }
        try {
            Cleanup cleanup = null;
            Object object = updateLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((cleanup = (Cleanup)cleanups.get(string)) == null) {
                    int n = string.indexOf(":");
                    cleanup = n != -1 ? new Cleanup(mQConnectionFactory, string.substring(0, n)) : new Cleanup(mQConnectionFactory, string);
                    cleanups.put(string, cleanup);
                }
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "released updateLock");
            }
            object = cleanup;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "obtainCleanupInstance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cleanup obtainCleanupInstance(String string, MQConnectionFactory mQConnectionFactory, Hashtable hashtable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "obtainCleanupInstance");
        }
        try {
            Cleanup cleanup = null;
            Object object = updateLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((cleanup = (Cleanup)cleanups.get(string)) == null) {
                    int n = string.indexOf(":");
                    cleanup = n != -1 ? new Cleanup(mQConnectionFactory, string.substring(0, n)) : new Cleanup(mQConnectionFactory, hashtable, string);
                    cleanups.put(string, cleanup);
                }
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "released updateLock");
            }
            object = cleanup;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "obtainCleanupInstance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCleanupHandle(CleanupHandle cleanupHandle) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "addCleanupHandle");
        }
        try {
            boolean bl = false;
            Object object = updateLock;
            synchronized (object) {
                int n;
                Vector[] vectorArray;
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((vectorArray = (Vector[])handles.get(cleanupHandle.qmgrKey)) == null) {
                    vectorArray = new Vector[]{new Vector(), new Vector()};
                    handles.put(cleanupHandle.qmgrKey, vectorArray);
                }
                Vector vector = vectorArray[0];
                Vector vector2 = vectorArray[1];
                int n2 = vector.size();
                for (n = 0; n < n2 && cleanupHandle.cleanupLevel < ((CleanupHandle)vector.elementAt((int)n)).cleanupLevel; ++n) {
                }
                vector.insertElementAt(cleanupHandle, n);
                n2 = vector2.size();
                for (n = 0; n < n2 && cleanupHandle.cleanupInterval > ((CleanupHandle)vector2.elementAt((int)n)).cleanupInterval; ++n) {
                }
                vector2.insertElementAt(cleanupHandle, n);
                int n3 = ((CleanupHandle)vector.elementAt((int)0)).cleanupLevel;
                long l = ((CleanupHandle)vector2.elementAt((int)0)).cleanupInterval;
                cleanupHandle.cleanupInstance.setCleanupLevel(n3);
                cleanupHandle.cleanupInstance.setCleanupInterval(l);
                int n4 = n2 + 1;
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "Now " + n4 + " users with key " + cleanupHandle.qmgrKey);
                }
                if (n4 == 1) {
                    bl = true;
                }
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "released updateLock");
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "starting Cleanup");
                }
                object = MQEnvironment.createThread((Runnable)cleanupHandle.cleanupInstance, (String)("Cleanup(" + cleanupHandle.qmgrKey + ")"), (boolean)true);
                ((Thread)object).start();
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (SecurityException securityException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Throwing " + securityException);
            }
            throw securityException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "addCleanupHandle");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCleanupHandle(CleanupHandle cleanupHandle) {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeCleanupHandle");
        }
        try {
            boolean bl = false;
            Object object = updateLock;
            synchronized (object) {
                Vector[] vectorArray;
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((vectorArray = (Vector[])handles.get(cleanupHandle.qmgrKey)) != null) {
                    Vector vector = vectorArray[0];
                    Vector vector2 = vectorArray[1];
                    vector.removeElement(cleanupHandle);
                    vector2.removeElement(cleanupHandle);
                    int n = vector.size();
                    if (n > 0) {
                        int n2 = ((CleanupHandle)vector.elementAt((int)0)).cleanupLevel;
                        long l = ((CleanupHandle)vector2.elementAt((int)0)).cleanupInterval;
                        cleanupHandle.cleanupInstance.setCleanupLevel(n2);
                        cleanupHandle.cleanupInstance.setCleanupInterval(l);
                    } else {
                        cleanups.remove(cleanupHandle.qmgrKey);
                        bl = true;
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Now " + n + " users with key " + cleanupHandle.qmgrKey);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "released updateLock");
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "stopping Cleanup");
                }
                cleanupHandle.cleanupInstance.stop();
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Ignoring exception on removeCleanupHandle:");
                Trace.exception(CLSNAME, "removeCleanupHandle", (Throwable)jMSException);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeCleanupHandle");
            }
        }
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.trace(CLSNAME, "current cleanup level: " + this.cleanupLevel);
        }
        return this.cleanupLevel;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.cleanup");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string != null) {
            if ((string = string.toUpperCase()).equals("NONE")) {
                cleanupProperty = 0;
            } else if (string.equals("SAFE")) {
                cleanupProperty = 1;
            } else if (string.equals("STRONG")) {
                cleanupProperty = 2;
            } else {
                cleanupProperty = -2;
                invalidCleanupValue = string;
            }
        }
        if (cleanupProperty == -1) {
            cleanupProperty = 1;
        }
    }
}

