/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.reader;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IReader;
import com.anfcorp.stores.integration.ITransform;
import com.anfcorp.stores.integration.ReaderException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformReader
implements IReader<Object> {
    private transient Context context;
    private IReader<Object> reader;
    private List<ITransform<Object, Object>> transforms;

    public List<ITransform<Object, Object>> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List<ITransform<Object, Object>> transforms) {
        this.transforms = transforms;
        this.resetTransforms();
    }

    private void resetTransforms() {
        if (this.transforms != null) {
            for (ITransform<Object, Object> t : this.transforms) {
                t.reset();
            }
        }
    }

    public IReader<Object> getReader() {
        return this.reader;
    }

    public void setReader(IReader<Object> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader != null && this.reader.hasNext();
        }
        catch (Throwable ex) {
            throw new ReaderException("hasNext", ex);
        }
    }

    @Override
    public Object next() {
        try {
            Object data = null;
            if (this.reader != null) {
                data = this.reader.next();
                if (this.transforms != null) {
                    for (ITransform<Object, Object> t : this.transforms) {
                        if (!t.isTransformable(data)) continue;
                        data = t.transform(this.context, data);
                    }
                }
            }
            return data;
        }
        catch (Throwable ex) {
            throw new ReaderException("next", ex);
        }
    }

    @Override
    public void remove() {
        try {
            if (this.reader != null) {
                this.reader.remove();
            }
        }
        catch (Throwable ex) {
            throw new ReaderException("remove", ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Throwable ex) {
            throw new ReaderException("close", ex);
        }
    }

    @Override
    public void open(Context context) {
        try {
            this.context = context;
            if (this.reader != null) {
                this.resetTransforms();
                this.reader.open(context);
            }
        }
        catch (Throwable ex) {
            throw new ReaderException("open", ex);
        }
    }
}

