/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.reader;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IReader;
import com.anfcorp.stores.integration.IResourceListener;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcReader
extends JdbcDaoSupport
implements IReader<Object> {
    protected RowMapper rowMapper = new ColumnMapRowMapper();
    protected String sql;
    protected Object[] params;
    protected transient Connection connection;
    protected transient PreparedStatement stmt;
    protected transient ResultSet rs;
    protected int rowNumber = 0;
    private IResourceListener resourceListener;
    private Context ctx;
    public static final String CONTEXT_DYNAMIC_PARAMS = "context_dynamicParams";
    protected List<String> messageFormatStrings;

    @Override
    public boolean hasNext() {
        try {
            return this.rs != null && this.rs.next();
        }
        catch (SQLException ex) {
            throw this.getJdbcTemplate().getExceptionTranslator().translate("hasNext", this.sql, ex);
        }
    }

    public void setResourceListener(IResourceListener l) {
        this.resourceListener = l;
    }

    @Override
    public Object next() {
        try {
            return this.rowMapper.mapRow(this.rs, this.rowNumber++);
        }
        catch (SQLException ex) {
            throw this.getJdbcTemplate().getExceptionTranslator().translate("next", this.sql, ex);
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        JdbcUtils.closeResultSet((ResultSet)this.rs);
        JdbcUtils.closeStatement((Statement)this.stmt);
        JdbcUtils.closeConnection((Connection)this.connection);
        if (this.resourceListener != null) {
            this.resourceListener.afterClose(this.ctx);
        }
        this.ctx = null;
    }

    @Override
    public void open(Context context) {
        try {
            ParameterMetaData pmd;
            this.ctx = context;
            this.connection = this.getConnection();
            this.sql = this.sql.replaceAll("'", "''");
            Object[] args = this.messageFormatStrings != null ? this.messageFormatStrings.toArray() : new Object[]{};
            this.sql = new MessageFormat(this.sql).format(args);
            this.stmt = this.connection.prepareStatement(this.sql);
            Object[] localParams = null;
            if (context != null && context.containsKey(CONTEXT_DYNAMIC_PARAMS) && context.get(CONTEXT_DYNAMIC_PARAMS) != null && context.get(CONTEXT_DYNAMIC_PARAMS) instanceof Object[]) {
                localParams = (Object[])context.get(CONTEXT_DYNAMIC_PARAMS);
            } else if (this.params != null) {
                localParams = this.params;
            }
            if (localParams != null && (pmd = this.stmt.getParameterMetaData()).getParameterCount() > 0) {
                this.stmt.clearParameters();
                for (int i = 1; i <= localParams.length && i <= pmd.getParameterCount(); ++i) {
                    try {
                        this.stmt.setObject(i, localParams[i - 1]);
                        continue;
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)("Failed to set parameter[" + (i - 1) + "]=" + localParams[i - 1]));
                        throw ex;
                    }
                }
            }
            long executeTimeInMs = System.currentTimeMillis();
            this.rs = this.stmt.executeQuery();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("It took " + (System.currentTimeMillis() - executeTimeInMs) + "ms to run: " + this.sql));
            }
            this.rowNumber = 0;
            if (this.resourceListener != null) {
                this.resourceListener.afterOpen(context);
            }
        }
        catch (SQLException ex) {
            throw this.getJdbcTemplate().getExceptionTranslator().translate("next", this.sql, ex);
        }
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setMessageFormatStrings(List<String> messageFormatStrings) {
        this.messageFormatStrings = messageFormatStrings;
    }
}

