/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.reader;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IReader;
import com.anfcorp.stores.integration.IResourceListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcNamedParameterReader
extends NamedParameterJdbcDaoSupport
implements IReader<Map<String, Object>> {
    protected List<String> messageFormatStrings;
    protected String sql;
    protected Object[] params;
    protected int rowNumber = 0;
    private Context ctx;
    private IResourceListener resourceListener;
    private List<String> parameterIndices;
    private List<Map<String, Object>> rs;
    public static final String CONTEXT_DYNAMIC_PARAMS = "context_dynamicParams";

    @Override
    public boolean hasNext() {
        return this.rs != null && this.rs.size() > this.rowNumber;
    }

    @Override
    public Map<String, Object> next() {
        Map<String, Object> ret = null;
        ret = this.rs != null && this.rs.size() > this.rowNumber ? this.rs.get(this.rowNumber++) : null;
        return ret;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        if (this.resourceListener != null) {
            this.resourceListener.afterClose(this.ctx);
        }
        this.ctx = null;
    }

    @Override
    public void open(Context context) {
        this.ctx = context;
        this.sql = this.sql.replaceAll("'", "''");
        Object[] args = this.messageFormatStrings != null ? this.messageFormatStrings.toArray() : new Object[]{};
        this.sql = new MessageFormat(this.sql).format(args);
        Object[] localParams = null;
        if (context != null && context.containsKey(CONTEXT_DYNAMIC_PARAMS) && context.get(CONTEXT_DYNAMIC_PARAMS) != null && context.get(CONTEXT_DYNAMIC_PARAMS) instanceof Object[]) {
            localParams = (Object[])context.get(CONTEXT_DYNAMIC_PARAMS);
        } else if (this.params != null) {
            localParams = this.params;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (localParams != null && this.parameterIndices != null) {
            for (int i = 0; i < this.parameterIndices.size() && i < localParams.length; ++i) {
                parameterMap.put(this.parameterIndices.get(i), localParams[i]);
            }
        }
        this.rs = this.getNamedParameterJdbcTemplate().queryForList(this.sql, parameterMap);
        this.rowNumber = 0;
        if (this.resourceListener != null) {
            this.resourceListener.afterOpen(context);
        }
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setMessageFormatStrings(List<String> messageFormatStrings) {
        this.messageFormatStrings = messageFormatStrings;
    }

    public void setResourceListener(IResourceListener l) {
        this.resourceListener = l;
    }

    public void setParameterIndices(List<String> parameterIndices) {
        this.parameterIndices = parameterIndices;
    }
}

