/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration;

import com.anfcorp.stores.integration.IErrorHandler;
import com.anfcorp.stores.integration.IntegrationService;
import com.anfcorp.stores.integration.common.events.handler.EventLogHandler;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMessageRouter
implements BeanNameAware {
    static Log logger = LogFactory.getLog(XmlMessageRouter.class);
    private Map<String, IntegrationService> xmlTagToIntegrationMapping;
    private IErrorHandler errorHandler;
    private String beanName;
    private String UNHANDLED_REASON_NO_MAPPING = "NO MAPPING";
    private String UNHANDLED_REASON_ERROR = "ERROR";

    public void route(String xml) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Routing the following xml message: " + xml));
            }
            Set<String> keys = this.xmlTagToIntegrationMapping.keySet();
            boolean routed = false;
            for (String tag : keys) {
                if (!xml.contains("<" + tag)) continue;
                EventLogHandler.logInfo(tag, xml);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Routing to an integration to handle the " + tag + " tag."));
                }
                this.xmlTagToIntegrationMapping.get(tag).online(xml);
                routed = true;
            }
            if (!routed) {
                EventLogHandler.logError(null, xml);
                logger.warn((Object)("We received a message that was not routed to a handler: " + xml));
                if (this.errorHandler != null) {
                    this.errorHandler.errorOccurred(this.beanName, this.UNHANDLED_REASON_NO_MAPPING, null, xml);
                }
            }
        }
        catch (RuntimeException e) {
            if (this.errorHandler != null) {
                this.errorHandler.errorOccurred(this.beanName, this.UNHANDLED_REASON_ERROR, e, xml);
            }
            throw e;
        }
    }

    public void setXmlTagToIntegrationMapping(Map<String, IntegrationService> xmlElementToIntegrationMap) {
        this.xmlTagToIntegrationMapping = xmlElementToIntegrationMap;
        if (this.xmlTagToIntegrationMapping != null) {
            for (String tag : this.xmlTagToIntegrationMapping.keySet()) {
                logger.info((Object)("Initializing xml message router for tag: " + tag));
            }
        }
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

