/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.ICoupling;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public class IntegrationService
implements BeanNameAware {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected ICoupling onlineCoupling;
    protected ICoupling reloadCoupling;
    protected String beanName;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void online(Object ... params) {
        this.online(new Context(), params);
    }

    public void online(Context context, Object ... params) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Running " + this.beanName + " integration."));
            }
            if (this.onlineCoupling != null) {
                context.put("couplingArgs", params);
                this.onlineCoupling.connect(context);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Done running " + this.beanName + " integration."));
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void reload(Context context, Object ... params) {
        try {
            if (this.reloadCoupling != null) {
                context.put("couplingArgs", params);
                this.reloadCoupling.connect(context);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void reload(Object ... params) {
        this.reload(new Context(), params);
    }

    public void setOnlineCoupling(ICoupling onlineCoupling) {
        this.onlineCoupling = onlineCoupling;
    }

    public void setReloadCoupling(ICoupling reloadCoupling) {
        this.reloadCoupling = reloadCoupling;
    }

    public ICoupling getOnlineCoupling() {
        return this.onlineCoupling;
    }

    public ICoupling getReloadCoupling() {
        return this.reloadCoupling;
    }
}

