/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.ICoupling;
import com.anfcorp.stores.integration.IFilter;
import com.anfcorp.stores.integration.IReader;
import com.anfcorp.stores.integration.IResource;
import com.anfcorp.stores.integration.ITransform;
import com.anfcorp.stores.integration.IWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coupling
implements ICoupling {
    protected static final Log logger = LogFactory.getLog(Coupling.class);
    private List<IReader<Object>> readers;
    private transient IReader<Object> currentReader;
    private IWriter<Object> writer;
    private List<ITransform<Object, Object>> transforms;
    private List<IFilter<Object>> filters;
    private int maxNumberOfIterations = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Context context) {
        int iterationCount;
        this.resetTransforms();
        boolean writerOpened = false;
        long transformTimeInMs = 0L;
        long writeTimeInMs = 0L;
        long readTimeInMs = 0L;
        long writerCloseInMs = 0L;
        long readerCloseInMs = 0L;
        try {
            if (this.nextReader(context)) {
                this.openResource(this.currentReader, context);
                this.openResource(this.writer, context);
                writerOpened = true;
                long readSnapshot = System.currentTimeMillis();
                for (iterationCount = 0; (this.currentReader.hasNext() || this.nextReader(context)) && (this.maxNumberOfIterations == -1 || this.maxNumberOfIterations > iterationCount); ++iterationCount) {
                    Object data = this.currentReader.next();
                    readTimeInMs += System.currentTimeMillis() - readSnapshot;
                    boolean include = true;
                    if (this.filters != null) {
                        IFilter<Object> f;
                        Iterator<IFilter<Object>> i$ = this.filters.iterator();
                        while (i$.hasNext() && (include = (f = i$.next()).include(data))) {
                        }
                    }
                    if (include) {
                        long transformSnapshot = System.currentTimeMillis();
                        if (this.transforms != null) {
                            for (ITransform<Object, Object> t : this.transforms) {
                                if (!t.isTransformable(data)) continue;
                                data = t.transform(context, data);
                            }
                        }
                        transformTimeInMs += System.currentTimeMillis() - transformSnapshot;
                        long writeSnapshot = System.currentTimeMillis();
                        this.writer.write(data);
                        writeTimeInMs += System.currentTimeMillis() - writeSnapshot;
                    }
                    readSnapshot = System.currentTimeMillis();
                }
            }
            Object var23_18 = null;
        }
        catch (Throwable throwable) {
            Object var23_19 = null;
            try {
                if (writerOpened) {
                    long ts = System.currentTimeMillis();
                    this.closeResource(this.writer);
                    writerCloseInMs = System.currentTimeMillis() - ts;
                }
                Object var27_24 = null;
            }
            catch (Throwable throwable2) {
                Object var27_25 = null;
                long ts = System.currentTimeMillis();
                this.closeResource(this.currentReader);
                readerCloseInMs = System.currentTimeMillis() - ts;
                this.currentReader = null;
                throw throwable2;
            }
            long ts = System.currentTimeMillis();
            this.closeResource(this.currentReader);
            readerCloseInMs = System.currentTimeMillis() - ts;
            this.currentReader = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("We made " + iterationCount + " iterations of the coupling."));
                logger.debug((Object)("We spent " + readTimeInMs + "ms reading data in the coupling."));
                logger.debug((Object)("We spent " + transformTimeInMs + "ms transforming data in the coupling."));
                logger.debug((Object)("We spent " + writeTimeInMs + "ms writing data in the coupling."));
                logger.debug((Object)("We spent " + writerCloseInMs + "ms closing the writer in the coupling."));
                logger.debug((Object)("We spent " + readerCloseInMs + "ms closing the reader in the coupling."));
            }
            throw throwable;
        }
        try {
            if (writerOpened) {
                long ts = System.currentTimeMillis();
                this.closeResource(this.writer);
                writerCloseInMs = System.currentTimeMillis() - ts;
            }
            Object var27_22 = null;
        }
        catch (Throwable throwable) {
            Object var27_23 = null;
            long ts = System.currentTimeMillis();
            this.closeResource(this.currentReader);
            readerCloseInMs = System.currentTimeMillis() - ts;
            this.currentReader = null;
            throw throwable;
        }
        long ts = System.currentTimeMillis();
        this.closeResource(this.currentReader);
        readerCloseInMs = System.currentTimeMillis() - ts;
        this.currentReader = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("We made " + iterationCount + " iterations of the coupling."));
            logger.debug((Object)("We spent " + readTimeInMs + "ms reading data in the coupling."));
            logger.debug((Object)("We spent " + transformTimeInMs + "ms transforming data in the coupling."));
            logger.debug((Object)("We spent " + writeTimeInMs + "ms writing data in the coupling."));
            logger.debug((Object)("We spent " + writerCloseInMs + "ms closing the writer in the coupling."));
            logger.debug((Object)("We spent " + readerCloseInMs + "ms closing the reader in the coupling."));
        }
    }

    private boolean nextReader(Context context) {
        if (this.readers != null && this.readers.size() > 0) {
            if (this.currentReader == null) {
                this.currentReader = this.readers.get(0);
                return true;
            }
            int i = this.readers.indexOf(this.currentReader);
            if (this.readers.size() > i + 1) {
                this.closeResource(this.currentReader);
                this.currentReader = this.readers.get(i + 1);
                this.openResource(this.currentReader, context);
                if (this.currentReader.hasNext()) {
                    return true;
                }
                return this.nextReader(context);
            }
        }
        return false;
    }

    private void openResource(IResource resource, Context context) {
        if (resource != null) {
            resource.open(context);
        }
    }

    private void closeResource(IResource resource) {
        if (resource != null) {
            resource.close();
        }
    }

    private void resetTransforms() {
        if (this.transforms != null) {
            for (ITransform<Object, Object> t : this.transforms) {
                t.reset();
            }
        }
    }

    public void setReader(IReader<Object> reader) {
        this.readers = new ArrayList<IReader<Object>>(1);
        this.readers.add(reader);
    }

    public void setWriter(IWriter<Object> writer) {
        this.writer = writer;
    }

    public void setTransforms(List<ITransform<Object, Object>> transforms) {
        this.transforms = transforms;
        this.resetTransforms();
    }

    public void setFilters(List<IFilter<Object>> filters) {
        this.filters = filters;
    }

    public void setReaders(List<IReader<Object>> readers) {
        this.readers = readers;
    }

    public int getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }
}

