/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.chartjs.data.Dataset;

public abstract class DoubleDataset<T>
implements Dataset<T, Double> {
    private static final long serialVersionUID = -1161268515260316334L;
    private List<Double> data;
    private List<String> labels;
    private Map<String, Double> dataMap;

    public T data(Double ... data) {
        this.data = Arrays.asList(data);
        return this.getThis();
    }

    @Override
    public T dataAsList(List<Double> data) {
        this.data = data;
        return this.getThis();
    }

    @Override
    public List<Double> getData() {
        if (this.dataMap != null) {
            return new ArrayList<Double>(this.dataMap.values());
        }
        return this.data;
    }

    public T addData(Double data) {
        if (this.data == null) {
            this.data = new ArrayList<Double>();
        }
        this.data.add(data);
        return this.getThis();
    }

    public T addData(Integer data) {
        if (data != null) {
            this.addData(data.doubleValue());
        } else {
            this.addData((Double)null);
        }
        return this.getThis();
    }

    @Override
    public T addLabeledData(String label, Double data) {
        if (label != null && data != null) {
            Double value;
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            if (!this.labels.contains(label)) {
                this.labels.add(label);
            }
            if (this.dataMap == null) {
                this.dataMap = new LinkedHashMap<String, Double>();
            }
            value = (value = this.dataMap.get(label)) == null ? data : Double.valueOf(value + data);
            this.dataMap.put(label, value);
        }
        return this.getThis();
    }

    @Override
    public List<String> getDataLabels() {
        return this.labels;
    }

    protected abstract T getThis();
}

