/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.data.DoubleDataset;
import org.vaadin.addons.chartjs.utils.ColorUtils;
import org.vaadin.addons.chartjs.utils.JUtils;

public class BarDataset
extends DoubleDataset<BarDataset> {
    private static final long serialVersionUID = -5049884704390777087L;
    private String type;
    private Boolean hidden;
    private String label;
    private String xAxisID;
    private String yAxisID;
    private List<String> backgroundColor;
    private List<String> borderColor;
    private List<Integer> borderWidth;
    private List<Edge> borderSkipped;
    private List<String> hoverBackgroundColor;
    private List<String> hoverBorderColor;
    private List<Integer> hoverBorderWidth;
    private String stack;
    private boolean randomBackgroundColors;

    public BarDataset type() {
        this.type = "bar";
        return this;
    }

    public BarDataset horizontalType() {
        this.type = "horizontalBar";
        return this;
    }

    public BarDataset label(String label) {
        this.label = label;
        return this;
    }

    public BarDataset xAxisID(String xAxisID) {
        this.xAxisID = xAxisID;
        return this;
    }

    public BarDataset yAxisID(String yAxisID) {
        this.yAxisID = yAxisID;
        return this;
    }

    public BarDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public BarDataset backgroundColor(String ... backgroundColor) {
        this.backgroundColor = Arrays.asList(backgroundColor);
        return this;
    }

    public BarDataset randomBackgroundColors(boolean randomBackgroundColors) {
        this.randomBackgroundColors = randomBackgroundColors;
        return this;
    }

    public BarDataset borderColor(String ... borderColor) {
        this.borderColor = Arrays.asList(borderColor);
        return this;
    }

    public BarDataset borderWidth(Integer ... borderWidth) {
        this.borderWidth = Arrays.asList(borderWidth);
        return this;
    }

    public BarDataset borderSkipped(Edge ... borderSkipped) {
        this.borderSkipped = Arrays.asList(borderSkipped);
        return this;
    }

    public BarDataset hoverBackgroundColor(String ... hoverBackgroundColor) {
        this.hoverBackgroundColor = Arrays.asList(hoverBackgroundColor);
        return this;
    }

    public BarDataset hoverBorderColor(String ... hoverBorderColor) {
        this.hoverBorderColor = Arrays.asList(hoverBorderColor);
        return this;
    }

    public BarDataset hoverBorderWidth(Integer ... hoverBorderWidth) {
        this.hoverBorderWidth = Arrays.asList(hoverBorderWidth);
        return this;
    }

    public BarDataset stack(String stack) {
        this.stack = stack;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        List<Double> data = this.getData();
        JUtils.putNotNullNumbers(map, "data", data);
        JUtils.putNotNull(map, "label", this.label);
        JUtils.putNotNull(map, "xAxisID", this.xAxisID);
        JUtils.putNotNull(map, "yAxisID", this.yAxisID);
        JUtils.putNotNull(map, "hidden", this.hidden);
        if (this.randomBackgroundColors && data != null) {
            ArrayList<String> bgColors = new ArrayList<String>();
            for (int i = 0; i < data.size(); ++i) {
                bgColors.add(ColorUtils.randomColor(0.7));
            }
            this.backgroundColor = bgColors;
        }
        JUtils.putNotNullStringListOrSingle(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "borderColor", this.borderColor);
        JUtils.putNotNullIntListOrSingle(map, "borderWidth", this.borderWidth);
        if (this.borderSkipped != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Edge e : this.borderSkipped) {
                list.add(e.name().toLowerCase());
            }
            JUtils.putNotNull(map, "borderSkipped", list);
        }
        JUtils.putNotNullStringListOrSingle(map, "hoverBackgroundColor", this.hoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "hoverBorderColor", this.hoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "hoverBorderWidth", this.hoverBorderWidth);
        JUtils.putNotNull(map, "stack", this.stack);
        return map;
    }

    @Override
    public BarDataset getThis() {
        return this;
    }

    public static enum Edge {
        BOTTOM,
        LEFT,
        TOP,
        RIGHT;

    }
}

