/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlUtils;

public class JdbcSqlReadCursor<T>
implements ISqlReadCursor<T> {
    protected Connection c;
    protected ResultSet rs;
    protected Statement st;
    protected boolean autoCommitFlag;
    protected ISqlRowMapper<T> mapper;
    protected JdbcSqlTemplate sqlTemplate;
    protected int rowNumber;
    protected int originalIsolationLevel;
    protected ResultSetMetaData rsMetaData = null;
    protected int rsColumnCount;
    protected IConnectionHandler connectionHandler;
    protected boolean returnLobObjects;

    public JdbcSqlReadCursor() {
    }

    public JdbcSqlReadCursor(JdbcSqlTemplate sqlTemplate, ISqlRowMapper<T> mapper, String sql, Object[] values, int[] types) {
        this(sqlTemplate, mapper, sql, values, types, null, false);
    }

    public JdbcSqlReadCursor(JdbcSqlTemplate sqlTemplate, ISqlRowMapper<T> mapper, String sql, Object[] values, int[] types, IConnectionHandler connectionHandler, boolean returnLobObjects) {
        this.sqlTemplate = sqlTemplate;
        this.mapper = mapper;
        this.connectionHandler = connectionHandler;
        this.returnLobObjects = returnLobObjects;
        try {
            block10: {
                this.c = sqlTemplate.getDataSource().getConnection();
                if (this.connectionHandler != null) {
                    this.connectionHandler.before(this.c);
                }
                this.originalIsolationLevel = this.c.getTransactionIsolation();
                this.autoCommitFlag = this.c.getAutoCommit();
                if (this.c.getTransactionIsolation() != sqlTemplate.getIsolationLevel()) {
                    this.c.setTransactionIsolation(sqlTemplate.getIsolationLevel());
                }
                if (sqlTemplate.isRequiresAutoCommitFalseToSetFetchSize()) {
                    this.c.setAutoCommit(false);
                }
                try {
                    if (values != null) {
                        PreparedStatement pstmt = this.c.prepareStatement(sql, sqlTemplate.getSettings().getResultSetType(), 1007);
                        sqlTemplate.setValues(pstmt, values, types, sqlTemplate.getLobHandler().getDefaultHandler());
                        this.st = pstmt;
                        this.st.setQueryTimeout(sqlTemplate.getSettings().getQueryTimeout());
                        this.st.setFetchSize(sqlTemplate.getSettings().getFetchSize());
                        this.rs = pstmt.executeQuery();
                    } else {
                        this.st = this.c.createStatement(sqlTemplate.getSettings().getResultSetType(), 1007);
                        this.st.setQueryTimeout(sqlTemplate.getSettings().getQueryTimeout());
                        this.st.setFetchSize(sqlTemplate.getSettings().getFetchSize());
                        this.rs = this.st.executeQuery(sql);
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().equalsIgnoreCase("query does not return results")) break block10;
                    throw e;
                }
            }
            SqlUtils.addSqlReadCursor((ISqlReadCursor)this);
        }
        catch (SQLException ex) {
            this.close();
            throw sqlTemplate.translate("Failed to execute sql: " + sql, ex);
        }
        catch (Throwable ex) {
            this.close();
            throw sqlTemplate.translate("Failed to execute sql: " + sql, ex);
        }
    }

    public T next() {
        try {
            while (this.rs != null && this.rs.next()) {
                Row row;
                Object value;
                if (this.rsMetaData == null) {
                    this.rsMetaData = this.rs.getMetaData();
                    this.rsColumnCount = this.rsMetaData.getColumnCount();
                }
                if ((value = this.mapper.mapRow(row = JdbcSqlReadCursor.getMapForRow(this.rs, this.rsMetaData, this.rsColumnCount, this.sqlTemplate.getSettings().isReadStringsAsBytes(), this.returnLobObjects))) == null) continue;
                return (T)value;
            }
            JdbcSqlTemplate.close(this.rs);
            this.rs = null;
            return null;
        }
        catch (SQLException ex) {
            throw this.sqlTemplate.translate(ex);
        }
    }

    protected static Row getMapForRow(ResultSet rs, ResultSetMetaData argResultSetMetaData, int columnCount, boolean readStringsAsBytes, boolean returnLobObjects) throws SQLException {
        Row mapOfColValues = new Row(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String key = JdbcSqlTemplate.lookupColumnName(argResultSetMetaData, i);
            Object obj = JdbcSqlTemplate.getResultSetValue(rs, argResultSetMetaData, i, readStringsAsBytes, returnLobObjects);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    public final void close() {
        if (this.connectionHandler != null) {
            this.connectionHandler.after(this.c);
        }
        JdbcSqlTemplate.close(this.rs);
        JdbcSqlTemplate.close(this.st);
        JdbcSqlTemplate.close(this.autoCommitFlag, this.originalIsolationLevel, this.c);
        SqlUtils.removeSqlReadCursor((ISqlReadCursor)this);
    }
}

