/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mysql;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;

public class MySqlJdbcSqlTemplate
extends JdbcSqlTemplate {
    public MySqlJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationCodes = new int[]{1062};
        this.uniqueKeyViolationNameRegex = new String[]{"Duplicate entry .* for key '(.*)'"};
        this.foreignKeyViolationCodes = new int[]{1452, 1216};
        this.foreignKeyChildExistsViolationCodes = new int[]{1451};
        this.deadlockCodes = new int[]{1213};
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select last_insert_id()";
    }

    @Override
    public void setValues(PreparedStatement ps, Object[] args, int[] argTypes, LobHandler lobHandler) throws SQLException {
        for (int i = 1; i <= args.length; ++i) {
            Object arg = args[i - 1];
            int argType = argTypes != null && argTypes.length >= i ? argTypes[i - 1] : Integer.MIN_VALUE;
            try {
                if (argType == 2004 && lobHandler != null && arg instanceof byte[]) {
                    lobHandler.getLobCreator().setBlobAsBytes(ps, i, (byte[])arg);
                    continue;
                }
                if (argType == 2004 && lobHandler != null && arg instanceof String) {
                    lobHandler.getLobCreator().setBlobAsBytes(ps, i, arg.toString().getBytes(Charset.defaultCharset()));
                    continue;
                }
                if (argType == 2005 && lobHandler != null) {
                    lobHandler.getLobCreator().setClobAsString(ps, i, (String)arg);
                    continue;
                }
                if ((argType == 3 || argType == 2) && arg != null) {
                    this.setDecimalValue(ps, i, arg, argType);
                    continue;
                }
                if (argType == -6) {
                    this.setTinyIntValue(ps, i, arg, argType);
                    continue;
                }
                if (argType == -5 && arg instanceof BigInteger && ((BigInteger)arg).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                    ps.setString(i, arg.toString());
                    continue;
                }
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
                continue;
            }
            catch (SQLException ex) {
                String msg = String.format("Parameter arg '%s' type: %s caused exception: %s", arg, TypeMap.getJdbcTypeName((int)argType), ex.getMessage());
                throw new SQLException(msg, ex);
            }
        }
    }
}

