/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hsqldb2;

import javax.sql.DataSource;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2DdlBuilder;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2DdlReader;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class HsqlDb2DatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String JDBC_SUBPROTOCOL = "hsqldb";

    public HsqlDb2DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected HsqlDb2DdlBuilder createDdlBuilder() {
        return new HsqlDb2DdlBuilder();
    }

    @Override
    protected HsqlDb2DdlReader createDdlReader() {
        return new HsqlDb2DdlReader((IDatabasePlatform)this);
    }

    @Override
    protected HsqlDb2JdbcSqlTemplate createSqlTemplate() {
        return new HsqlDb2JdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "hsqldb2";
    }

    public String getDefaultSchema() {
        return this.getDefaultCatalog();
    }

    public String getDefaultCatalog() {
        if (this.defaultCatalog == null) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select value from INFORMATION_SCHEMA.SYSTEM_SESSIONINFO where key='CURRENT SCHEMA'", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " FOR EACH ROW INSERT INTO " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " VALUES(NULL,NULL)";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsMultiThreadedTransactions() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }
}

