/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.db2;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.db2.Db2DdlBuilder;
import org.jumpmind.db.platform.db2.Db2DdlReader;
import org.jumpmind.db.platform.db2.Db2JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class Db2DatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String JDBC_SUBPROTOCOL = "db2";
    protected int majorVersion;
    protected int minorVersion;

    public Db2DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.majorVersion = this.sqlTemplate.getDatabaseMajorVersion();
        this.minorVersion = this.sqlTemplate.getDatabaseMinorVersion();
        if (this.majorVersion < 9 || this.majorVersion == 9 && this.minorVersion < 7) {
            this.supportsTruncate = false;
        }
    }

    protected Db2DdlBuilder createDdlBuilder() {
        return new Db2DdlBuilder();
    }

    @Override
    protected Db2DdlReader createDdlReader() {
        return new Db2DdlReader((IDatabasePlatform)this);
    }

    @Override
    protected Db2JdbcSqlTemplate createSqlTemplate() {
        return new Db2JdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public boolean allowsUniqueIndexDuplicatesWithNulls() {
        return false;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select CURRENT SCHEMA from sysibm.sysdummy1", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        return "";
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return !column.isOfBinaryType() && super.canColumnBeUsedInWhereClause(column);
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " FOR EACH ROW BEGIN ATOMIC END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public String getTruncateSql(Table table) {
        Object sql = super.getTruncateSql(table);
        sql = (String)sql + " reuse storage immediate";
        return sql;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (this.majorVersion >= 12 || this.majorVersion == 11 && this.minorVersion >= 1) {
            return sql + " limit " + limit + " offset " + offset;
        }
        int orderIndex = Strings.CI.lastIndexOf((CharSequence)sql, (CharSequence)"order by");
        String order = sql.substring(orderIndex);
        String innerSql = sql.substring(0, orderIndex - 1);
        innerSql = Strings.CI.replace(innerSql, " from", ", ROW_NUMBER() over (" + order + ") as RowNum from");
        return "select * from (" + innerSql + ") where RowNum between " + (offset + 1) + " and " + (offset + limit);
    }
}

