/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.util.ArrayList;
import java.util.List;

public class MavenArtifact {
    public static final String DEFAULT_PACKAGING = "jar";
    public static final String ZIP_PACKAGING = "zip";
    public static final String REGEX_LIST = "\\s*,\\s*";
    public static final String REGEX_COMPONENTS = "\\s*:\\s*";
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "jar";

    public MavenArtifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public MavenArtifact(String dependency, String defaultVersion) {
        if (dependency != null) {
            String[] array = dependency.trim().split(REGEX_COMPONENTS);
            if (array.length >= 1) {
                this.groupId = array[0];
            }
            if (array.length >= 2) {
                this.artifactId = array[1];
            }
            if (array.length >= 3) {
                this.version = array[2].replace("$version", defaultVersion.replaceAll("x-SNAPSHOT", "0"));
            }
            if (array.length >= 4) {
                this.packaging = array[3];
            }
        }
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toFileName() {
        return this.artifactId + "-" + this.version + "." + this.packaging;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static List<MavenArtifact> parseCsv(String dependencies, String defaultVersion) {
        ArrayList<MavenArtifact> list = new ArrayList<MavenArtifact>();
        if (dependencies != null) {
            for (String dependency : dependencies.split(REGEX_LIST)) {
                MavenArtifact artifact = new MavenArtifact(dependency, defaultVersion);
                if (artifact == null) continue;
                list.add(artifact);
            }
        }
        return list;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }
}

