/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HttpConnection
implements Closeable {
    public static final int HTTP_OK = 200;
    public static final int HTTP_NOT_MODIFIED = 304;
    protected URL url;
    protected HttpURLConnection conn;

    public HttpConnection(URL url) throws IOException {
        this.url = url;
        this.conn = (HttpURLConnection)url.openConnection();
    }

    public void disconnect() {
        this.conn.disconnect();
    }

    @Override
    public void close() {
    }

    public URL getURL() {
        return this.url;
    }

    public String getContentEncoding() {
        return this.conn.getContentEncoding();
    }

    public InputStream getInputStream() throws IOException {
        return this.conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.conn.getOutputStream();
    }

    public void setConnectTimeout(int timeout) {
        this.conn.setConnectTimeout(timeout);
    }

    public void setReadTimeout(int timeout) {
        this.conn.setReadTimeout(timeout);
    }

    public void setDoInput(boolean doinput) {
        this.conn.setDoInput(doinput);
    }

    public void setDoOutput(boolean dooutput) {
        this.conn.setDoOutput(dooutput);
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.conn.setAllowUserInteraction(allowuserinteraction);
    }

    public void setUseCaches(boolean usecaches) {
        this.conn.setUseCaches(usecaches);
    }

    public void setRequestProperty(String key, String value) {
        this.conn.setRequestProperty(key, value);
    }

    public void addRequestProperty(String key, String value) {
        this.conn.addRequestProperty(key, value);
    }

    public void setChunkedStreamingMode(int chunklen) {
        this.conn.setChunkedStreamingMode(chunklen);
    }

    public String getHeaderField(String name) {
        return this.conn.getHeaderField(name);
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.conn.getHeaderFields();
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.conn.setInstanceFollowRedirects(followRedirects);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.conn.setRequestMethod(method);
    }

    public int getResponseCode() throws IOException {
        return this.conn.getResponseCode();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (this.conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.conn).setHostnameVerifier(hostnameVerifier);
        }
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (this.conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.conn).setSSLSocketFactory(sslSocketFactory);
        }
    }

    public Certificate[] getServerCertificates() {
        if (this.conn instanceof HttpsURLConnection) {
            try {
                this.conn.connect();
                return ((HttpsURLConnection)this.conn).getServerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Certificate[0];
    }
}

