/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOfflinePullService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.file.FileIncomingTransport;

public class OfflinePullService
extends AbstractService
implements IOfflinePullService,
INodeCommunicationService.INodeCommunicationExecutor {
    private INodeService nodeService;
    private IClusterService clusterService;
    private INodeCommunicationService nodeCommunicationService;
    private IDataLoaderService dataLoaderService;
    private IConfigurationService configurationService;
    private ITransportManager transportManager;

    public OfflinePullService(IParameterService parameterService, ISymmetricDialect symmetricDialect, INodeService nodeService, IDataLoaderService dataLoaderService, IClusterService clusterService, INodeCommunicationService nodeCommunicationService, IConfigurationService configurationService, IExtensionService extensionService, ITransportManager transportManager) {
        super(parameterService, symmetricDialect);
        this.nodeService = nodeService;
        this.clusterService = clusterService;
        this.nodeCommunicationService = nodeCommunicationService;
        this.dataLoaderService = dataLoaderService;
        this.configurationService = configurationService;
        this.transportManager = transportManager;
    }

    @Override
    public synchronized RemoteNodeStatuses pullData(boolean force) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.configurationService.getChannels(false));
        Node identity = this.nodeService.findIdentity();
        if (identity != null && identity.isSyncEnabled()) {
            if (force || !this.clusterService.isInfiniteLocked("Offline Pull")) {
                List<NodeCommunication> nodes = this.nodeCommunicationService.list(NodeCommunication.CommunicationType.OFFLN_PULL);
                int availableThreads = this.nodeCommunicationService.getAvailableThreads(NodeCommunication.CommunicationType.OFFLN_PULL);
                for (NodeCommunication nodeCommunication : nodes) {
                    if (availableThreads <= 0 || !this.nodeCommunicationService.execute(nodeCommunication, statuses, this)) continue;
                    --availableThreads;
                }
            } else {
                this.log.debug("Did not run the offline pull process because it has been stopped");
            }
        }
        return statuses;
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        Node node = nodeCommunication.getNode();
        Node local = this.nodeService.findIdentity();
        try {
            long batchesProcessedCount = 0L;
            do {
                batchesProcessedCount = status.getBatchesProcessed();
                this.log.debug("Offline pull requested for {}", (Object)node);
                FileIncomingTransport transport = (FileIncomingTransport)this.transportManager.getPullTransport(node, local, null, null, null);
                this.dataLoaderService.loadDataFromOfflineTransport(node, status, transport);
                if (!status.failed() && status.getBatchesProcessed() > batchesProcessedCount) {
                    this.log.info("Offline pull data read for {}.  {} rows and {} batches were processed", new Object[]{node.toString(), status.getDataProcessed(), status.getBatchesProcessed()});
                } else if (status.failed()) {
                    this.log.info("There was a failure while reading pull data for {}.  {} rows and {} batches were processed", new Object[]{node.toString(), status.getDataProcessed(), status.getBatchesProcessed()});
                }
                transport.complete(!status.failed());
            } while (!status.failed() && status.getBatchesProcessed() > batchesProcessedCount);
        }
        catch (IOException e) {
            this.log.error("An IO exception happened while attempting to read offline pull data", (Throwable)e);
        }
    }

    public static class FileIncomingFilter
    implements FilenameFilter {
        String endFilter;

        public FileIncomingFilter(String fileExtension) {
            this.endFilter = "." + fileExtension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.endFilter);
        }
    }
}

