/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.model.Grouplet;
import org.jumpmind.symmetric.model.GroupletLink;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.model.TriggerRouterGrouplet;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.GroupletServiceSqlMap;

public class GroupletService
extends AbstractService
implements IGroupletService {
    protected ISymmetricEngine engine;
    private Date lastUpdateTime;
    private ICacheManager cacheManager;

    public GroupletService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.cacheManager = engine.getCacheManager();
        this.setSqlMap(new GroupletServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date3;
        Date date2;
        if (!this.engine.getParameterService().is("grouplet.enable")) {
            return false;
        }
        Date date1 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxGroupletLastUpdateTime"), Date.class, new Object[0]);
        Date date = this.maxDate(date1, date2 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxGroupletLinkLastUpdateTime"), Date.class, new Object[0]), date3 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxTriggerRouterGroupletLastUpdateTime"), Date.class, new Object[0]));
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer grouplet settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushGrouplets();
    }

    @Override
    public boolean isSourceEnabled(TriggerRouter triggerRouter) {
        if (!this.engine.getParameterService().is("grouplet.enable")) {
            return true;
        }
        boolean enabled = true;
        Node node = this.engine.getNodeService().findIdentity();
        if (node == null) {
            enabled = false;
        } else {
            List<Grouplet> grouplets = this.getGroupletsFor(triggerRouter, TriggerRouterGrouplet.AppliesWhen.S, false);
            if (grouplets != null && grouplets.size() > 0) {
                enabled = false;
                for (Grouplet grouplet : grouplets) {
                    Grouplet.GroupletLinkPolicy policy = grouplet.getGroupletLinkPolicy();
                    List<GroupletLink> links = grouplet.getGroupletLinks();
                    boolean foundMatch = false;
                    for (GroupletLink groupletLink : links) {
                        if (!groupletLink.getExternalId().equals(node.getExternalId())) continue;
                        foundMatch = true;
                    }
                    if ((!foundMatch || policy != Grouplet.GroupletLinkPolicy.I) && (foundMatch || policy != Grouplet.GroupletLinkPolicy.E)) continue;
                    enabled = true;
                }
            }
        }
        return enabled;
    }

    @Override
    public boolean isTargetEnabled(TriggerRouter triggerRouter, Node node) {
        if (!this.engine.getParameterService().is("grouplet.enable")) {
            return true;
        }
        HashSet<Node> nodes = new HashSet<Node>(1);
        nodes.add(node);
        return this.getTargetEnabled(triggerRouter, nodes).size() > 0;
    }

    @Override
    public Set<Node> getTargetEnabled(TriggerRouter triggerRouter, Set<Node> nodes) {
        List<Grouplet> grouplets = this.getGroupletsFor(triggerRouter, TriggerRouterGrouplet.AppliesWhen.T, false);
        if (grouplets != null && grouplets.size() > 0) {
            HashSet<Node> matchedNodes = new HashSet<Node>();
            HashSet<Node> excludedNodes = new HashSet<Node>();
            for (Grouplet grouplet : grouplets) {
                Grouplet.GroupletLinkPolicy policy = grouplet.getGroupletLinkPolicy();
                List<GroupletLink> links = grouplet.getGroupletLinks();
                for (GroupletLink groupletLink : links) {
                    for (Node node : nodes) {
                        if (!groupletLink.getExternalId().equals(node.getExternalId())) continue;
                        if (policy == Grouplet.GroupletLinkPolicy.I) {
                            matchedNodes.add(node);
                            continue;
                        }
                        excludedNodes.add(node);
                    }
                }
            }
            HashSet<Node> toReturn = new HashSet<Node>();
            excludedNodes.removeAll(matchedNodes);
            if (excludedNodes.size() > 0) {
                toReturn.addAll(nodes);
                toReturn.removeAll(excludedNodes);
            } else {
                toReturn.addAll(matchedNodes);
            }
            return toReturn;
        }
        return nodes;
    }

    @Override
    public List<Grouplet> getGrouplets(boolean refreshCache) {
        if (!this.engine.getParameterService().is("grouplet.enable")) {
            return new ArrayList<Grouplet>();
        }
        return this.cacheManager.getGrouplets(refreshCache);
    }

    @Override
    public List<Grouplet> getGroupletsFromDb() {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        final HashMap<String, Grouplet> groupletMap = new HashMap<String, Grouplet>();
        List all = sqlTemplate.query(this.getSql("selectGroupletSql"), (ISqlRowMapper)new GroupletMapper(groupletMap), new Object[0]);
        sqlTemplate.query(this.getSql("selectGroupletLinkSql"), (ISqlRowMapper)new ISqlRowMapper<GroupletLink>(){

            public GroupletLink mapRow(Row rs) {
                GroupletLink groupletLink = new GroupletLink();
                String groupletId = rs.getString("grouplet_id");
                Grouplet grouplet = (Grouplet)groupletMap.get(groupletId);
                groupletLink.setExternalId(rs.getString("external_id"));
                groupletLink.setCreateTime(rs.getDateTime("create_time"));
                groupletLink.setLastUpdateBy(rs.getString("last_update_by"));
                groupletLink.setLastUpdateTime(rs.getDateTime("last_update_time"));
                if (grouplet != null) {
                    grouplet.getGroupletLinks().add(groupletLink);
                }
                return groupletLink;
            }
        }, new Object[0]);
        sqlTemplate.query(this.getSql("selectTriggerRouterGroupletSql"), (ISqlRowMapper)new ISqlRowMapper<TriggerRouterGrouplet>(){

            public TriggerRouterGrouplet mapRow(Row rs) {
                TriggerRouterGrouplet trGrouplet = new TriggerRouterGrouplet();
                String groupletId = rs.getString("grouplet_id");
                Grouplet grouplet = (Grouplet)groupletMap.get(groupletId);
                trGrouplet.setAppliesWhen(TriggerRouterGrouplet.AppliesWhen.valueOf(rs.getString("applies_when")));
                trGrouplet.setRouterId(rs.getString("router_id"));
                trGrouplet.setTriggerId(rs.getString("trigger_id"));
                trGrouplet.setCreateTime(rs.getDateTime("create_time"));
                trGrouplet.setLastUpdateBy(rs.getString("last_update_by"));
                trGrouplet.setLastUpdateTime(rs.getDateTime("last_update_time"));
                if (grouplet != null) {
                    grouplet.getTriggerRouterGrouplets().add(trGrouplet);
                }
                return trGrouplet;
            }
        }, new Object[0]);
        return all;
    }

    protected List<Grouplet> getGroupletsFor(TriggerRouter triggerRouter, TriggerRouterGrouplet.AppliesWhen appliesWhen, boolean refreshCache) {
        List<Grouplet> all = this.getGrouplets(refreshCache);
        ArrayList<Grouplet> grouplets = new ArrayList<Grouplet>();
        for (Grouplet grouplet : all) {
            List<TriggerRouterGrouplet> trGrouplets = grouplet.getTriggerRouterGrouplets();
            for (TriggerRouterGrouplet trGrouplet : trGrouplets) {
                if (!trGrouplet.getTriggerId().equals(triggerRouter.getTrigger().getTriggerId()) || !trGrouplet.getRouterId().equals(triggerRouter.getRouter().getRouterId()) || trGrouplet.getAppliesWhen() != appliesWhen && trGrouplet.getAppliesWhen() != TriggerRouterGrouplet.AppliesWhen.B) continue;
                grouplets.add(grouplet);
            }
        }
        return grouplets;
    }

    @Override
    public void saveGrouplet(Grouplet grouplet) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        grouplet.setLastUpdateTime(new Date());
        if (sqlTemplate.update(this.getSql("updateGroupletSql"), new Object[]{grouplet.getGroupletLinkPolicy().name(), grouplet.getDescription(), grouplet.getCreateTime(), grouplet.getLastUpdateBy(), grouplet.getLastUpdateTime(), grouplet.getGroupletId()}, new int[]{12, 12, 93, 12, 93, 12}) <= 0) {
            grouplet.setCreateTime(new Date());
            sqlTemplate.update(this.getSql("insertGroupletSql"), new Object[]{grouplet.getGroupletLinkPolicy().name(), grouplet.getDescription(), grouplet.getCreateTime(), grouplet.getLastUpdateBy(), grouplet.getLastUpdateTime(), grouplet.getGroupletId()}, new int[]{12, 12, 93, 12, 93, 12});
        }
    }

    @Override
    public void saveGroupletAsCopy(Grouplet grouplet) {
        String newId = grouplet.getGroupletId();
        List grouplets = this.sqlTemplate.query(this.getSql("selectGroupletSql", "whereGroupletIdLike"), (ISqlRowMapper)new GroupletMapper(null), new Object[]{newId + "%"});
        List ids = grouplets.stream().map(Grouplet::getGroupletId).collect(Collectors.toList());
        Object suffix = "";
        int i = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i;
            ++i;
        }
        grouplet.setGroupletId(newId + (String)suffix);
        this.saveGrouplet(grouplet);
    }

    @Override
    public void renameGrouplet(Grouplet oldGrouplet, Grouplet newGrouplet) {
        this.deleteGrouplet(oldGrouplet);
        this.saveGrouplet(newGrouplet);
    }

    @Override
    public void deleteGrouplet(Grouplet grouplet) {
        List<GroupletLink> links = grouplet.getGroupletLinks();
        for (GroupletLink groupletLink : links) {
            this.deleteGroupletLink(grouplet, groupletLink);
        }
        List<TriggerRouterGrouplet> triggerRouters = grouplet.getTriggerRouterGrouplets();
        for (TriggerRouterGrouplet triggerRouterGrouplet : triggerRouters) {
            this.deleteTriggerRouterGrouplet(grouplet, triggerRouterGrouplet);
        }
        ISqlTemplate iSqlTemplate = this.platform.getSqlTemplate();
        iSqlTemplate.update(this.getSql("deleteGroupletSql"), new Object[]{grouplet.getGroupletId()}, new int[]{12});
    }

    @Override
    public void deleteAllGrouplets() {
        this.sqlTemplate.update(this.getSql("deleteAllGroupletLinksSql"), new Object[0]);
        this.sqlTemplate.update(this.getSql("deleteAllTriggerRouterGroupletsSql"), new Object[0]);
        this.sqlTemplate.update(this.getSql("deleteAllGroupletsSql"), new Object[0]);
    }

    @Override
    public void saveGroupletLink(Grouplet grouplet, GroupletLink link) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        link.setLastUpdateTime(new Date());
        if (sqlTemplate.update(this.getSql("updateGroupletLinkSql"), new Object[]{link.getCreateTime(), link.getLastUpdateBy(), link.getLastUpdateTime(), grouplet.getGroupletId(), link.getExternalId()}, new int[]{93, 12, 93, 12, 12}) <= 0) {
            link.setCreateTime(new Date());
            sqlTemplate.update(this.getSql("insertGroupletLinkSql"), new Object[]{link.getCreateTime(), link.getLastUpdateBy(), link.getLastUpdateTime(), grouplet.getGroupletId(), link.getExternalId()}, new int[]{93, 12, 93, 12, 12});
        }
    }

    @Override
    public void deleteGroupletLink(Grouplet grouplet, GroupletLink link) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        sqlTemplate.update(this.getSql("deleteGroupletLinkSql"), new Object[]{grouplet.getGroupletId(), link.getExternalId()}, new int[]{12, 12});
    }

    @Override
    public void saveTriggerRouterGrouplet(Grouplet grouplet, TriggerRouterGrouplet triggerRouterGrouplet) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        triggerRouterGrouplet.setLastUpdateTime(new Date());
        if (sqlTemplate.update(this.getSql("updateTriggerRouterGroupletSql"), new Object[]{triggerRouterGrouplet.getCreateTime(), triggerRouterGrouplet.getLastUpdateBy(), triggerRouterGrouplet.getLastUpdateTime(), grouplet.getGroupletId(), triggerRouterGrouplet.getAppliesWhen().name(), triggerRouterGrouplet.getTriggerId(), triggerRouterGrouplet.getRouterId()}, new int[]{93, 12, 93, 12, 12, 12, 12}) <= 0) {
            triggerRouterGrouplet.setCreateTime(new Date());
            sqlTemplate.update(this.getSql("insertTriggerRouterGroupletSql"), new Object[]{triggerRouterGrouplet.getCreateTime(), triggerRouterGrouplet.getLastUpdateBy(), triggerRouterGrouplet.getLastUpdateTime(), grouplet.getGroupletId(), triggerRouterGrouplet.getAppliesWhen().name(), triggerRouterGrouplet.getTriggerId(), triggerRouterGrouplet.getRouterId()}, new int[]{93, 12, 93, 12, 12, 12, 12});
        }
    }

    @Override
    public void deleteTriggerRouterGroupletsFor(TriggerRouter triggerRouter) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        sqlTemplate.update(this.getSql("deleteTriggerRouterGroupletForSql"), new Object[]{triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, new int[]{12, 12});
    }

    @Override
    public void deleteTriggerRouterGroupletsFor(Router router) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        sqlTemplate.update(this.getSql("deleteTriggerRouterGroupletsForRouterSql"), new Object[]{router.getRouterId()}, new int[]{12});
    }

    @Override
    public void deleteTriggerRouterGrouplet(Grouplet grouplet, TriggerRouterGrouplet triggerRouterGrouplet) {
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        sqlTemplate.update(this.getSql("deleteTriggerRouterGroupletSql"), new Object[]{grouplet.getGroupletId(), triggerRouterGrouplet.getAppliesWhen().name(), triggerRouterGrouplet.getTriggerId(), triggerRouterGrouplet.getRouterId()}, new int[]{12, 12, 12, 12});
    }

    static class GroupletMapper
    implements ISqlRowMapper<Grouplet> {
        Map<String, Grouplet> groupletMap;

        public GroupletMapper(Map<String, Grouplet> groupletMap) {
            this.groupletMap = groupletMap;
        }

        public Grouplet mapRow(Row rs) {
            Grouplet grouplet = new Grouplet();
            grouplet.setGroupletId(rs.getString("grouplet_id"));
            grouplet.setDescription(rs.getString("description"));
            grouplet.setGroupletLinkPolicy(Grouplet.GroupletLinkPolicy.valueOf(rs.getString("grouplet_link_policy")));
            grouplet.setCreateTime(rs.getDateTime("create_time"));
            grouplet.setLastUpdateBy(rs.getString("last_update_by"));
            grouplet.setLastUpdateTime(rs.getDateTime("last_update_time"));
            if (this.groupletMap != null) {
                this.groupletMap.put(grouplet.getGroupletId(), grouplet);
            }
            return grouplet;
        }
    }
}

