/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;

public class ConvertToReloadRouter
extends AbstractDataRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    public static final String ROUTER_ID = "convertToReload";
    private static final String ROUTERS = "c2rRouters";
    private static final String SORTED_TABLES = "c2rSortedTables";
    private static final String INSERT_DATA_SQL = "insert into sym_data (data_id, table_name, event_type, row_data, trigger_hist_id, channel_id, node_list, create_time) values (null, ?, ?, ?, ?, ?, ?, ?)";
    private static final int[] INSERT_DATA_TYPES = new int[]{12, 1, -1, 4, 12, 12, 93};
    private static final String INSERT_DATA_EVENT_SQL = "insert into sym_data_event (data_id, batch_id, create_time) values (?, ?, current_timestamp)";
    protected ISymmetricEngine engine;
    protected boolean firstTime = true;
    protected long routeMs;
    protected long sortMs;
    protected long insertTempMs;
    protected long queryNodesMs;
    protected long insertBatchMs;

    public ConvertToReloadRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        String routerId;
        RouterInfo routerInfo;
        if (initialLoad) {
            return this.toNodeIds(nodes, null);
        }
        long ts = System.currentTimeMillis();
        HashMap<String, RouterInfo> routers = (HashMap<String, RouterInfo>)context.get(ROUTERS);
        if (routers == null) {
            routers = new HashMap<String, RouterInfo>();
            context.put(ROUTERS, routers);
        }
        if ((routerInfo = (RouterInfo)routers.get(routerId = triggerRouter.getRouterId())) == null) {
            routerInfo = new RouterInfo(triggerRouter.getRouter(), nodes);
            routers.put(routerId, routerInfo);
        }
        DataEventType eventType = dataMetaData.getData().getDataEventType();
        TableInfo tableInfo = routerInfo.getTableInfo(dataMetaData, triggerRouter);
        if (eventType.equals((Object)DataEventType.INSERT) || eventType.equals((Object)DataEventType.UPDATE)) {
            tableInfo.getCompoundIdList().add(this.getPkObjects(eventType, dataMetaData));
        } else if (eventType.equals((Object)DataEventType.DELETE)) {
            return this.toNodeIds(nodes, null);
        }
        this.routeMs += System.currentTimeMillis() - ts;
        return null;
    }

    protected Object[] getPkObjects(DataEventType eventType, DataMetaData dataMetaData) {
        Object[] rowValues = null;
        if (eventType.equals((Object)DataEventType.INSERT) || eventType.equals((Object)DataEventType.UPDATE)) {
            rowValues = dataMetaData.getData().toParsedRowData();
        } else if (eventType.equals((Object)DataEventType.DELETE)) {
            rowValues = dataMetaData.getData().toParsedPkData();
        }
        Column[] pkColumns = dataMetaData.getTable().getPrimaryKeyColumns();
        String[] pkValues = (String[])ArrayUtils.subarray((Object[])rowValues, (int)0, (int)pkColumns.length);
        return this.engine.getDatabasePlatform().getObjectValues(this.engine.getSymmetricDialect().getBinaryEncoding(), pkValues, pkColumns);
    }

    @Override
    public void completeBatch(SimpleRouterContext context, OutgoingBatch batch) {
        this.log.debug("Completing batch {}", (Object)batch.getBatchId());
        if (batch.getNodeId().equals("-1")) {
            Map routers = (Map)context.get(ROUTERS);
            List<TableInfo> tableInfos = new ArrayList<TableInfo>();
            for (RouterInfo routerInfo : routers.values()) {
                tableInfos.addAll(routerInfo.getTableInfos());
            }
            tableInfos = this.sortTableInfos(context, tableInfos);
            ChannelRouterContext channelContext = (ChannelRouterContext)context;
            this.queueEvents(channelContext, channelContext.getSqlTransaction(), batch, tableInfos);
        }
    }

    @Override
    public void contextCommitted(SimpleRouterContext context) {
        if (this.routeMs + this.sortMs + this.insertTempMs + this.queryNodesMs + this.insertBatchMs > 60000L) {
            this.log.info("{} router millis are route={}, sort={}, insert.temp={}, query.nodes={}, insert.batches={}", new Object[]{ROUTER_ID, this.routeMs, this.sortMs, this.insertTempMs, this.queryNodesMs, this.insertBatchMs});
        }
        this.insertBatchMs = 0L;
        this.queryNodesMs = 0L;
        this.insertTempMs = 0L;
        this.sortMs = 0L;
        this.routeMs = 0L;
    }

    protected List<TableInfo> sortTableInfos(SimpleRouterContext context, Collection<TableInfo> tableInfos) {
        long ts = System.currentTimeMillis();
        List<Table> sortedTables = this.getAllSortedTables(context);
        HashMap<Table, TableInfo> tableInfosByTable = new HashMap<Table, TableInfo>();
        for (TableInfo tableInfo : tableInfos) {
            tableInfosByTable.put(tableInfo.getTable(), tableInfo);
        }
        ArrayList<TableInfo> sortedTableInfos = new ArrayList<TableInfo>();
        for (Table table : sortedTables) {
            TableInfo tableInfo = (TableInfo)tableInfosByTable.get(table);
            if (tableInfo == null) continue;
            sortedTableInfos.add(tableInfo);
        }
        this.sortMs += System.currentTimeMillis() - ts;
        return sortedTableInfos;
    }

    protected List<Table> getAllSortedTables(SimpleRouterContext context) {
        List sortedTables = (List)context.get(SORTED_TABLES);
        if (sortedTables == null) {
            List<TriggerHistory> histories = null;
            if (this.firstTime) {
                histories = this.engine.getTriggerRouterService().getActiveTriggerHistories();
                this.firstTime = false;
            } else {
                histories = this.engine.getTriggerRouterService().getActiveTriggerHistoriesFromCache();
            }
            ArrayList<Table> allTables = new ArrayList<Table>(histories.size());
            for (TriggerHistory history : histories) {
                Table table = this.engine.getDatabasePlatform().getTableFromCache(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), false);
                if (table == null) continue;
                allTables.add(table);
            }
            sortedTables = Database.sortByForeignKeys(allTables);
        }
        return sortedTables;
    }

    protected void queueEvents(ChannelRouterContext context, ISqlTransaction transaction, OutgoingBatch origBatch, List<TableInfo> tableInfos) {
        long loadId = this.engine.getSequenceService().nextVal(transaction, "outgoing_batch_load_id");
        int typeForId = this.engine.getSymmetricDialect().getSqlTypeForIds();
        boolean isPostgres = this.engine.getDatabasePlatform().getName().equals("postgres");
        long ts = System.currentTimeMillis();
        transaction.flush();
        for (TableInfo tableInfo : tableInfos) {
            RouterInfo routerInfo = tableInfo.getRouterInfo();
            String placeHolders = StringUtils.repeat((String)"?", (String)", ", (int)(tableInfo.getPkColumnNames().length + 1));
            String tempSql = "insert into " + routerInfo.getTempTableName() + "(" + tableInfo.getPkColumnNamesAsString() + ",  load_id) values (" + placeHolders + ")";
            if (isPostgres) {
                tempSql = tempSql + " on conflict do nothing";
            }
            transaction.prepare(tempSql);
            int[] types = ArrayUtils.addAll((int[])tableInfo.getPkColumnTypes(), (int[])new int[]{typeForId, typeForId});
            for (Object compoundId : tableInfo.getCompoundIdList()) {
                Object[] values = ArrayUtils.add((Object[])((Object[])compoundId), (Object)loadId);
                try {
                    transaction.addRow(null, values, types);
                }
                catch (UniqueKeyException uniqueKeyException) {}
            }
        }
        this.insertTempMs += System.currentTimeMillis() - ts;
        HashMap<String, OutgoingBatch> batchByNode = new HashMap<String, OutgoingBatch>();
        for (TableInfo tableInfo : tableInfos) {
            RouterInfo routerInfo = tableInfo.getRouterInfo();
            String reloadSql = this.getTempTableSql(routerInfo, tableInfo, loadId);
            List nodes = null;
            if (StringUtils.isNotBlank((CharSequence)routerInfo.getNodeQuery())) {
                ts = System.currentTimeMillis();
                transaction.flush();
                nodes = transaction.query(routerInfo.getNodeQuery(), (ISqlRowMapper)new StringMapper(), new Object[]{loadId}, new int[]{typeForId});
                this.queryNodesMs += System.currentTimeMillis() - ts;
            }
            if (nodes == null || nodes.size() == 0) {
                nodes = routerInfo.getNodeIds();
            }
            ts = System.currentTimeMillis();
            long dataId = this.insertData(transaction, tableInfo, DataEventType.RELOAD.getCode(), reloadSql);
            String tableName = tableInfo.getTableName().toLowerCase();
            for (String nodeId : nodes) {
                OutgoingBatch batch = (OutgoingBatch)batchByNode.get(nodeId);
                if (batch == null) {
                    batch = this.newBatch(transaction, nodeId, loadId, tableInfo, origBatch.getSummary());
                    batchByNode.put(nodeId, batch);
                }
                batch.incrementTableCount(tableName);
                this.insertDataEvent(transaction, batch.getBatchId(), dataId);
                context.getDataIds().add(dataId);
            }
            this.insertBatchMs += System.currentTimeMillis() - ts;
        }
        origBatch.setLoadId(loadId);
        transaction.flush();
    }

    protected String getTempTableSql(RouterInfo routerInfo, TableInfo tableInfo, long loadId) {
        Object sql = "1=1";
        if (!StringUtils.isBlank((CharSequence)tableInfo.getInitialLoadSql())) {
            sql = tableInfo.getInitialLoadSql();
        }
        sql = tableInfo.getPkColumnNames().length == 1 ? (String)sql + " and " + tableInfo.getPkColumnName() + " in (select " + tableInfo.getPkColumnName() + " from " + routerInfo.getTempTableName() + " where load_id = " + loadId + ")" : (String)sql + " and exists (select 1 from " + routerInfo.getTempTableName() + " r where " + tableInfo.getPkColumnJoinSql() + " and r.load_id = " + loadId + ")";
        return sql;
    }

    protected OutgoingBatch newBatch(ISqlTransaction transaction, String nodeId, long loadId, TableInfo tableInfo, String summary) {
        OutgoingBatch batch = new OutgoingBatch("-1", tableInfo.getChannelId(), AbstractBatch.Status.NE);
        batch.setCreateBy(ROUTER_ID);
        batch.incrementRowCount(DataEventType.RELOAD);
        batch.setNodeId(nodeId);
        batch.setLoadId(loadId);
        batch.setSummary(summary);
        this.engine.getOutgoingBatchService().insertOutgoingBatch(transaction, batch);
        return batch;
    }

    protected long insertData(ISqlTransaction transaction, TableInfo tableInfo, String eventType, String sql) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long dataId = transaction.insertWithGeneratedKey(INSERT_DATA_SQL, this.engine.getSymmetricDialect().getSequenceKeyName(SequenceIdentifier.DATA), this.engine.getSymmetricDialect().getSequenceName(SequenceIdentifier.DATA), new Object[]{tableInfo.getTableName(), eventType, sql, tableInfo.getTriggerHistory().getTriggerHistoryId(), tableInfo.getChannelId(), null, now}, INSERT_DATA_TYPES);
        return dataId;
    }

    protected void insertDataEvent(ISqlTransaction transaction, long batchId, long dataId) {
        transaction.prepareAndExecute(INSERT_DATA_EVENT_SQL, new Object[]{dataId, batchId}, new int[]{2, 2});
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    class RouterInfo {
        private Router router;
        private List<String> nodeIds = new ArrayList<String>();
        private Map<Integer, TableInfo> tableInfos = new HashMap<Integer, TableInfo>();
        private String tempTableName;
        private String nodeQuery;

        public RouterInfo(Router router, Set<Node> nodes) {
            this.router = router;
            for (Node node : nodes) {
                this.nodeIds.add(node.getNodeId());
            }
            String expression = router.getRouterExpression();
            Pattern pattern = Pattern.compile(".*\\s*temptable=(\\S*)\\s*.*", 2);
            if (expression != null) {
                Matcher matcher = pattern.matcher(expression = expression.replaceAll("\n", " ").replaceAll("\r", " "));
                if (matcher.matches()) {
                    this.tempTableName = matcher.group(1);
                }
                if ((matcher = (pattern = Pattern.compile(".*\\s*nodequery=\"(.*)\"", 2)).matcher(expression)).matches()) {
                    this.nodeQuery = matcher.group(1);
                }
            }
            if (StringUtils.isBlank((CharSequence)this.tempTableName)) {
                throw new NotImplementedException("Missing temptable={name} for router expression.");
            }
        }

        public Router getRouter() {
            return this.router;
        }

        public List<String> getNodeIds() {
            return this.nodeIds;
        }

        public TableInfo getTableInfo(DataMetaData dataMetaData, TriggerRouter triggerRouter) {
            TableInfo tableInfo = this.tableInfos.get(dataMetaData.getTriggerHistory().getTriggerHistoryId());
            if (tableInfo == null) {
                tableInfo = this.newTableInfo(dataMetaData, triggerRouter);
                this.tableInfos.put(dataMetaData.getTriggerHistory().getTriggerHistoryId(), tableInfo);
            }
            return tableInfo;
        }

        public Collection<TableInfo> getTableInfos() {
            return this.tableInfos.values();
        }

        protected TableInfo newTableInfo(DataMetaData dataMetaData, TriggerRouter triggerRouter) {
            return new TableInfo(this, dataMetaData, triggerRouter);
        }

        public String getTempTableName() {
            return this.tempTableName;
        }

        public String getNodeQuery() {
            return this.nodeQuery;
        }
    }

    class TableInfo {
        protected RouterInfo routerInfo;
        protected Table table;
        protected String tableName;
        protected String channelId;
        protected String pkColumnName;
        protected String sourceCatalog;
        protected String sourceSchema;
        protected String targetCatalog;
        protected String targetSchema;
        protected String initialLoadSql;
        protected TriggerHistory triggerHistory;
        protected String[] pkColumnNames;
        protected String pkColumnNamesAsString;
        protected String pkColumnJoinSql;
        protected int[] pkColumnTypes;
        protected List<Object> compoundIdList = new ArrayList<Object>();

        public TableInfo(RouterInfo routerInfo, DataMetaData dataMetaData, TriggerRouter triggerRouter) {
            this.routerInfo = routerInfo;
            this.channelId = triggerRouter.getTrigger().getChannelId();
            this.sourceCatalog = triggerRouter.getTrigger().getSourceCatalogName();
            this.sourceSchema = triggerRouter.getTrigger().getSourceSchemaName();
            this.table = dataMetaData.getTable();
            this.tableName = this.table.getName();
            this.pkColumnName = this.table.getPrimaryKeyColumnNames()[0];
            this.initialLoadSql = triggerRouter.getInitialLoadSelect();
            this.triggerHistory = dataMetaData.getTriggerHistory();
            Router router = triggerRouter.getRouter();
            if (router.isUseSourceCatalogSchema()) {
                this.targetCatalog = this.table.getCatalog();
                this.targetSchema = this.table.getSchema();
            } else {
                if (StringUtils.isNotBlank((CharSequence)router.getTargetCatalogName())) {
                    this.targetCatalog = router.getTargetCatalogName();
                }
                if (StringUtils.isNotBlank((CharSequence)router.getTargetSchemaName())) {
                    this.targetSchema = router.getTargetSchemaName();
                }
            }
            this.pkColumnNames = this.table.getPrimaryKeyColumnNames();
            this.pkColumnTypes = new int[this.table.getPrimaryKeyColumns().length];
            StringBuilder sbNames = new StringBuilder();
            StringBuilder sbJoin = new StringBuilder();
            int i = 0;
            for (Column column : this.table.getPrimaryKeyColumns()) {
                if (i > 0) {
                    sbNames.append(", ");
                    sbJoin.append(" and ");
                }
                this.pkColumnTypes[i++] = column.getJdbcTypeCode();
                sbNames.append(column.getName());
                sbJoin.append("r.").append(column.getName()).append(" = t.").append(column.getName());
            }
            this.pkColumnNamesAsString = sbNames.toString();
            this.pkColumnJoinSql = sbJoin.toString();
        }

        public RouterInfo getRouterInfo() {
            return this.routerInfo;
        }

        public Table getTable() {
            return this.table;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public String getSourceCatalog() {
            return this.sourceCatalog;
        }

        public String getSourceSchema() {
            return this.sourceSchema;
        }

        public String getTargetCatalog() {
            return this.targetCatalog;
        }

        public String getTargetSchema() {
            return this.targetSchema;
        }

        public String getInitialLoadSql() {
            return this.initialLoadSql;
        }

        public TriggerHistory getTriggerHistory() {
            return this.triggerHistory;
        }

        public String[] getPkColumnNames() {
            return this.pkColumnNames;
        }

        public List<Object> getCompoundIdList() {
            return this.compoundIdList;
        }

        public String getPkColumnNamesAsString() {
            return this.pkColumnNamesAsString;
        }

        public String getPkColumnJoinSql() {
            return this.pkColumnJoinSql;
        }

        public int[] getPkColumnTypes() {
            return this.pkColumnTypes;
        }
    }
}

