/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.route.AbstractFileParsingRouter;
import org.jumpmind.symmetric.route.IDataRouter;

public class CSVRouter
extends AbstractFileParsingRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    private ISymmetricEngine engine;
    private String columns;

    public CSVRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    @Override
    public List<String> parse(File file, int lineNumber, int tableIndex) {
        ArrayList<String> rows = new ArrayList<String>();
        int currentLine = 1;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (currentLine == 1) {
                    this.columns = line;
                } else if (currentLine > lineNumber) {
                    rows.add(line);
                }
                ++currentLine;
            }
            reader.close();
        }
        catch (IOException e) {
            this.log.error("Unable to parse CSV file " + file.getName() + " line number " + currentLine, (Throwable)e);
        }
        return rows;
    }

    @Override
    public String getColumnNames() {
        return this.columns;
    }
}

