/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IParameterService;

public class AuditTableDataRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint {
    private static final String COLUMN_AUDIT_EVENT = "AUDIT_EVENT";
    private static final String COLUMN_AUDIT_TIME = "AUDIT_TIME";
    private static final String COLUMN_AUDIT_ID = "AUDIT_ID";
    private ISymmetricEngine engine;
    private Map<String, Table> auditTables = new HashMap<String, Table>();

    public AuditTableDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        if (initialLoad) {
            return null;
        }
        DataEventType eventType = dataMetaData.getData().getDataEventType();
        if (eventType == DataEventType.INSERT || eventType == DataEventType.UPDATE || eventType == DataEventType.DELETE) {
            IParameterService parameterService = this.engine.getParameterService();
            IDatabasePlatform platform = this.engine.getDatabasePlatform();
            TriggerHistory triggerHistory = dataMetaData.getTriggerHistory();
            Table table = dataMetaData.getTable().copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, false);
            String tableName = table.getFullyQualifiedTableName();
            Table auditTable = this.auditTables.get(tableName);
            if (auditTable == null) {
                auditTable = this.toAuditTable(table);
                if (parameterService.is("auto.config.database")) {
                    platform.alterTables(true, new Table[]{auditTable});
                }
                auditTable = platform.getTableFromCache(auditTable.getCatalog(), auditTable.getSchema(), auditTable.getName(), false);
                this.auditTables.put(tableName, auditTable);
            }
            DatabaseInfo dbInfo = platform.getDatabaseInfo();
            String auditTableName = auditTable.getQualifiedTableName(dbInfo.getDelimiterToken(), dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator());
            ISqlTemplate template = platform.getSqlTemplate();
            HashMap<String, Object> values = null;
            values = eventType != DataEventType.DELETE ? new HashMap<String, Object>(this.getNewDataAsObject(null, dataMetaData, this.engine.getSymmetricDialect(), false)) : new HashMap<String, Object>(this.getOldDataAsObject(null, dataMetaData, this.engine.getSymmetricDialect(), false));
            Long sequence = (Long)context.get(auditTableName);
            sequence = sequence == null ? Long.valueOf(1L + template.queryForLong(String.format("select max(%s) from %s", auditTable.getColumnWithName(COLUMN_AUDIT_ID).getName(), auditTableName), new Object[0])) : Long.valueOf(1L + sequence);
            context.put(auditTable.getName(), sequence);
            values.put(auditTable.getColumnWithName(COLUMN_AUDIT_ID).getName(), sequence);
            values.put(auditTable.getColumnWithName(COLUMN_AUDIT_TIME).getName(), new Date());
            values.put(auditTable.getColumnWithName(COLUMN_AUDIT_EVENT).getName(), eventType.getCode());
            DmlStatement statement = platform.createDmlStatement(DmlStatement.DmlType.INSERT, auditTable, null);
            int[] types = statement.getTypes();
            Object[] args = statement.getValueArray(values);
            String sql = statement.getSql();
            template.update(sql, args, types);
        }
        return null;
    }

    protected Table toAuditTable(Table table) {
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        Table auditTable = table.copy();
        auditTable.setName(String.format("%s_%s", auditTable.getName(), platform.alterCaseToMatchDatabaseDefaultCase("AUDIT")));
        Column[] columns = auditTable.getColumns();
        auditTable.removeAllColumns();
        auditTable.addColumn(new Column(COLUMN_AUDIT_ID, true, -5, 0, 0));
        auditTable.addColumn(new Column(COLUMN_AUDIT_TIME, false, 93, 0, 0));
        auditTable.addColumn(new Column(COLUMN_AUDIT_EVENT, false, 1, 1, 0));
        for (Column column : columns) {
            column.setRequired(false);
            column.setPrimaryKey(false);
            column.setAutoIncrement(false);
            auditTable.addColumn(column);
        }
        auditTable.removeAllForeignKeys();
        auditTable.removeAllIndices();
        platform.alterCaseToMatchDatabaseDefaultCase(auditTable);
        return auditTable;
    }
}

