/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.TableReloadRequestKey;

public class TableReloadRequest {
    protected String targetNodeId;
    protected String sourceNodeId;
    protected String triggerId;
    protected String routerId;
    protected boolean createTable;
    protected boolean deleteFirst;
    protected String reloadSelect;
    protected String beforeCustomSql;
    protected Date reloadTime;
    protected String channelId;
    protected Date createTime = new Date();
    protected Date lastUpdateTime = new Date();
    protected String lastUpdateBy;
    protected long loadId;
    protected boolean processed;

    public TableReloadRequest(TableReloadRequestKey key) {
        this.targetNodeId = key.getTargetNodeId();
        this.sourceNodeId = key.getSourceNodeId();
        this.triggerId = key.getTriggerId();
        this.routerId = key.getRouterId();
        this.createTime = key.getCreateTime();
    }

    public TableReloadRequest() {
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    public String getReloadSelect() {
        return this.reloadSelect;
    }

    public void setReloadSelect(String reloadSelect) {
        this.reloadSelect = reloadSelect;
    }

    public String getBeforeCustomSql() {
        return this.beforeCustomSql;
    }

    public void setBeforeCustomSql(String beforeCustomSql) {
        this.beforeCustomSql = beforeCustomSql;
    }

    public Date getReloadTime() {
        return this.reloadTime;
    }

    public void setReloadTime(Date reloadTime) {
        this.reloadTime = reloadTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isDeleteFirst() {
        return this.deleteFirst;
    }

    public void setDeleteFirst(boolean deleteFirst) {
        this.deleteFirst = deleteFirst;
    }

    public boolean isFullLoadRequest() {
        return "ALL".equals(this.getTriggerId()) && "ALL".equals(this.getRouterId()) && this.getChannelId() == null;
    }

    public boolean isChannelRequest() {
        return this.getChannelId() != null;
    }

    public String getIdentifier() {
        return this.getTriggerId() + this.getRouterId();
    }

    public long getLoadId() {
        return this.loadId;
    }

    public void setLoadId(long loadId) {
        this.loadId = loadId;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public TableReloadRequestKey getTableReloadRequestKey() {
        return new TableReloadRequestKey(this.targetNodeId, this.sourceNodeId, this.triggerId, this.routerId, this.createTime);
    }

    public boolean hasSetupBatches() {
        return this.isCreateTable() || this.isDeleteFirst() || !StringUtils.isBlank((CharSequence)this.getBeforeCustomSql());
    }
}

