/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements Serializable,
Comparable<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    private int MAX_VERSION_SIZE = 50;
    private String nodeId;
    private String nodeGroupId;
    private String externalId;
    private String syncUrl;
    private String schemaVersion;
    private String configVersion;
    private String databaseType;
    private String databaseName;
    private String symmetricVersion = Version.version();
    private String databaseVersion;
    private boolean syncEnabled = true;
    private String createdAtNodeId;
    private int batchToSendCount;
    private int batchInErrorCount;
    private String deploymentType;
    private String deploymentSubType;
    private int[] symmetricVersionParts;
    private Date lastSuccessfulSyncDate;
    private String mostRecentActiveTableSynced;
    private int dataRowsToSendCount;
    private int dataRowsLoadedCount;
    private Date oldestLoadTime;
    private long purgeOutgoingLastMs;
    private Date purgeOutgoingLastRun;
    private long purgeOutgoingAverageMs;
    private long routingAverageMs;
    private Date routingLastRun;
    private long routingLastMs;
    private long symDataSize;

    public Node() {
    }

    public Node(String nodeId, String nodeGroupId) {
        this.nodeId = nodeId;
        this.externalId = nodeId;
        this.nodeGroupId = nodeGroupId;
    }

    public Node(Properties properties) {
        this.setNodeGroupId(properties.getProperty("group.id"));
        this.setExternalId(properties.getProperty("external.id"));
        this.setSyncUrl(properties.getProperty("sync.url"));
        this.setSchemaVersion(properties.getProperty("schema.version"));
        this.deploymentSubType = SymmetricUtils.getDeploymentSubType(properties);
    }

    public Node(IParameterService parameterService, ISymmetricDialect symmetricDialect, String databaseName) {
        this.setNodeGroupId(parameterService.getNodeGroupId());
        this.setExternalId(parameterService.getExternalId());
        this.setDatabaseType(symmetricDialect.getName());
        this.setDatabaseVersion(symmetricDialect.getVersion());
        this.setDatabaseName(databaseName);
        this.setSyncUrl(parameterService.getSyncUrl());
        this.setSchemaVersion(parameterService.getString("schema.version"));
        this.setConfigVersion(Version.version());
    }

    public Node(String nodeId, String syncURL, String version) {
        this.nodeId = nodeId;
        this.syncUrl = syncURL;
        this.schemaVersion = version;
    }

    public boolean equals(Object n) {
        return n != null && n instanceof Node && this.nodeId != null && this.nodeId.equals(((Node)n).getNodeId());
    }

    public int hashCode() {
        return this.nodeId != null ? this.nodeId.hashCode() : super.hashCode();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void setSyncUrl(String syncURL) {
        this.syncUrl = syncURL;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String version) {
        this.schemaVersion = StringUtils.abbreviate((String)version, (int)this.MAX_VERSION_SIZE);
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(String configVersion) {
        this.configVersion = configVersion;
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String domainId) {
        this.externalId = domainId;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String domainName) {
        this.nodeGroupId = domainName;
    }

    public String getSymmetricVersion() {
        return this.symmetricVersion;
    }

    public int[] getSymmetricVersionParts() {
        if (this.symmetricVersionParts == null) {
            this.symmetricVersionParts = (int[])(StringUtils.isEmpty((CharSequence)this.symmetricVersion) || this.symmetricVersion.equals("development") ? null : Version.parseVersion(this.symmetricVersion));
        }
        return this.symmetricVersionParts;
    }

    public void setSymmetricVersion(String symmetricVersion) {
        this.symmetricVersion = symmetricVersion;
        this.symmetricVersionParts = null;
    }

    public String toString() {
        return this.nodeGroupId + ":" + this.externalId + ":" + (this.nodeId == null ? "?" : this.nodeId);
    }

    public String getCreatedAtNodeId() {
        return this.createdAtNodeId;
    }

    public void setCreatedAtNodeId(String createdByNodeId) {
        this.createdAtNodeId = createdByNodeId;
    }

    public void setBatchInErrorCount(int batchesInErrorCount) {
        this.batchInErrorCount = batchesInErrorCount;
    }

    public int getBatchInErrorCount() {
        return this.batchInErrorCount;
    }

    public void setBatchToSendCount(int batchesToSendCount) {
        this.batchToSendCount = batchesToSendCount;
    }

    public int getBatchToSendCount() {
        return this.batchToSendCount;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public String getDeploymentSubType() {
        return this.deploymentSubType;
    }

    public void setDeploymentSubType(String deploymentSubType) {
        this.deploymentSubType = deploymentSubType;
    }

    public Date getLastSuccessfulSyncDate() {
        return this.lastSuccessfulSyncDate;
    }

    public void setLastSuccessfulSyncDate(Date lastSuccessfulSyncDate) {
        this.lastSuccessfulSyncDate = lastSuccessfulSyncDate;
    }

    public int getDataRowsToSendCount() {
        return this.dataRowsToSendCount;
    }

    public void setDataRowsToSendCount(int dataRowsToSendCount) {
        this.dataRowsToSendCount = dataRowsToSendCount;
    }

    public int getDataRowsLoadedCount() {
        return this.dataRowsLoadedCount;
    }

    public void setDataRowsLoadedCount(int dataRowsLoadedCount) {
        this.dataRowsLoadedCount = dataRowsLoadedCount;
    }

    public Date getOldestLoadTime() {
        return this.oldestLoadTime;
    }

    public void setOldestLoadTime(Date oldestLoadTime) {
        this.oldestLoadTime = oldestLoadTime;
    }

    public long getPurgeOutgoingLastMs() {
        return this.purgeOutgoingLastMs;
    }

    public void setPurgeOutgoingLastMs(long purgeOutgoingLastMs) {
        this.purgeOutgoingLastMs = purgeOutgoingLastMs;
    }

    public Date getPurgeOutgoingLastRun() {
        return this.purgeOutgoingLastRun;
    }

    public void setPurgeOutgoingLastRun(Date purgeOutgoingLastRun) {
        this.purgeOutgoingLastRun = purgeOutgoingLastRun;
    }

    public long getRoutingAverageMs() {
        return this.routingAverageMs;
    }

    public void setRoutingAverageMs(long routingAverageMs) {
        this.routingAverageMs = routingAverageMs;
    }

    public Date getRoutingLastRun() {
        return this.routingLastRun;
    }

    public void setRoutingLastRun(Date routingLastRun) {
        this.routingLastRun = routingLastRun;
    }

    public long getSymDataSize() {
        return this.symDataSize;
    }

    public void setSymDataSize(long symDataSize) {
        this.symDataSize = symDataSize;
    }

    public long getPurgeOutgoingAverageMs() {
        return this.purgeOutgoingAverageMs;
    }

    public void setPurgeOutgoingAverageMs(long purgeOutgoingAverageMs) {
        this.purgeOutgoingAverageMs = purgeOutgoingAverageMs;
    }

    public long getRoutingLastMs() {
        return this.routingLastMs;
    }

    public void setRoutingLastMs(long routingLastMs) {
        this.routingLastMs = routingLastMs;
    }

    public boolean requires13Compatiblity() {
        if (this.symmetricVersion != null) {
            if (this.symmetricVersion.equals("development")) {
                return false;
            }
            try {
                int[] currentVersion = this.getSymmetricVersionParts();
                return currentVersion != null && currentVersion.length > 0 && currentVersion[0] <= 1;
            }
            catch (Exception ex) {
                log.warn("Could not parse the version {} for node {}.  Setting backwards compatibility mode to true", (Object)this.symmetricVersion, (Object)this.nodeId);
                return true;
            }
        }
        return false;
    }

    public boolean allowCaptureTimeInProtocol() {
        return this.isVersionGreaterThanOrEqualTo(3, 12);
    }

    public boolean isVersionGreaterThanOrEqualTo(int ... targetVersion) {
        if (this.symmetricVersion != null) {
            if (this.symmetricVersion.equals("development")) {
                return true;
            }
            int[] currentVersion = this.getSymmetricVersionParts();
            if (currentVersion == null) {
                return false;
            }
            for (int i = 0; i < currentVersion.length; ++i) {
                int j = currentVersion[i];
                if (targetVersion.length <= i) continue;
                if (j > targetVersion[i]) {
                    return true;
                }
                if (j >= targetVersion[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Node other) {
        String otherNodeId = other.getNodeId();
        if (this.nodeId != null && otherNodeId != null) {
            if (StringUtils.isNumeric((CharSequence)otherNodeId) && StringUtils.isNumeric((CharSequence)this.nodeId)) {
                return new BigDecimal(this.nodeId).compareTo(new BigDecimal(otherNodeId));
            }
            return this.nodeId.compareTo(otherNodeId);
        }
        return 0;
    }

    public String getMostRecentActiveTableSynced() {
        return this.mostRecentActiveTableSynced == null ? "" : this.mostRecentActiveTableSynced;
    }

    public void setMostRecentActiveTableSynced(String mostRecentActiveTableSynced) {
        this.mostRecentActiveTableSynced = mostRecentActiveTableSynced;
    }
}

