/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.DataEventType;

public class AbstractBatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long batchId = -1L;
    private String nodeId;
    private String channelId;
    private boolean errorFlag;
    private long routerMillis;
    private long networkMillis;
    private long filterMillis;
    private long loadMillis;
    private long extractMillis;
    private long transformExtractMillis;
    private long transformLoadMillis;
    private long byteCount;
    private long ignoreCount;
    private String sqlState;
    private int sqlCode;
    private String sqlMessage;
    private String lastUpdatedHostName;
    private Date lastUpdatedTime;
    private Date createTime;
    private String createBy;
    private String summary;
    private Status status;
    private boolean loadFlag;
    private long extractCount;
    private long sentCount;
    private long loadCount;
    private long reloadRowCount;
    private long otherRowCount;
    private long dataRowCount;
    private long dataInsertRowCount;
    private long dataUpdateRowCount;
    private long dataDeleteRowCount;
    private long oldDataRowCount = 0L;
    private long oldByteCount = 0L;
    private long oldFilterMillis = 0L;
    private long oldExtractMillis = 0L;
    private long oldLoadMillis = 0L;
    private long oldNetworkMillis = 0L;
    private long loadId = -1L;
    private boolean commonFlag;
    private boolean bulkLoaderFlag;
    private long fallbackInsertCount;
    private long fallbackUpdateCount;
    private long conflictWinCount;
    private long conflictLoseCount;
    private long ignoreRowCount;
    private long missingDeleteCount;
    private long skipCount;
    private long loadRowCount;
    private long loadInsertRowCount;
    private long loadUpdateRowCount;
    private long loadDeleteRowCount;
    private long extractRowCount;
    private long extractInsertRowCount;
    private long extractUpdateRowCount;
    private long extractDeleteRowCount;
    private long failedDataId;
    private long failedLineNumber;
    private transient Map<String, Integer> tableCounts = new LinkedHashMap<String, Integer>();
    private transient Map<String, Integer> fileCounts = new LinkedHashMap<String, Integer>();
    private transient long processedRowCount;
    private Map<String, Map<String, Long>> tableLoadedCount;
    private Map<String, Map<String, Long>> tableExtractedCount;

    public void resetStats() {
        this.oldExtractMillis = this.extractMillis;
        this.oldDataRowCount = this.dataRowCount;
        this.oldByteCount = this.getByteCount();
        this.oldNetworkMillis = this.getNetworkMillis();
        this.oldFilterMillis = this.getFilterMillis();
        this.oldLoadMillis = this.getLoadMillis();
        this.extractMillis = 0L;
        this.dataRowCount = 0L;
        this.setByteCount(0L);
        this.setNetworkMillis(0L);
        this.setFilterMillis(0L);
        this.setLoadMillis(0L);
    }

    public void resetRouterStats() {
        this.dataRowCount = 0L;
        this.dataInsertRowCount = 0L;
        this.dataUpdateRowCount = 0L;
        this.dataDeleteRowCount = 0L;
        this.otherRowCount = 0L;
        this.reloadRowCount = 0L;
        this.tableCounts.clear();
        this.fileCounts.clear();
    }

    public void revertStatsOnError() {
        if (this.oldDataRowCount > 0L) {
            this.extractMillis = this.oldExtractMillis;
            this.dataRowCount = this.oldDataRowCount;
            this.setByteCount(this.oldByteCount);
            this.setNetworkMillis(this.oldNetworkMillis);
            this.setFilterMillis(this.oldFilterMillis);
            this.setLoadMillis(this.oldLoadMillis);
        }
    }

    public void resetExtractRowStats() {
        this.extractRowCount = 0L;
        this.extractInsertRowCount = 0L;
        this.extractUpdateRowCount = 0L;
        this.extractDeleteRowCount = 0L;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getNodeBatchId() {
        return this.nodeId + "-" + this.batchId;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public long getRouterMillis() {
        return this.routerMillis;
    }

    public void setRouterMillis(long routerMillis) {
        this.routerMillis = routerMillis;
    }

    public long getNetworkMillis() {
        return this.networkMillis;
    }

    public void setNetworkMillis(long networkMillis) {
        this.networkMillis = networkMillis;
    }

    public long getFilterMillis() {
        return this.filterMillis;
    }

    public void setFilterMillis(long filterMillis) {
        this.filterMillis = filterMillis;
    }

    public long getLoadMillis() {
        return this.loadMillis;
    }

    public void setLoadMillis(long loadMillis) {
        this.loadMillis = loadMillis;
    }

    public void setExtractMillis(long extractMillis) {
        this.extractMillis = extractMillis;
    }

    public long getExtractMillis() {
        return this.extractMillis;
    }

    public long getTransformExtractMillis() {
        return this.transformExtractMillis;
    }

    public void setTransformExtractMillis(long transformExtractMillis) {
        this.transformExtractMillis = transformExtractMillis;
    }

    public long getTransformLoadMillis() {
        return this.transformLoadMillis;
    }

    public void setTransformLoadMillis(long transformLoadMillis) {
        this.transformLoadMillis = transformLoadMillis;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public String getStagedLocation() {
        return Batch.getStagedLocation((boolean)false, (String)this.nodeId, (long)this.batchId);
    }

    public void incrementByteCount(int size) {
        this.byteCount += (long)size;
    }

    public void setIgnoreCount(long ignoreCount) {
        this.ignoreCount = ignoreCount;
    }

    public void incrementIgnoreCount() {
        ++this.ignoreCount;
    }

    public long getIgnoreCount() {
        return this.ignoreCount;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public int getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(int sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getSqlMessage() {
        return this.sqlMessage;
    }

    public void setSqlMessage(String sqlMessage) {
        this.sqlMessage = sqlMessage;
    }

    public void setSqlMessage(Throwable t) {
        this.sqlMessage = t.getMessage();
        if (this.sqlMessage == null) {
            this.sqlMessage = t.getClass().getName();
        }
    }

    public String getLastUpdatedHostName() {
        return this.lastUpdatedHostName;
    }

    public void setLastUpdatedHostName(String lastUpdatedHostName) {
        this.lastUpdatedHostName = lastUpdatedHostName;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Map<String, Integer> getTableCounts() {
        return new LinkedHashMap<String, Integer>(this.tableCounts);
    }

    public Map<String, Integer> getFileCounts() {
        return new LinkedHashMap<String, Integer>(this.fileCounts);
    }

    public String getSummary() {
        if ((this.summary == null || this.summary.length() == 0) && this.tableCounts != null) {
            this.summary = this.buildBatchSummary();
        }
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    protected String buildBatchSummary() {
        int SIZE = 254;
        StringBuilder buff = new StringBuilder(254);
        if (this.tableCounts.isEmpty()) {
            for (Map.Entry<String, Integer> fileCount : this.fileCounts.entrySet()) {
                buff.append(fileCount.getKey()).append(", ");
            }
            if (buff.length() > 2) {
                buff.setLength(buff.length() - 2);
            }
        } else {
            for (Map.Entry<String, Integer> tableCount : this.tableCounts.entrySet()) {
                buff.append(tableCount.getKey()).append(", ");
            }
            if (buff.length() > 2) {
                buff.setLength(buff.length() - 2);
            }
        }
        return StringUtils.abbreviate((String)buff.toString(), (int)254);
    }

    public void incrementTableCount(String tableName) {
        Integer count = this.tableCounts.get(tableName);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.tableCounts.put(tableName, count);
        this.summary = null;
    }

    public void incrementFileCount(String fileName) {
        Integer count = this.fileCounts.get(fileName);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.fileCounts.put(fileName, count);
        this.summary = null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatusFromString(String status) {
        try {
            this.status = Status.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            this.status = Status.XX;
        }
    }

    public void setLoadFlag(boolean loadFlag) {
        this.loadFlag = loadFlag;
    }

    public boolean isLoadFlag() {
        return this.loadFlag;
    }

    public void setExtractCount(long extractCount) {
        this.extractCount = extractCount;
    }

    public long getExtractCount() {
        return this.extractCount;
    }

    public void setSentCount(long sentCount) {
        this.sentCount = sentCount;
    }

    public long getSentCount() {
        return this.sentCount;
    }

    public void setLoadCount(long loadCount) {
        this.loadCount = loadCount;
    }

    public long getLoadCount() {
        return this.loadCount;
    }

    public void setReloadRowCount(long reloadRowCount) {
        this.reloadRowCount = reloadRowCount;
    }

    public long getReloadRowCount() {
        return this.reloadRowCount;
    }

    public void setOtherRowCount(long otherRowCount) {
        this.otherRowCount = otherRowCount;
    }

    public long getOtherRowCount() {
        return this.otherRowCount;
    }

    public void setDataUpdateRowCount(long dataUpdateRowCount) {
        this.dataUpdateRowCount = dataUpdateRowCount;
    }

    public long getDataUpdateRowCount() {
        return this.dataUpdateRowCount;
    }

    public void setDataDeleteRowCount(long dataDeleteRowCount) {
        this.dataDeleteRowCount = dataDeleteRowCount;
    }

    public long getDataDeleteRowCount() {
        return this.dataDeleteRowCount;
    }

    public void incrementRowCount(DataEventType type) {
        switch (type) {
            case RELOAD: {
                ++this.reloadRowCount;
                break;
            }
            case INSERT: {
                ++this.dataInsertRowCount;
                break;
            }
            case UPDATE: {
                ++this.dataUpdateRowCount;
                break;
            }
            case DELETE: {
                ++this.dataDeleteRowCount;
                break;
            }
            default: {
                ++this.otherRowCount;
            }
        }
    }

    public void incrementExtractRowCount(DataEventType type) {
        switch (type) {
            case INSERT: {
                ++this.extractInsertRowCount;
                break;
            }
            case UPDATE: {
                ++this.extractUpdateRowCount;
                break;
            }
            case DELETE: {
                ++this.extractDeleteRowCount;
                break;
            }
        }
    }

    public void incrementExtractRowCount() {
        ++this.extractRowCount;
    }

    public void setDataInsertRowCount(long dataInsertRowCount) {
        this.dataInsertRowCount = dataInsertRowCount;
    }

    public long getDataInsertRowCount() {
        return this.dataInsertRowCount;
    }

    public long getDataRowCount() {
        return this.dataRowCount;
    }

    public void setDataRowCount(long dataRowCount) {
        this.dataRowCount = dataRowCount;
    }

    public void incrementDataRowCount() {
        ++this.dataRowCount;
    }

    public void incrementDataInsertRowCount() {
        ++this.dataInsertRowCount;
    }

    public long totalRowCount() {
        return this.dataInsertRowCount + this.dataUpdateRowCount + this.dataDeleteRowCount + this.otherRowCount;
    }

    public void setLoadId(long loadId) {
        this.loadId = loadId;
    }

    public long getLoadId() {
        return this.loadId;
    }

    public void setCommonFlag(boolean commonFlag) {
        this.commonFlag = commonFlag;
    }

    public boolean isCommonFlag() {
        return this.commonFlag;
    }

    public long getFallbackInsertCount() {
        return this.fallbackInsertCount;
    }

    public void setFallbackInsertCount(long fallbackInsertCount) {
        this.fallbackInsertCount = fallbackInsertCount;
    }

    public long getFallbackUpdateCount() {
        return this.fallbackUpdateCount;
    }

    public void setFallbackUpdateCount(long fallbackUpdateCount) {
        this.fallbackUpdateCount = fallbackUpdateCount;
    }

    public long getConflictWinCount() {
        return this.conflictWinCount;
    }

    public void setConflictWinCount(long conflictWinCount) {
        this.conflictWinCount = conflictWinCount;
    }

    public long getConflictLoseCount() {
        return this.conflictLoseCount;
    }

    public void setConflictLoseCount(long conflictLoseCount) {
        this.conflictLoseCount = conflictLoseCount;
    }

    public long getMissingDeleteCount() {
        return this.missingDeleteCount;
    }

    public void setMissingDeleteCount(long missingDeleteCount) {
        this.missingDeleteCount = missingDeleteCount;
    }

    public void setSkipCount(long skipCount) {
        this.skipCount = skipCount;
    }

    public long getSkipCount() {
        return this.skipCount;
    }

    public long getIgnoreRowCount() {
        return this.ignoreRowCount;
    }

    public void incrementIgnoreRowCount() {
        ++this.ignoreRowCount;
    }

    public void setIgnoreRowCount(long ignoreRowCount) {
        this.ignoreRowCount = ignoreRowCount;
    }

    public long getLoadRowCount() {
        return this.loadRowCount;
    }

    public void setLoadRowCount(long loadRowCount) {
        this.loadRowCount = loadRowCount;
    }

    public long getLoadInsertRowCount() {
        return this.loadInsertRowCount;
    }

    public void setLoadInsertRowCount(long loadInsertRowCount) {
        this.loadInsertRowCount = loadInsertRowCount;
    }

    public long getLoadUpdateRowCount() {
        return this.loadUpdateRowCount;
    }

    public void setLoadUpdateRowCount(long loadUpdateRowCount) {
        this.loadUpdateRowCount = loadUpdateRowCount;
    }

    public long getLoadDeleteRowCount() {
        return this.loadDeleteRowCount;
    }

    public void setLoadDeleteRowCount(long loadDeleteRowCount) {
        this.loadDeleteRowCount = loadDeleteRowCount;
    }

    public long getExtractRowCount() {
        return this.extractRowCount;
    }

    public void setExtractRowCount(long extractRowCount) {
        this.extractRowCount = extractRowCount;
    }

    public long getExtractInsertRowCount() {
        return this.extractInsertRowCount;
    }

    public void setExtractInsertRowCount(long extractInsertRowCount) {
        this.extractInsertRowCount = extractInsertRowCount;
    }

    public long getExtractUpdateRowCount() {
        return this.extractUpdateRowCount;
    }

    public void setExtractUpdateRowCount(long extractUpdateRowCount) {
        this.extractUpdateRowCount = extractUpdateRowCount;
    }

    public long getExtractDeleteRowCount() {
        return this.extractDeleteRowCount;
    }

    public void setExtractDeleteRowCount(long extractDeleteRowCount) {
        this.extractDeleteRowCount = extractDeleteRowCount;
    }

    public long getFailedDataId() {
        return this.failedDataId;
    }

    public void setFailedDataId(long failedDataId) {
        this.failedDataId = failedDataId;
    }

    public void setFailedLineNumber(long failedLineNumber) {
        this.failedLineNumber = failedLineNumber;
    }

    public long getFailedLineNumber() {
        return this.failedLineNumber;
    }

    public long getProcessedRowCount() {
        return this.processedRowCount;
    }

    public void setProcessedRowCount(long processedRowCount) {
        this.processedRowCount = processedRowCount;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractBatch)) {
            return false;
        }
        AbstractBatch b = (AbstractBatch)o;
        return this.getBatchId() == b.getBatchId() && Strings.CS.equals(this.getNodeId(), b.getNodeId());
    }

    public int hashCode() {
        return (String.valueOf(this.getBatchId()) + "-" + this.getNodeId()).hashCode();
    }

    public Map<String, Map<String, Long>> getTableLoadedCount() {
        return this.tableLoadedCount;
    }

    public void setTableLoadedCount(Map<String, Map<String, Long>> tableLoadedCount) {
        this.tableLoadedCount = tableLoadedCount;
    }

    public Map<String, Map<String, Long>> getTableExtractedCount() {
        return this.tableExtractedCount;
    }

    public void setTableExtractedCount(Map<String, Map<String, Long>> tableExtractedCount) {
        this.tableExtractedCount = tableExtractedCount;
    }

    public boolean isBulkLoaderFlag() {
        return this.bulkLoaderFlag;
    }

    public void setBulkLoaderFlag(boolean bulkLoaderFlag) {
        this.bulkLoaderFlag = bulkLoaderFlag;
    }

    public static enum Status {
        OK("Ok"),
        ER("Error"),
        RQ("Request"),
        NE("New"),
        QY("Querying"),
        SE("Sending"),
        LD("Loading"),
        RT("Routing"),
        IG("Ignored"),
        RS("Resend"),
        XX("Unknown"),
        LS("LoadSetup");

        private String description;

        private Status(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String getNameFromDescription(String description) {
            for (Status status : Status.values()) {
                if (!status.toString().equals(description)) continue;
                return status.name();
            }
            return null;
        }
    }
}

