/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.AbstractColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupColumnTransform
extends AbstractColumnTransform
implements ISingleNewAndOldValueColumnTransform {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "lookup";
    protected static final StringMapper lookupColumnRowMapper = new StringMapper();

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isExtractColumnTransform() {
        return true;
    }

    public boolean isLoadColumnTransform() {
        return true;
    }

    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String sql = this.doTokenReplacementOnSql(context, column.getTransformExpression());
        String lookupValue = null;
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            int rowCount;
            ISqlTransaction transaction = context.findTransaction();
            List values = null;
            LinkedCaseInsensitiveMap namedParams = new LinkedCaseInsensitiveMap(sourceValues);
            if (data.getOldSourceValues() != null && sql.contains(":OLD_")) {
                for (Map.Entry oldColumn : data.getOldSourceValues().entrySet()) {
                    namedParams.put("OLD_" + ((String)oldColumn.getKey()).toUpperCase(), oldColumn.getValue());
                }
            }
            if (data.getTargetValues() != null && sql.contains(":TRM_")) {
                for (Map.Entry transformedCol : data.getTargetValues().entrySet()) {
                    namedParams.put("TRM_" + ((String)transformedCol.getKey()).toUpperCase(), transformedCol.getValue());
                }
            }
            if ((rowCount = (values = transaction != null ? transaction.query(sql, (ISqlRowMapper)lookupColumnRowMapper, (Map)namedParams) : platform.getSqlTemplate().query(sql, (ISqlRowMapper)lookupColumnRowMapper, (Map)namedParams)).size()) == 1) {
                lookupValue = (String)values.get(0);
            } else if (rowCount > 1) {
                lookupValue = (String)values.get(0);
                this.log.warn("Expected a single row, but returned multiple rows from lookup for target column {} on transform {} ", (Object)column.getTargetColumnName(), (Object)column.getTransformId());
            } else if (values.size() == 0) {
                this.log.info("Expected a single row, but returned no rows from lookup for target column {} on transform {}", (Object)column.getTargetColumnName(), (Object)column.getTransformId());
            }
        } else {
            this.log.warn("Expected SQL expression for lookup transform, but no expression was found for target column {} on transform {}", (Object)column.getTargetColumnName(), (Object)column.getTransformId());
        }
        return new NewAndOldValue(column, data, lookupValue);
    }

    protected String doTokenReplacementOnSql(DataContext context, String sql) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Data csvData = (Data)context.get("csvData");
            if (csvData != null && csvData.getTriggerHistory() != null) {
                sql = FormatUtils.replaceToken((String)sql, (String)"sourceCatalogName", (String)csvData.getTriggerHistory().getSourceCatalogName(), (boolean)true);
            }
            if (csvData != null && csvData.getTriggerHistory() != null) {
                sql = FormatUtils.replaceToken((String)sql, (String)"sourceSchemaName", (String)csvData.getTriggerHistory().getSourceSchemaName(), (boolean)true);
            }
        }
        return sql;
    }
}

