/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTriggerTracker {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private FileTriggerRouter fileTriggerRouter;
    private FileAlterationObserver fileObserver;
    private DirectorySnapshot lastSnapshot;
    private DirectorySnapshot changesSinceLastSnapshot;
    private SnapshotUpdater currentListener;
    private ProcessInfo processInfo;
    private ISymmetricEngine engine;
    protected boolean useCrc;
    long startTime;
    long ts = this.startTime = System.currentTimeMillis();

    public FileTriggerTracker(FileTriggerRouter fileTriggerRouter, DirectorySnapshot lastSnapshot, ProcessInfo processInfo, boolean useCrc, ISymmetricEngine engine) throws IOException {
        this.fileTriggerRouter = fileTriggerRouter;
        this.processInfo = processInfo;
        this.useCrc = useCrc;
        this.engine = engine;
        this.changesSinceLastSnapshot = new DirectorySnapshot(fileTriggerRouter);
        this.fileObserver = ((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(fileTriggerRouter.getFileTrigger().getBaseDir())).setFileFilter((FileFilter)fileTriggerRouter.getFileTrigger().createIOFileFilter()).get();
        this.currentListener = new SnapshotUpdater(this.changesSinceLastSnapshot);
        this.fileObserver.addListener((FileAlterationListener)this.currentListener);
        try {
            this.fileObserver.initialize();
            if (lastSnapshot == null) {
                lastSnapshot = new DirectorySnapshot(fileTriggerRouter);
            }
            this.lastSnapshot = lastSnapshot;
            DirectorySnapshot currentSnapshot = new DirectorySnapshot(fileTriggerRouter);
            this.takeFullSnapshot(currentSnapshot);
            this.changesSinceLastSnapshot.addAll(lastSnapshot.diff(currentSnapshot));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void pollForChanges() {
        if (this.fileObserver != null) {
            this.fileObserver.checkAndNotify();
        }
    }

    public synchronized DirectorySnapshot trackChanges() {
        this.pollForChanges();
        DirectorySnapshot changes = this.changesSinceLastSnapshot;
        if (this.log.isDebugEnabled()) {
            for (FileSnapshot s : changes) {
                this.log.debug(s.getLastEventType().getCode() + ", fileName: " + s.getFileName() + ", relativeDir: " + s.getRelativeDir());
            }
        }
        this.changesSinceLastSnapshot = new DirectorySnapshot(this.fileTriggerRouter);
        SnapshotUpdater newListener = new SnapshotUpdater(this.changesSinceLastSnapshot);
        this.fileObserver.addListener((FileAlterationListener)newListener);
        this.fileObserver.removeListener((FileAlterationListener)this.currentListener);
        this.currentListener = newListener;
        this.lastSnapshot.merge(changes);
        long runTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (changes.size() > 0) {
            this.log.info("Tracked {} files in {} seconds.  Found {} files changed.", new Object[]{this.lastSnapshot.size(), runTime, changes.size()});
        }
        return changes;
    }

    protected synchronized void takeFullSnapshot(DirectorySnapshot snapshot) throws IOException {
        FileAlterationObserver observer = ((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(this.fileTriggerRouter.getFileTrigger().getBaseDir())).setFileFilter((FileFilter)this.fileTriggerRouter.getFileTrigger().createIOFileFilter()).get();
        observer.addListener((FileAlterationListener)new SnapshotUpdater(snapshot));
        observer.checkAndNotify();
    }

    class SnapshotUpdater
    extends FileAlterationListenerAdaptor {
        DirectorySnapshot snapshot;

        SnapshotUpdater(DirectorySnapshot snapshot) {
            this.snapshot = snapshot;
        }

        public void onFileDelete(File file) {
            FileTriggerTracker.this.log.debug("File delete detected: {}", (Object)file.getAbsolutePath());
            this.addSnapshot(file, FileSnapshot.LastEventType.DELETE);
        }

        public void onFileCreate(File file) {
            if (this.snapshot.getFileTriggerRouter().getFileTrigger().isSyncOnCtlFile()) {
                this.onCtlFile(file);
            } else {
                FileTriggerTracker.this.log.debug("File create detected: {}", (Object)file.getAbsolutePath());
                this.addSnapshot(file, FileSnapshot.LastEventType.CREATE);
            }
        }

        public void onCtlFile(File file) {
            File ctlFile;
            if (this.snapshot.getFileTriggerRouter().getFileTrigger().isSyncOnCtlFile() && (ctlFile = FileTriggerTracker.this.engine.getFileSyncService().getControleFile(file)).exists()) {
                FileTriggerTracker.this.log.debug("Control file detected: {}", (Object)ctlFile.getAbsolutePath());
                this.addSnapshot(file, FileSnapshot.LastEventType.CREATE);
            }
        }

        public void onFileChange(File file) {
            FileTriggerTracker.this.log.debug("File change detected: {}", (Object)file.getAbsolutePath());
            this.addSnapshot(file, FileSnapshot.LastEventType.MODIFY);
        }

        public void onDirectoryDelete(File directory) {
            FileTriggerTracker.this.log.debug("File delete detected: {}", (Object)directory.getAbsolutePath());
            this.addSnapshot(directory, FileSnapshot.LastEventType.DELETE);
        }

        public void onDirectoryCreate(File directory) {
            FileTriggerTracker.this.log.debug("File create detected: {}", (Object)directory.getAbsolutePath());
            this.addSnapshot(directory, FileSnapshot.LastEventType.CREATE);
        }

        public void onDirectoryChange(File directory) {
        }

        protected void addSnapshot(File file, FileSnapshot.LastEventType lastEventType) {
            if (FileTriggerTracker.this.processInfo != null) {
                FileTriggerTracker.this.processInfo.incrementCurrentDataCount();
            }
            this.snapshot.add(new FileSnapshot(this.snapshot.getFileTriggerRouter(), file, lastEventType, FileTriggerTracker.this.useCrc));
            if (System.currentTimeMillis() - FileTriggerTracker.this.ts > 60000L) {
                FileTriggerTracker.this.log.info("File tracker has been processing for {} seconds.  The following stats have been gathered: {}", new Object[]{(System.currentTimeMillis() - FileTriggerTracker.this.startTime) / 1000L, "{ fileCount=" + this.snapshot.size() + " }"});
                FileTriggerTracker.this.ts = System.currentTimeMillis();
            }
        }
    }
}

