/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.MultiInstanceofPredicate;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.IDatabaseUpgradeListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUpgradeListener
implements IDatabaseUpgradeListener,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    protected boolean isUpgradeFromPre38;
    protected boolean isUpgradeFrom38;
    protected boolean isUpgradeFromPre3125;
    protected boolean isUpgradeFromPre314;
    protected boolean isUpgradeFromPre315;
    protected boolean isUpgradeFromPre316;

    @Override
    public String beforeUpgrade(ISymmetricDialect symmetricDialect, String tablePrefix, Database currentModel, Database desiredModel) throws IOException {
        Table triggerTable;
        String name;
        StringBuilder sb = new StringBuilder();
        this.isUpgradeFromPre38 = this.isUpgradeFromPre38(tablePrefix, currentModel, desiredModel);
        if (this.isUpgradeFromPre38) {
            String nodeCommunicationTable;
            String dataGapTableName;
            Table transformTable = currentModel.findTable(tablePrefix + "_transform_table");
            if (transformTable != null && transformTable.findColumn("update_action") != null) {
                this.engine.getSqlTemplate().update("update " + tablePrefix + "_transform_table set update_action = 'UPD_ROW' where update_action is null", new Object[0]);
            }
            if (currentModel.findTable(dataGapTableName = tablePrefix + "_data_gap") != null) {
                this.engine.getSqlTemplate().update("delete from " + dataGapTableName, new Object[0]);
            }
            if (currentModel.findTable(nodeCommunicationTable = tablePrefix + "_node_communication") != null) {
                this.engine.getSqlTemplate().update("delete from " + tablePrefix + "_node_communication", new Object[0]);
            }
        }
        if (this.isUpgradeFromPre310(tablePrefix, currentModel, desiredModel) && (name = this.engine.getDatabasePlatform().getName()).equals("ase")) {
            this.log.info("Before upgrade, dropping foreign key constraints to node table");
            try {
                this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_identity drop constraint " + tablePrefix + "_fk_ident_2_node", new Object[0]);
            }
            catch (Exception e) {
                this.log.info("Unable to drop FK constraint " + tablePrefix + "_fk_ident_2_node to node table", (Throwable)e);
            }
            try {
                this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_security drop constraint " + tablePrefix + "_fk_sec_2_node", new Object[0]);
            }
            catch (Exception e) {
                this.log.info("Unable to drop FK constraint " + tablePrefix + "_fk_sec_2_node to node table", (Throwable)e);
            }
        }
        if (this.isUpgradeFromPre311(tablePrefix, currentModel, desiredModel) && this.shouldFixDataEvent311(tablePrefix)) {
            this.fixDataEvent311(tablePrefix);
        }
        if (this.isUpgradeFromPre312(tablePrefix, currentModel, desiredModel)) {
            if (this.engine.getParameterService().isRegistrationServer()) {
                this.log.info("Before upgrade, fixing router_type");
                this.engine.getSqlTemplate().update("update " + tablePrefix + "_router set router_type = 'default' where router_type is null", new Object[0]);
            }
            if ((name = this.engine.getDatabasePlatform().getName()).equals("oracle") || name.equals("oracle122") || name.equals("oracle23")) {
                this.log.info("Before upgrade, dropping PK constraint for data table");
                try {
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_data drop constraint " + tablePrefix + "_data_pk", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for data table: {}", (Object)e.getMessage());
                }
            }
            if (name.equals("ase")) {
                this.log.info("Before upgrade, dropping index on data table");
                try {
                    this.engine.getSqlTemplate().update("drop index " + tablePrefix + "_data." + tablePrefix + "_idx_d_channel_id", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop index " + tablePrefix + "_idx_d_channel_id on data table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping FK constraints to router table");
                try {
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_trigger_router drop constraint " + tablePrefix + "_fk_tr_2_rtr", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop FK constraint to router table: {}", (Object)e.getMessage());
                }
                try {
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_file_trigger_router drop constraint " + tablePrefix + "_fk_ftr_2_rtr", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop FK constraint to router table: {}", (Object)e.getMessage());
                }
            }
        }
        if (this.isUpgradeFromPre3125(tablePrefix, currentModel, desiredModel)) {
            this.isUpgradeFromPre3125 = true;
        }
        this.isUpgradeFromPre314 = this.isUpgradeFromPre314(tablePrefix, currentModel, desiredModel);
        if (this.engine.getDatabasePlatform().getName().equals("informix") && (triggerTable = desiredModel.findTable(tablePrefix + "_trigger")) != null) {
            Column[] e = triggerTable.getColumns();
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                Column column = e[i];
                if (column.getMappedTypeCode() != -1) continue;
                column.setJdbcTypeCode(12);
                column.setMappedType("VARCHAR");
                column.setMappedTypeCode(12);
                column.setSize("255");
            }
        }
        if (this.isUpgradeFromPre315(tablePrefix, currentModel)) {
            this.isUpgradeFromPre315 = true;
        }
        if (this.isUpgradeFromPre315) {
            name = this.engine.getDatabasePlatform().getName();
            if (name.contains("mssql")) {
                String constraintName;
                this.log.info("Before upgrade, dropping PK constraint for reload request table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_table_reload_request')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_table_reload_request drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for reload request table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping PK constraint for node group channel wnd table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_node_group_channel_wnd')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_group_channel_wnd drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for reload request table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping PK constraint for node host channel stats table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_node_host_channel_stats')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_host_channel_stats drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for node host channel stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping PK constraint for node host job stats table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_node_host_job_stats')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_host_job_stats drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for node host job stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping PK constraint for node host stats table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_node_host_stats')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_node_host_stats drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for node host stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, dropping PK constraint for registration request table");
                try {
                    constraintName = this.engine.getSqlTemplate().queryForString("select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + tablePrefix + "_registration_request')", new Object[0]);
                    this.engine.getSqlTemplate().update("alter table " + tablePrefix + "_registration_request drop constraint " + constraintName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop PK for registration request table: {}", (Object)e.getMessage());
                }
            }
            if (name.equals("oracle") || name.equals("oracle122") || name.equals("oracle23")) {
                this.log.info("Before upgrade, truncating reload request table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_table_reload_request", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate reload request table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, truncating node group channel wnd table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_node_group_channel_wnd", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate reload request table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, truncating node host channel stats table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_node_host_channel_stats", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate node host channel stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, truncating node host job stats table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_node_host_job_stats", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate node host job stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, truncating node host stats table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_node_host_stats", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate node host stats table: {}", (Object)e.getMessage());
                }
                this.log.info("Before upgrade, truncating registration request table");
                try {
                    this.engine.getSqlTemplate().update("truncate table " + tablePrefix + "_registration_request", new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to truncate registration request table: {}", (Object)e.getMessage());
                }
            }
        }
        this.isUpgradeFromPre316 = this.isUpgradeFromPre316(tablePrefix, currentModel);
        if (this.isUpgradeFromPre316) {
            String[] tableNames;
            for (String tableName : tableNames = new String[]{tablePrefix + "_design_diagram", tablePrefix + "_diagram_group"}) {
                if (currentModel.findTable(tableName) == null) continue;
                this.dropTriggers(currentModel, tableName);
                try {
                    this.engine.getSqlTemplate().update("drop table " + tableName, new Object[0]);
                }
                catch (Exception e) {
                    this.log.info("Unable to drop table {} because: {}", (Object)tableName, (Object)e.getMessage());
                }
            }
        }
        if (this.engine.getParameterService().is("auto.sync.triggers") && currentModel.getTableCount() > 0 && currentModel.findTable(tablePrefix + "_trigger_hist") != null) {
            this.dropSymTriggersIfNecessary(currentModel, desiredModel);
        }
        return sb.toString();
    }

    protected void dropSymTriggersIfNecessary(Database currentModel, Database desiredModel) {
        List<IAlterDatabaseInterceptor> alterDatabaseInterceptors = this.engine.getExtensionService().getExtensionPointList(IAlterDatabaseInterceptor.class);
        List modelChanges = this.engine.getDatabasePlatform().getDdlBuilder().getDetectedChanges(currentModel, desiredModel, alterDatabaseInterceptors.toArray(new IAlterDatabaseInterceptor[alterDatabaseInterceptors.size()]));
        MultiInstanceofPredicate predicate = new MultiInstanceofPredicate(new Class[]{RemovePrimaryKeyChange.class, AddPrimaryKeyChange.class, PrimaryKeyChange.class, RemoveColumnChange.class, AddColumnChange.class, ColumnDataTypeChange.class, ColumnSizeChange.class, CopyColumnValueChange.class});
        Collection modelChangesAffectingTriggers = modelChanges.stream().filter(c -> predicate.test(c)).collect(Collectors.toList());
        HashSet<String> setOfTableNamesToDropTriggersFor = new HashSet<String>();
        for (IModelChange change : modelChangesAffectingTriggers) {
            if (!(change instanceof TableChange)) continue;
            setOfTableNamesToDropTriggersFor.add(((TableChange)change).getChangedTable().getName());
        }
        this.engine.getTriggerRouterService().dropTriggers(setOfTableNamesToDropTriggersFor);
    }

    @Override
    public String afterUpgrade(ISymmetricDialect symmetricDialect, String tablePrefix, Database model) throws IOException {
        if (this.isUpgradeFromPre314 && this.engine.getNodeId() != null) {
            this.log.info("Fixing extract request table after upgrade");
            this.engine.getSqlTemplate().update("update " + tablePrefix + "_extract_request set source_node_id = ? where source_node_id = 'default'", new Object[]{this.engine.getNodeId()});
        }
        this.engine.getTriggerRouterService().syncTriggers();
        StringBuilder sb = new StringBuilder();
        if (this.isUpgradeFromPre38) {
            this.engine.getSqlTemplate().update("update " + tablePrefix + "_sequence set cache_size = 10 where sequence_name = ?", new Object[]{"outgoing_batch"});
            this.engine.getSqlTemplate().update("update  " + tablePrefix + "_channel set max_batch_size = 10000 where reload_flag = 1 ", new Object[0]);
        }
        if (this.isUpgradeFromPre3125 && this.engine.getParameterService().isRegistrationServer()) {
            this.log.info("After upgrade, fixing initial_load_end_time");
            this.engine.getSqlTemplate().update("update " + tablePrefix + "_node_security set initial_load_end_time = initial_load_time where initial_load_time is not null", new Object[0]);
        }
        if (this.isUpgradeFromPre316) {
            this.log.info("After upgrading, fixing loaded_time on sym_extract_request");
            this.engine.getSqlTemplate().update("update " + tablePrefix + "_extract_request set loaded_time = last_update_time where source_node_id = ? and loaded_time is null and load_id in (select load_id from " + tablePrefix + "_table_reload_status where source_node_id = ? and completed = 1)", new Object[]{this.engine.getNodeId(), this.engine.getNodeId()});
        }
        this.engine.getPullService().pullConfigData(false);
        return sb.toString();
    }

    protected void checkForDroppedColumns(Database currentModel, Database desiredModel) {
        block0: for (Table currentTable : currentModel.getTables()) {
            Table desiredTable = desiredModel.findTable(currentTable.getName());
            if (desiredTable == null) continue;
            for (Column currentColumn : currentTable.getColumns()) {
                Column desiredColumn = desiredTable.findColumn(currentColumn.getName());
                if (desiredColumn != null) continue;
                this.dropTriggers(currentModel, currentTable.getName(), currentColumn.getName());
                continue block0;
            }
        }
    }

    protected void dropTriggers(Database currentModel, String tableName, String columnName) {
        TriggerHistory hist;
        Table table = currentModel.findTable(tableName);
        if (table != null && table.findColumn(columnName) != null && (hist = this.engine.getTriggerRouterService().findTriggerHistory(null, null, tableName)) != null) {
            this.log.info("Dropping triggers on " + tableName + " because " + columnName + " needs dropped");
            this.engine.getTriggerRouterService().dropTriggers(hist);
        }
    }

    protected void dropTriggers(Database currentModel, String tableName) {
        TriggerHistory hist;
        Table table = currentModel.findTable(tableName);
        if (table != null && (hist = this.engine.getTriggerRouterService().findTriggerHistory(null, null, tableName)) != null) {
            this.log.info("Dropping triggers on " + tableName);
            this.engine.getTriggerRouterService().dropTriggers(hist);
        }
    }

    protected boolean isUpgradeFromPre38(String tablePrefix, Database currentModel, Database desiredModel) {
        String monitorTableName = tablePrefix + "_monitor";
        String nodeTableName = tablePrefix + "_node";
        if (currentModel.findTable(nodeTableName) != null && currentModel.findTable(monitorTableName) == null && desiredModel.findTable(monitorTableName) != null) {
            this.log.info("Detected upgrade from pre-3.8 version.");
            return true;
        }
        return false;
    }

    protected boolean isUpgradeFromPre310(String tablePrefix, Database currentModel, Database desiredModel) {
        Column heartbeatTime;
        String nodeTableName = tablePrefix + "_node";
        Table nodeTable = currentModel.findTable(nodeTableName);
        return nodeTable != null && (heartbeatTime = nodeTable.getColumnWithName("heartbeat_time")) != null;
    }

    protected boolean isUpgradeFromPre311(String tablePrefix, Database currentModel, Database desiredModel) {
        Table eventTable = currentModel.findTable(tablePrefix + "_data_event");
        if (eventTable != null && eventTable.findColumn("router_id") != null) {
            this.log.info("Detected upgrade from pre-3.11 version.");
            return true;
        }
        return false;
    }

    protected boolean shouldFixDataEvent311(String tablePrefix) {
        boolean shouldFix = this.engine.getParameterService().is("upgrade.force.fix.data.event");
        if (!shouldFix && !this.engine.getParameterService().is("upgrade.skip.fix.data.event")) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            String sql = "select t.trigger_id, r.target_node_group_id from " + tablePrefix + "_trigger t inner join " + tablePrefix + "_trigger_router tr on tr.trigger_id = t.trigger_id inner join " + tablePrefix + "_router r on r.router_id = tr.router_id where r.source_node_group_id = ?";
            List rows = this.engine.getSqlTemplate().query(sql, new Object[]{this.engine.getParameterService().getNodeGroupId()});
            for (Row row : rows) {
                String key = row.getString("trigger_id") + "-" + row.getString("target_node_group_id");
                if (set.contains(key)) {
                    shouldFix = true;
                    break;
                }
                set.add((CallSite)((Object)key));
            }
        }
        return shouldFix;
    }

    protected void fixDataEvent311(String tablePrefix) {
        this.log.info("Checking data_event for upgrade");
        List rows = this.engine.getDatabasePlatform().getSqlTemplateDirty().query("select batch_id, data_id, max(router_id) router_id from " + tablePrefix + "_data_event group by batch_id, data_id having count(*) > 1");
        this.log.info("Found {} rows in data_event with duplicates", (Object)rows.size());
        if (rows.size() > 0) {
            long ts = System.currentTimeMillis();
            int commitSize = this.engine.getParameterService().getInt("job.purge.max.num.data.to.delete.in.tx");
            try (ISqlTransaction transaction = null;){
                transaction = this.engine.getSqlTemplate().startSqlTransaction();
                transaction.setInBatchMode(true);
                transaction.prepare("delete from " + tablePrefix + "_data_event where batch_id = ? and data_id = ? and router_id != ?");
                int[] types = new int[]{this.engine.getSymmetricDialect().getSqlTypeForIds(), this.engine.getSymmetricDialect().getSqlTypeForIds(), 12};
                int uncommittedCount = 0;
                int totalRowCount = 0;
                for (Row row : rows) {
                    ++totalRowCount;
                    if ((uncommittedCount += transaction.addRow((Object)row, new Object[]{row.getLong("batch_id"), row.getLong("data_id"), row.getString("router_id")}, types)) >= commitSize) {
                        transaction.commit();
                        uncommittedCount = 0;
                    }
                    if (System.currentTimeMillis() - ts <= 60000L) continue;
                    this.log.info("Processed {} of {} rows so far", (Object)totalRowCount, (Object)rows.size());
                    ts = System.currentTimeMillis();
                }
                transaction.commit();
            }
        }
        this.log.info("Done preparing data_event for upgrade");
    }

    protected boolean isUpgradeFromPre312(String tablePrefix, Database currentModel, Database desiredModel) {
        Table eventTable = currentModel.findTable(tablePrefix + "_node_security");
        if (eventTable != null && eventTable.findColumn("failed_logins") == null) {
            this.log.info("Detected upgrade from pre-3.12 version.");
            return true;
        }
        return false;
    }

    protected boolean isUpgradeFromPre3125(String tablePrefix, Database currentModel, Database desiredModel) {
        Table eventTable = currentModel.findTable(tablePrefix + "_node_security");
        if (eventTable != null && eventTable.findColumn("initial_load_end_time") == null) {
            this.log.info("Detected upgrade from pre-3.12.5 version.");
            return true;
        }
        return false;
    }

    protected boolean isUpgradeFromPre314(String tablePrefix, Database currentModel, Database desiredModel) {
        Table table = currentModel.findTable(tablePrefix + "_extract_request");
        if (table != null && table.findColumn("source_node_id") == null) {
            this.log.info("Detected upgrade from pre-3.14 version.");
            return true;
        }
        return false;
    }

    protected boolean isUpgradeFromPre315(String tablePrefix, Database currentModel) {
        Table table = currentModel.findTable(tablePrefix + "_table_reload_request");
        if (table != null) {
            Column createTime = table.findColumn("create_time");
            return createTime.getSizeAsInt() != 2;
        }
        return false;
    }

    protected boolean isUpgradeFromPre316(String tablePrefix, Database currentModel) {
        Table table = currentModel.findTable(tablePrefix + "_extract_request");
        return table != null && table.findColumn("extract_thread_id") == null;
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

